/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.devicefarm.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.services.devicefarm.model.DevicePool;
import com.amazonaws.services.devicefarm.model.Rule;
import com.amazonaws.services.devicefarm.model.transform.RuleJsonMarshaller;
import com.amazonaws.util.json.JSONWriter;
import java.util.List;

public class DevicePoolJsonMarshaller {
    private static DevicePoolJsonMarshaller instance;

    public void marshall(DevicePool devicePool, JSONWriter jsonWriter) {
        if (devicePool == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        try {
            List<Rule> rulesList;
            jsonWriter.object();
            if (devicePool.getArn() != null) {
                jsonWriter.key("arn").value((Object)devicePool.getArn());
            }
            if (devicePool.getName() != null) {
                jsonWriter.key("name").value((Object)devicePool.getName());
            }
            if (devicePool.getDescription() != null) {
                jsonWriter.key("description").value((Object)devicePool.getDescription());
            }
            if (devicePool.getType() != null) {
                jsonWriter.key("type").value((Object)devicePool.getType());
            }
            if ((rulesList = devicePool.getRules()) != null) {
                jsonWriter.key("rules");
                jsonWriter.array();
                for (Rule rulesListValue : rulesList) {
                    if (rulesListValue == null) continue;
                    RuleJsonMarshaller.getInstance().marshall(rulesListValue, jsonWriter);
                }
                jsonWriter.endArray();
            }
            jsonWriter.endObject();
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static DevicePoolJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new DevicePoolJsonMarshaller();
        }
        return instance;
    }
}

