/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.detective.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.detective.model.TimestampForCollection;
import com.amazonaws.services.detective.model.transform.MembershipDatasourcesMarshaller;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public class MembershipDatasources
implements Serializable,
Cloneable,
StructuredPojo {
    private String accountId;
    private String graphArn;
    private Map<String, Map<String, TimestampForCollection>> datasourcePackageIngestHistory;

    public void setAccountId(String accountId) {
        this.accountId = accountId;
    }

    public String getAccountId() {
        return this.accountId;
    }

    public MembershipDatasources withAccountId(String accountId) {
        this.setAccountId(accountId);
        return this;
    }

    public void setGraphArn(String graphArn) {
        this.graphArn = graphArn;
    }

    public String getGraphArn() {
        return this.graphArn;
    }

    public MembershipDatasources withGraphArn(String graphArn) {
        this.setGraphArn(graphArn);
        return this;
    }

    public Map<String, Map<String, TimestampForCollection>> getDatasourcePackageIngestHistory() {
        return this.datasourcePackageIngestHistory;
    }

    public void setDatasourcePackageIngestHistory(Map<String, Map<String, TimestampForCollection>> datasourcePackageIngestHistory) {
        this.datasourcePackageIngestHistory = datasourcePackageIngestHistory;
    }

    public MembershipDatasources withDatasourcePackageIngestHistory(Map<String, Map<String, TimestampForCollection>> datasourcePackageIngestHistory) {
        this.setDatasourcePackageIngestHistory(datasourcePackageIngestHistory);
        return this;
    }

    public MembershipDatasources addDatasourcePackageIngestHistoryEntry(String key, Map<String, TimestampForCollection> value) {
        if (null == this.datasourcePackageIngestHistory) {
            this.datasourcePackageIngestHistory = new HashMap<String, Map<String, TimestampForCollection>>();
        }
        if (this.datasourcePackageIngestHistory.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.datasourcePackageIngestHistory.put(key, value);
        return this;
    }

    public MembershipDatasources clearDatasourcePackageIngestHistoryEntries() {
        this.datasourcePackageIngestHistory = null;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getAccountId() != null) {
            sb.append("AccountId: ").append(this.getAccountId()).append(",");
        }
        if (this.getGraphArn() != null) {
            sb.append("GraphArn: ").append(this.getGraphArn()).append(",");
        }
        if (this.getDatasourcePackageIngestHistory() != null) {
            sb.append("DatasourcePackageIngestHistory: ").append(this.getDatasourcePackageIngestHistory());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MembershipDatasources)) {
            return false;
        }
        MembershipDatasources other = (MembershipDatasources)obj;
        if (other.getAccountId() == null ^ this.getAccountId() == null) {
            return false;
        }
        if (other.getAccountId() != null && !other.getAccountId().equals(this.getAccountId())) {
            return false;
        }
        if (other.getGraphArn() == null ^ this.getGraphArn() == null) {
            return false;
        }
        if (other.getGraphArn() != null && !other.getGraphArn().equals(this.getGraphArn())) {
            return false;
        }
        if (other.getDatasourcePackageIngestHistory() == null ^ this.getDatasourcePackageIngestHistory() == null) {
            return false;
        }
        return other.getDatasourcePackageIngestHistory() == null || other.getDatasourcePackageIngestHistory().equals(this.getDatasourcePackageIngestHistory());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getAccountId() == null ? 0 : this.getAccountId().hashCode());
        hashCode = 31 * hashCode + (this.getGraphArn() == null ? 0 : this.getGraphArn().hashCode());
        hashCode = 31 * hashCode + (this.getDatasourcePackageIngestHistory() == null ? 0 : this.getDatasourcePackageIngestHistory().hashCode());
        return hashCode;
    }

    public MembershipDatasources clone() {
        try {
            return (MembershipDatasources)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        MembershipDatasourcesMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

