/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.deadline.model;

import com.amazonaws.services.deadline.model.AWSDeadlineException;
import com.amazonaws.services.deadline.model.ValidationExceptionField;
import com.amazonaws.services.deadline.model.ValidationExceptionReason;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ValidationException
extends AWSDeadlineException {
    private static final long serialVersionUID = 1L;
    private Map<String, String> context;
    private List<ValidationExceptionField> fieldList;
    private String reason;

    public ValidationException(String message) {
        super(message);
    }

    @JsonProperty(value="context")
    public Map<String, String> getContext() {
        return this.context;
    }

    @JsonProperty(value="context")
    public void setContext(Map<String, String> context) {
        this.context = context;
    }

    public ValidationException withContext(Map<String, String> context) {
        this.setContext(context);
        return this;
    }

    public ValidationException addContextEntry(String key, String value) {
        if (null == this.context) {
            this.context = new HashMap<String, String>();
        }
        if (this.context.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.context.put(key, value);
        return this;
    }

    public ValidationException clearContextEntries() {
        this.context = null;
        return this;
    }

    @JsonProperty(value="fieldList")
    public List<ValidationExceptionField> getFieldList() {
        return this.fieldList;
    }

    @JsonProperty(value="fieldList")
    public void setFieldList(Collection<ValidationExceptionField> fieldList) {
        if (fieldList == null) {
            this.fieldList = null;
            return;
        }
        this.fieldList = new ArrayList<ValidationExceptionField>(fieldList);
    }

    public ValidationException withFieldList(ValidationExceptionField ... fieldList) {
        if (this.fieldList == null) {
            this.setFieldList(new ArrayList<ValidationExceptionField>(fieldList.length));
        }
        for (ValidationExceptionField ele : fieldList) {
            this.fieldList.add(ele);
        }
        return this;
    }

    public ValidationException withFieldList(Collection<ValidationExceptionField> fieldList) {
        this.setFieldList(fieldList);
        return this;
    }

    @JsonProperty(value="reason")
    public void setReason(String reason) {
        this.reason = reason;
    }

    @JsonProperty(value="reason")
    public String getReason() {
        return this.reason;
    }

    public ValidationException withReason(String reason) {
        this.setReason(reason);
        return this;
    }

    public ValidationException withReason(ValidationExceptionReason reason) {
        this.reason = reason.toString();
        return this;
    }
}

