/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.deadline.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.deadline.model.JobAttachmentSettings;
import com.amazonaws.services.deadline.model.JobParameter;
import com.amazonaws.services.deadline.model.JobRunAsUser;
import com.amazonaws.services.deadline.model.PathMappingRule;
import com.amazonaws.services.deadline.model.transform.JobDetailsEntityMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class JobDetailsEntity
implements Serializable,
Cloneable,
StructuredPojo {
    private JobAttachmentSettings jobAttachmentSettings;
    private String jobId;
    private JobRunAsUser jobRunAsUser;
    private String logGroupName;
    private Map<String, JobParameter> parameters;
    private List<PathMappingRule> pathMappingRules;
    private String queueRoleArn;
    private String schemaVersion;

    public void setJobAttachmentSettings(JobAttachmentSettings jobAttachmentSettings) {
        this.jobAttachmentSettings = jobAttachmentSettings;
    }

    public JobAttachmentSettings getJobAttachmentSettings() {
        return this.jobAttachmentSettings;
    }

    public JobDetailsEntity withJobAttachmentSettings(JobAttachmentSettings jobAttachmentSettings) {
        this.setJobAttachmentSettings(jobAttachmentSettings);
        return this;
    }

    public void setJobId(String jobId) {
        this.jobId = jobId;
    }

    public String getJobId() {
        return this.jobId;
    }

    public JobDetailsEntity withJobId(String jobId) {
        this.setJobId(jobId);
        return this;
    }

    public void setJobRunAsUser(JobRunAsUser jobRunAsUser) {
        this.jobRunAsUser = jobRunAsUser;
    }

    public JobRunAsUser getJobRunAsUser() {
        return this.jobRunAsUser;
    }

    public JobDetailsEntity withJobRunAsUser(JobRunAsUser jobRunAsUser) {
        this.setJobRunAsUser(jobRunAsUser);
        return this;
    }

    public void setLogGroupName(String logGroupName) {
        this.logGroupName = logGroupName;
    }

    public String getLogGroupName() {
        return this.logGroupName;
    }

    public JobDetailsEntity withLogGroupName(String logGroupName) {
        this.setLogGroupName(logGroupName);
        return this;
    }

    public Map<String, JobParameter> getParameters() {
        return this.parameters;
    }

    public void setParameters(Map<String, JobParameter> parameters) {
        this.parameters = parameters;
    }

    public JobDetailsEntity withParameters(Map<String, JobParameter> parameters) {
        this.setParameters(parameters);
        return this;
    }

    public JobDetailsEntity addParametersEntry(String key, JobParameter value) {
        if (null == this.parameters) {
            this.parameters = new HashMap<String, JobParameter>();
        }
        if (this.parameters.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.parameters.put(key, value);
        return this;
    }

    public JobDetailsEntity clearParametersEntries() {
        this.parameters = null;
        return this;
    }

    public List<PathMappingRule> getPathMappingRules() {
        return this.pathMappingRules;
    }

    public void setPathMappingRules(Collection<PathMappingRule> pathMappingRules) {
        if (pathMappingRules == null) {
            this.pathMappingRules = null;
            return;
        }
        this.pathMappingRules = new ArrayList<PathMappingRule>(pathMappingRules);
    }

    public JobDetailsEntity withPathMappingRules(PathMappingRule ... pathMappingRules) {
        if (this.pathMappingRules == null) {
            this.setPathMappingRules(new ArrayList<PathMappingRule>(pathMappingRules.length));
        }
        for (PathMappingRule ele : pathMappingRules) {
            this.pathMappingRules.add(ele);
        }
        return this;
    }

    public JobDetailsEntity withPathMappingRules(Collection<PathMappingRule> pathMappingRules) {
        this.setPathMappingRules(pathMappingRules);
        return this;
    }

    public void setQueueRoleArn(String queueRoleArn) {
        this.queueRoleArn = queueRoleArn;
    }

    public String getQueueRoleArn() {
        return this.queueRoleArn;
    }

    public JobDetailsEntity withQueueRoleArn(String queueRoleArn) {
        this.setQueueRoleArn(queueRoleArn);
        return this;
    }

    public void setSchemaVersion(String schemaVersion) {
        this.schemaVersion = schemaVersion;
    }

    public String getSchemaVersion() {
        return this.schemaVersion;
    }

    public JobDetailsEntity withSchemaVersion(String schemaVersion) {
        this.setSchemaVersion(schemaVersion);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getJobAttachmentSettings() != null) {
            sb.append("JobAttachmentSettings: ").append(this.getJobAttachmentSettings()).append(",");
        }
        if (this.getJobId() != null) {
            sb.append("JobId: ").append(this.getJobId()).append(",");
        }
        if (this.getJobRunAsUser() != null) {
            sb.append("JobRunAsUser: ").append(this.getJobRunAsUser()).append(",");
        }
        if (this.getLogGroupName() != null) {
            sb.append("LogGroupName: ").append(this.getLogGroupName()).append(",");
        }
        if (this.getParameters() != null) {
            sb.append("Parameters: ").append("***Sensitive Data Redacted***").append(",");
        }
        if (this.getPathMappingRules() != null) {
            sb.append("PathMappingRules: ").append("***Sensitive Data Redacted***").append(",");
        }
        if (this.getQueueRoleArn() != null) {
            sb.append("QueueRoleArn: ").append(this.getQueueRoleArn()).append(",");
        }
        if (this.getSchemaVersion() != null) {
            sb.append("SchemaVersion: ").append(this.getSchemaVersion());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof JobDetailsEntity)) {
            return false;
        }
        JobDetailsEntity other = (JobDetailsEntity)obj;
        if (other.getJobAttachmentSettings() == null ^ this.getJobAttachmentSettings() == null) {
            return false;
        }
        if (other.getJobAttachmentSettings() != null && !other.getJobAttachmentSettings().equals(this.getJobAttachmentSettings())) {
            return false;
        }
        if (other.getJobId() == null ^ this.getJobId() == null) {
            return false;
        }
        if (other.getJobId() != null && !other.getJobId().equals(this.getJobId())) {
            return false;
        }
        if (other.getJobRunAsUser() == null ^ this.getJobRunAsUser() == null) {
            return false;
        }
        if (other.getJobRunAsUser() != null && !other.getJobRunAsUser().equals(this.getJobRunAsUser())) {
            return false;
        }
        if (other.getLogGroupName() == null ^ this.getLogGroupName() == null) {
            return false;
        }
        if (other.getLogGroupName() != null && !other.getLogGroupName().equals(this.getLogGroupName())) {
            return false;
        }
        if (other.getParameters() == null ^ this.getParameters() == null) {
            return false;
        }
        if (other.getParameters() != null && !other.getParameters().equals(this.getParameters())) {
            return false;
        }
        if (other.getPathMappingRules() == null ^ this.getPathMappingRules() == null) {
            return false;
        }
        if (other.getPathMappingRules() != null && !other.getPathMappingRules().equals(this.getPathMappingRules())) {
            return false;
        }
        if (other.getQueueRoleArn() == null ^ this.getQueueRoleArn() == null) {
            return false;
        }
        if (other.getQueueRoleArn() != null && !other.getQueueRoleArn().equals(this.getQueueRoleArn())) {
            return false;
        }
        if (other.getSchemaVersion() == null ^ this.getSchemaVersion() == null) {
            return false;
        }
        return other.getSchemaVersion() == null || other.getSchemaVersion().equals(this.getSchemaVersion());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getJobAttachmentSettings() == null ? 0 : this.getJobAttachmentSettings().hashCode());
        hashCode = 31 * hashCode + (this.getJobId() == null ? 0 : this.getJobId().hashCode());
        hashCode = 31 * hashCode + (this.getJobRunAsUser() == null ? 0 : this.getJobRunAsUser().hashCode());
        hashCode = 31 * hashCode + (this.getLogGroupName() == null ? 0 : this.getLogGroupName().hashCode());
        hashCode = 31 * hashCode + (this.getParameters() == null ? 0 : this.getParameters().hashCode());
        hashCode = 31 * hashCode + (this.getPathMappingRules() == null ? 0 : this.getPathMappingRules().hashCode());
        hashCode = 31 * hashCode + (this.getQueueRoleArn() == null ? 0 : this.getQueueRoleArn().hashCode());
        hashCode = 31 * hashCode + (this.getSchemaVersion() == null ? 0 : this.getSchemaVersion().hashCode());
        return hashCode;
    }

    public JobDetailsEntity clone() {
        try {
            return (JobDetailsEntity)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        JobDetailsEntityMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

