/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.datazone.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.datazone.model.SubscribedAsset;
import java.util.Date;

@SdkInternalApi
public class SubscribedAssetMarshaller {
    private static final MarshallingInfo<String> ASSETID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("assetId").build();
    private static final MarshallingInfo<String> ASSETREVISION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("assetRevision").build();
    private static final MarshallingInfo<StructuredPojo> FAILURECAUSE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("failureCause").build();
    private static final MarshallingInfo<Date> FAILURETIMESTAMP_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("failureTimestamp").timestampFormat("unixTimestamp").build();
    private static final MarshallingInfo<Date> GRANTEDTIMESTAMP_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("grantedTimestamp").timestampFormat("unixTimestamp").build();
    private static final MarshallingInfo<String> STATUS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("status").build();
    private static final MarshallingInfo<String> TARGETNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("targetName").build();
    private static final SubscribedAssetMarshaller instance = new SubscribedAssetMarshaller();

    public static SubscribedAssetMarshaller getInstance() {
        return instance;
    }

    public void marshall(SubscribedAsset subscribedAsset, ProtocolMarshaller protocolMarshaller) {
        if (subscribedAsset == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)subscribedAsset.getAssetId(), ASSETID_BINDING);
            protocolMarshaller.marshall((Object)subscribedAsset.getAssetRevision(), ASSETREVISION_BINDING);
            protocolMarshaller.marshall((Object)subscribedAsset.getFailureCause(), FAILURECAUSE_BINDING);
            protocolMarshaller.marshall((Object)subscribedAsset.getFailureTimestamp(), FAILURETIMESTAMP_BINDING);
            protocolMarshaller.marshall((Object)subscribedAsset.getGrantedTimestamp(), GRANTEDTIMESTAMP_BINDING);
            protocolMarshaller.marshall((Object)subscribedAsset.getStatus(), STATUS_BINDING);
            protocolMarshaller.marshall((Object)subscribedAsset.getTargetName(), TARGETNAME_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

