/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.datazone.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.datazone.model.AssetItem;
import java.util.Date;
import java.util.List;

@SdkInternalApi
public class AssetItemMarshaller {
    private static final MarshallingInfo<StructuredPojo> ADDITIONALATTRIBUTES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("additionalAttributes").build();
    private static final MarshallingInfo<Date> CREATEDAT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("createdAt").timestampFormat("unixTimestamp").build();
    private static final MarshallingInfo<String> CREATEDBY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("createdBy").build();
    private static final MarshallingInfo<String> DESCRIPTION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("description").build();
    private static final MarshallingInfo<String> DOMAINID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("domainId").build();
    private static final MarshallingInfo<String> EXTERNALIDENTIFIER_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("externalIdentifier").build();
    private static final MarshallingInfo<Date> FIRSTREVISIONCREATEDAT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("firstRevisionCreatedAt").timestampFormat("unixTimestamp").build();
    private static final MarshallingInfo<String> FIRSTREVISIONCREATEDBY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("firstRevisionCreatedBy").build();
    private static final MarshallingInfo<List> GLOSSARYTERMS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("glossaryTerms").build();
    private static final MarshallingInfo<String> IDENTIFIER_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("identifier").build();
    private static final MarshallingInfo<String> NAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("name").build();
    private static final MarshallingInfo<String> OWNINGPROJECTID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("owningProjectId").build();
    private static final MarshallingInfo<String> TYPEIDENTIFIER_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("typeIdentifier").build();
    private static final MarshallingInfo<String> TYPEREVISION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("typeRevision").build();
    private static final AssetItemMarshaller instance = new AssetItemMarshaller();

    public static AssetItemMarshaller getInstance() {
        return instance;
    }

    public void marshall(AssetItem assetItem, ProtocolMarshaller protocolMarshaller) {
        if (assetItem == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)assetItem.getAdditionalAttributes(), ADDITIONALATTRIBUTES_BINDING);
            protocolMarshaller.marshall((Object)assetItem.getCreatedAt(), CREATEDAT_BINDING);
            protocolMarshaller.marshall((Object)assetItem.getCreatedBy(), CREATEDBY_BINDING);
            protocolMarshaller.marshall((Object)assetItem.getDescription(), DESCRIPTION_BINDING);
            protocolMarshaller.marshall((Object)assetItem.getDomainId(), DOMAINID_BINDING);
            protocolMarshaller.marshall((Object)assetItem.getExternalIdentifier(), EXTERNALIDENTIFIER_BINDING);
            protocolMarshaller.marshall((Object)assetItem.getFirstRevisionCreatedAt(), FIRSTREVISIONCREATEDAT_BINDING);
            protocolMarshaller.marshall((Object)assetItem.getFirstRevisionCreatedBy(), FIRSTREVISIONCREATEDBY_BINDING);
            protocolMarshaller.marshall(assetItem.getGlossaryTerms(), GLOSSARYTERMS_BINDING);
            protocolMarshaller.marshall((Object)assetItem.getIdentifier(), IDENTIFIER_BINDING);
            protocolMarshaller.marshall((Object)assetItem.getName(), NAME_BINDING);
            protocolMarshaller.marshall((Object)assetItem.getOwningProjectId(), OWNINGPROJECTID_BINDING);
            protocolMarshaller.marshall((Object)assetItem.getTypeIdentifier(), TYPEIDENTIFIER_BINDING);
            protocolMarshaller.marshall((Object)assetItem.getTypeRevision(), TYPEREVISION_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

