/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.datasync.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.datasync.model.ResourceMetrics;
import java.util.Date;

@SdkInternalApi
public class ResourceMetricsMarshaller {
    private static final MarshallingInfo<Date> TIMESTAMP_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Timestamp").timestampFormat("unixTimestamp").build();
    private static final MarshallingInfo<StructuredPojo> P95METRICS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("P95Metrics").build();
    private static final MarshallingInfo<StructuredPojo> CAPACITY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Capacity").build();
    private static final MarshallingInfo<String> RESOURCEID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ResourceId").build();
    private static final MarshallingInfo<String> RESOURCETYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ResourceType").build();
    private static final ResourceMetricsMarshaller instance = new ResourceMetricsMarshaller();

    public static ResourceMetricsMarshaller getInstance() {
        return instance;
    }

    public void marshall(ResourceMetrics resourceMetrics, ProtocolMarshaller protocolMarshaller) {
        if (resourceMetrics == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)resourceMetrics.getTimestamp(), TIMESTAMP_BINDING);
            protocolMarshaller.marshall((Object)resourceMetrics.getP95Metrics(), P95METRICS_BINDING);
            protocolMarshaller.marshall((Object)resourceMetrics.getCapacity(), CAPACITY_BINDING);
            protocolMarshaller.marshall((Object)resourceMetrics.getResourceId(), RESOURCEID_BINDING);
            protocolMarshaller.marshall((Object)resourceMetrics.getResourceType(), RESOURCETYPE_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

