/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.datasync.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.datasync.model.S3Config;
import com.amazonaws.services.datasync.model.TagListEntry;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class CreateLocationS3Request
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String subdirectory;
    private String s3BucketArn;
    private S3Config s3Config;
    private List<TagListEntry> tags;

    public void setSubdirectory(String subdirectory) {
        this.subdirectory = subdirectory;
    }

    public String getSubdirectory() {
        return this.subdirectory;
    }

    public CreateLocationS3Request withSubdirectory(String subdirectory) {
        this.setSubdirectory(subdirectory);
        return this;
    }

    public void setS3BucketArn(String s3BucketArn) {
        this.s3BucketArn = s3BucketArn;
    }

    public String getS3BucketArn() {
        return this.s3BucketArn;
    }

    public CreateLocationS3Request withS3BucketArn(String s3BucketArn) {
        this.setS3BucketArn(s3BucketArn);
        return this;
    }

    public void setS3Config(S3Config s3Config) {
        this.s3Config = s3Config;
    }

    public S3Config getS3Config() {
        return this.s3Config;
    }

    public CreateLocationS3Request withS3Config(S3Config s3Config) {
        this.setS3Config(s3Config);
        return this;
    }

    public List<TagListEntry> getTags() {
        return this.tags;
    }

    public void setTags(Collection<TagListEntry> tags) {
        if (tags == null) {
            this.tags = null;
            return;
        }
        this.tags = new ArrayList<TagListEntry>(tags);
    }

    public CreateLocationS3Request withTags(TagListEntry ... tags) {
        if (this.tags == null) {
            this.setTags(new ArrayList<TagListEntry>(tags.length));
        }
        for (TagListEntry ele : tags) {
            this.tags.add(ele);
        }
        return this;
    }

    public CreateLocationS3Request withTags(Collection<TagListEntry> tags) {
        this.setTags(tags);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getSubdirectory() != null) {
            sb.append("Subdirectory: ").append(this.getSubdirectory()).append(",");
        }
        if (this.getS3BucketArn() != null) {
            sb.append("S3BucketArn: ").append(this.getS3BucketArn()).append(",");
        }
        if (this.getS3Config() != null) {
            sb.append("S3Config: ").append(this.getS3Config()).append(",");
        }
        if (this.getTags() != null) {
            sb.append("Tags: ").append(this.getTags());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateLocationS3Request)) {
            return false;
        }
        CreateLocationS3Request other = (CreateLocationS3Request)obj;
        if (other.getSubdirectory() == null ^ this.getSubdirectory() == null) {
            return false;
        }
        if (other.getSubdirectory() != null && !other.getSubdirectory().equals(this.getSubdirectory())) {
            return false;
        }
        if (other.getS3BucketArn() == null ^ this.getS3BucketArn() == null) {
            return false;
        }
        if (other.getS3BucketArn() != null && !other.getS3BucketArn().equals(this.getS3BucketArn())) {
            return false;
        }
        if (other.getS3Config() == null ^ this.getS3Config() == null) {
            return false;
        }
        if (other.getS3Config() != null && !other.getS3Config().equals(this.getS3Config())) {
            return false;
        }
        if (other.getTags() == null ^ this.getTags() == null) {
            return false;
        }
        return other.getTags() == null || other.getTags().equals(this.getTags());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getSubdirectory() == null ? 0 : this.getSubdirectory().hashCode());
        hashCode = 31 * hashCode + (this.getS3BucketArn() == null ? 0 : this.getS3BucketArn().hashCode());
        hashCode = 31 * hashCode + (this.getS3Config() == null ? 0 : this.getS3Config().hashCode());
        hashCode = 31 * hashCode + (this.getTags() == null ? 0 : this.getTags().hashCode());
        return hashCode;
    }

    public CreateLocationS3Request clone() {
        return (CreateLocationS3Request)super.clone();
    }
}

