/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.dataexchange.model;

import com.amazonaws.AmazonWebServiceResult;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.services.dataexchange.model.AssetEntry;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ListRevisionAssetsResult
extends AmazonWebServiceResult<ResponseMetadata>
implements Serializable,
Cloneable {
    private List<AssetEntry> assets;
    private String nextToken;

    public List<AssetEntry> getAssets() {
        return this.assets;
    }

    public void setAssets(Collection<AssetEntry> assets) {
        if (assets == null) {
            this.assets = null;
            return;
        }
        this.assets = new ArrayList<AssetEntry>(assets);
    }

    public ListRevisionAssetsResult withAssets(AssetEntry ... assets) {
        if (this.assets == null) {
            this.setAssets(new ArrayList<AssetEntry>(assets.length));
        }
        for (AssetEntry ele : assets) {
            this.assets.add(ele);
        }
        return this;
    }

    public ListRevisionAssetsResult withAssets(Collection<AssetEntry> assets) {
        this.setAssets(assets);
        return this;
    }

    public void setNextToken(String nextToken) {
        this.nextToken = nextToken;
    }

    public String getNextToken() {
        return this.nextToken;
    }

    public ListRevisionAssetsResult withNextToken(String nextToken) {
        this.setNextToken(nextToken);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getAssets() != null) {
            sb.append("Assets: ").append(this.getAssets()).append(",");
        }
        if (this.getNextToken() != null) {
            sb.append("NextToken: ").append(this.getNextToken());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListRevisionAssetsResult)) {
            return false;
        }
        ListRevisionAssetsResult other = (ListRevisionAssetsResult)obj;
        if (other.getAssets() == null ^ this.getAssets() == null) {
            return false;
        }
        if (other.getAssets() != null && !other.getAssets().equals(this.getAssets())) {
            return false;
        }
        if (other.getNextToken() == null ^ this.getNextToken() == null) {
            return false;
        }
        return other.getNextToken() == null || other.getNextToken().equals(this.getNextToken());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getAssets() == null ? 0 : this.getAssets().hashCode());
        hashCode = 31 * hashCode + (this.getNextToken() == null ? 0 : this.getNextToken().hashCode());
        return hashCode;
    }

    public ListRevisionAssetsResult clone() {
        try {
            return (ListRevisionAssetsResult)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

