/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.customerprofiles.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.customerprofiles.model.S3ExportingLocation;

@SdkInternalApi
public class S3ExportingLocationMarshaller {
    private static final MarshallingInfo<String> S3BUCKETNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("S3BucketName").build();
    private static final MarshallingInfo<String> S3KEYNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("S3KeyName").build();
    private static final S3ExportingLocationMarshaller instance = new S3ExportingLocationMarshaller();

    public static S3ExportingLocationMarshaller getInstance() {
        return instance;
    }

    public void marshall(S3ExportingLocation s3ExportingLocation, ProtocolMarshaller protocolMarshaller) {
        if (s3ExportingLocation == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)s3ExportingLocation.getS3BucketName(), S3BUCKETNAME_BINDING);
            protocolMarshaller.marshall((Object)s3ExportingLocation.getS3KeyName(), S3KEYNAME_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

