/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.customerprofiles.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.customerprofiles.model.transform.ObjectFilterMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ObjectFilter
implements Serializable,
Cloneable,
StructuredPojo {
    private String keyName;
    private List<String> values;

    public void setKeyName(String keyName) {
        this.keyName = keyName;
    }

    public String getKeyName() {
        return this.keyName;
    }

    public ObjectFilter withKeyName(String keyName) {
        this.setKeyName(keyName);
        return this;
    }

    public List<String> getValues() {
        return this.values;
    }

    public void setValues(Collection<String> values) {
        if (values == null) {
            this.values = null;
            return;
        }
        this.values = new ArrayList<String>(values);
    }

    public ObjectFilter withValues(String ... values) {
        if (this.values == null) {
            this.setValues(new ArrayList<String>(values.length));
        }
        for (String ele : values) {
            this.values.add(ele);
        }
        return this;
    }

    public ObjectFilter withValues(Collection<String> values) {
        this.setValues(values);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getKeyName() != null) {
            sb.append("KeyName: ").append(this.getKeyName()).append(",");
        }
        if (this.getValues() != null) {
            sb.append("Values: ").append(this.getValues());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ObjectFilter)) {
            return false;
        }
        ObjectFilter other = (ObjectFilter)obj;
        if (other.getKeyName() == null ^ this.getKeyName() == null) {
            return false;
        }
        if (other.getKeyName() != null && !other.getKeyName().equals(this.getKeyName())) {
            return false;
        }
        if (other.getValues() == null ^ this.getValues() == null) {
            return false;
        }
        return other.getValues() == null || other.getValues().equals(this.getValues());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getKeyName() == null ? 0 : this.getKeyName().hashCode());
        hashCode = 31 * hashCode + (this.getValues() == null ? 0 : this.getValues().hashCode());
        return hashCode;
    }

    public ObjectFilter clone() {
        try {
            return (ObjectFilter)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ObjectFilterMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

