/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.customerprofiles.model;

import com.amazonaws.AmazonWebServiceResult;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.services.customerprofiles.model.MatchItem;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;

public class GetMatchesResult
extends AmazonWebServiceResult<ResponseMetadata>
implements Serializable,
Cloneable {
    private String nextToken;
    private Date matchGenerationDate;
    private Integer potentialMatches;
    private List<MatchItem> matches;

    public void setNextToken(String nextToken) {
        this.nextToken = nextToken;
    }

    public String getNextToken() {
        return this.nextToken;
    }

    public GetMatchesResult withNextToken(String nextToken) {
        this.setNextToken(nextToken);
        return this;
    }

    public void setMatchGenerationDate(Date matchGenerationDate) {
        this.matchGenerationDate = matchGenerationDate;
    }

    public Date getMatchGenerationDate() {
        return this.matchGenerationDate;
    }

    public GetMatchesResult withMatchGenerationDate(Date matchGenerationDate) {
        this.setMatchGenerationDate(matchGenerationDate);
        return this;
    }

    public void setPotentialMatches(Integer potentialMatches) {
        this.potentialMatches = potentialMatches;
    }

    public Integer getPotentialMatches() {
        return this.potentialMatches;
    }

    public GetMatchesResult withPotentialMatches(Integer potentialMatches) {
        this.setPotentialMatches(potentialMatches);
        return this;
    }

    public List<MatchItem> getMatches() {
        return this.matches;
    }

    public void setMatches(Collection<MatchItem> matches) {
        if (matches == null) {
            this.matches = null;
            return;
        }
        this.matches = new ArrayList<MatchItem>(matches);
    }

    public GetMatchesResult withMatches(MatchItem ... matches) {
        if (this.matches == null) {
            this.setMatches(new ArrayList<MatchItem>(matches.length));
        }
        for (MatchItem ele : matches) {
            this.matches.add(ele);
        }
        return this;
    }

    public GetMatchesResult withMatches(Collection<MatchItem> matches) {
        this.setMatches(matches);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getNextToken() != null) {
            sb.append("NextToken: ").append(this.getNextToken()).append(",");
        }
        if (this.getMatchGenerationDate() != null) {
            sb.append("MatchGenerationDate: ").append(this.getMatchGenerationDate()).append(",");
        }
        if (this.getPotentialMatches() != null) {
            sb.append("PotentialMatches: ").append(this.getPotentialMatches()).append(",");
        }
        if (this.getMatches() != null) {
            sb.append("Matches: ").append(this.getMatches());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetMatchesResult)) {
            return false;
        }
        GetMatchesResult other = (GetMatchesResult)obj;
        if (other.getNextToken() == null ^ this.getNextToken() == null) {
            return false;
        }
        if (other.getNextToken() != null && !other.getNextToken().equals(this.getNextToken())) {
            return false;
        }
        if (other.getMatchGenerationDate() == null ^ this.getMatchGenerationDate() == null) {
            return false;
        }
        if (other.getMatchGenerationDate() != null && !other.getMatchGenerationDate().equals(this.getMatchGenerationDate())) {
            return false;
        }
        if (other.getPotentialMatches() == null ^ this.getPotentialMatches() == null) {
            return false;
        }
        if (other.getPotentialMatches() != null && !other.getPotentialMatches().equals(this.getPotentialMatches())) {
            return false;
        }
        if (other.getMatches() == null ^ this.getMatches() == null) {
            return false;
        }
        return other.getMatches() == null || other.getMatches().equals(this.getMatches());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getNextToken() == null ? 0 : this.getNextToken().hashCode());
        hashCode = 31 * hashCode + (this.getMatchGenerationDate() == null ? 0 : this.getMatchGenerationDate().hashCode());
        hashCode = 31 * hashCode + (this.getPotentialMatches() == null ? 0 : this.getPotentialMatches().hashCode());
        hashCode = 31 * hashCode + (this.getMatches() == null ? 0 : this.getMatches().hashCode());
        return hashCode;
    }

    public GetMatchesResult clone() {
        try {
            return (GetMatchesResult)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

