/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.customerprofiles.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.customerprofiles.model.EventStreamSummary;
import java.util.Date;
import java.util.Map;

@SdkInternalApi
public class EventStreamSummaryMarshaller {
    private static final MarshallingInfo<String> DOMAINNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DomainName").build();
    private static final MarshallingInfo<String> EVENTSTREAMNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("EventStreamName").build();
    private static final MarshallingInfo<String> EVENTSTREAMARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("EventStreamArn").build();
    private static final MarshallingInfo<String> STATE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("State").build();
    private static final MarshallingInfo<Date> STOPPEDSINCE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("StoppedSince").timestampFormat("unixTimestamp").build();
    private static final MarshallingInfo<StructuredPojo> DESTINATIONSUMMARY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DestinationSummary").build();
    private static final MarshallingInfo<Map> TAGS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.MAP).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Tags").build();
    private static final EventStreamSummaryMarshaller instance = new EventStreamSummaryMarshaller();

    public static EventStreamSummaryMarshaller getInstance() {
        return instance;
    }

    public void marshall(EventStreamSummary eventStreamSummary, ProtocolMarshaller protocolMarshaller) {
        if (eventStreamSummary == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)eventStreamSummary.getDomainName(), DOMAINNAME_BINDING);
            protocolMarshaller.marshall((Object)eventStreamSummary.getEventStreamName(), EVENTSTREAMNAME_BINDING);
            protocolMarshaller.marshall((Object)eventStreamSummary.getEventStreamArn(), EVENTSTREAMARN_BINDING);
            protocolMarshaller.marshall((Object)eventStreamSummary.getState(), STATE_BINDING);
            protocolMarshaller.marshall((Object)eventStreamSummary.getStoppedSince(), STOPPEDSINCE_BINDING);
            protocolMarshaller.marshall((Object)eventStreamSummary.getDestinationSummary(), DESTINATIONSUMMARY_BINDING);
            protocolMarshaller.marshall(eventStreamSummary.getTags(), TAGS_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

