/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.costexplorer.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.costexplorer.model.Anomaly;
import java.util.List;

@SdkInternalApi
public class AnomalyMarshaller {
    private static final MarshallingInfo<String> ANOMALYID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("AnomalyId").build();
    private static final MarshallingInfo<String> ANOMALYSTARTDATE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("AnomalyStartDate").build();
    private static final MarshallingInfo<String> ANOMALYENDDATE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("AnomalyEndDate").build();
    private static final MarshallingInfo<String> DIMENSIONVALUE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DimensionValue").build();
    private static final MarshallingInfo<List> ROOTCAUSES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("RootCauses").build();
    private static final MarshallingInfo<StructuredPojo> ANOMALYSCORE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("AnomalyScore").build();
    private static final MarshallingInfo<StructuredPojo> IMPACT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Impact").build();
    private static final MarshallingInfo<String> MONITORARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("MonitorArn").build();
    private static final MarshallingInfo<String> FEEDBACK_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Feedback").build();
    private static final AnomalyMarshaller instance = new AnomalyMarshaller();

    public static AnomalyMarshaller getInstance() {
        return instance;
    }

    public void marshall(Anomaly anomaly, ProtocolMarshaller protocolMarshaller) {
        if (anomaly == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)anomaly.getAnomalyId(), ANOMALYID_BINDING);
            protocolMarshaller.marshall((Object)anomaly.getAnomalyStartDate(), ANOMALYSTARTDATE_BINDING);
            protocolMarshaller.marshall((Object)anomaly.getAnomalyEndDate(), ANOMALYENDDATE_BINDING);
            protocolMarshaller.marshall((Object)anomaly.getDimensionValue(), DIMENSIONVALUE_BINDING);
            protocolMarshaller.marshall(anomaly.getRootCauses(), ROOTCAUSES_BINDING);
            protocolMarshaller.marshall((Object)anomaly.getAnomalyScore(), ANOMALYSCORE_BINDING);
            protocolMarshaller.marshall((Object)anomaly.getImpact(), IMPACT_BINDING);
            protocolMarshaller.marshall((Object)anomaly.getMonitorArn(), MONITORARN_BINDING);
            protocolMarshaller.marshall((Object)anomaly.getFeedback(), FEEDBACK_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

