/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.costexplorer;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.client.AwsAsyncClientParams;
import com.amazonaws.client.AwsSyncClientParams;
import com.amazonaws.handlers.AsyncHandler;
import com.amazonaws.services.costexplorer.AWSCostExplorerAsync;
import com.amazonaws.services.costexplorer.AWSCostExplorerAsyncClientBuilder;
import com.amazonaws.services.costexplorer.AWSCostExplorerClient;
import com.amazonaws.services.costexplorer.model.CreateAnomalyMonitorRequest;
import com.amazonaws.services.costexplorer.model.CreateAnomalyMonitorResult;
import com.amazonaws.services.costexplorer.model.CreateAnomalySubscriptionRequest;
import com.amazonaws.services.costexplorer.model.CreateAnomalySubscriptionResult;
import com.amazonaws.services.costexplorer.model.CreateCostCategoryDefinitionRequest;
import com.amazonaws.services.costexplorer.model.CreateCostCategoryDefinitionResult;
import com.amazonaws.services.costexplorer.model.DeleteAnomalyMonitorRequest;
import com.amazonaws.services.costexplorer.model.DeleteAnomalyMonitorResult;
import com.amazonaws.services.costexplorer.model.DeleteAnomalySubscriptionRequest;
import com.amazonaws.services.costexplorer.model.DeleteAnomalySubscriptionResult;
import com.amazonaws.services.costexplorer.model.DeleteCostCategoryDefinitionRequest;
import com.amazonaws.services.costexplorer.model.DeleteCostCategoryDefinitionResult;
import com.amazonaws.services.costexplorer.model.DescribeCostCategoryDefinitionRequest;
import com.amazonaws.services.costexplorer.model.DescribeCostCategoryDefinitionResult;
import com.amazonaws.services.costexplorer.model.GetAnomaliesRequest;
import com.amazonaws.services.costexplorer.model.GetAnomaliesResult;
import com.amazonaws.services.costexplorer.model.GetAnomalyMonitorsRequest;
import com.amazonaws.services.costexplorer.model.GetAnomalyMonitorsResult;
import com.amazonaws.services.costexplorer.model.GetAnomalySubscriptionsRequest;
import com.amazonaws.services.costexplorer.model.GetAnomalySubscriptionsResult;
import com.amazonaws.services.costexplorer.model.GetCostAndUsageRequest;
import com.amazonaws.services.costexplorer.model.GetCostAndUsageResult;
import com.amazonaws.services.costexplorer.model.GetCostAndUsageWithResourcesRequest;
import com.amazonaws.services.costexplorer.model.GetCostAndUsageWithResourcesResult;
import com.amazonaws.services.costexplorer.model.GetCostCategoriesRequest;
import com.amazonaws.services.costexplorer.model.GetCostCategoriesResult;
import com.amazonaws.services.costexplorer.model.GetCostForecastRequest;
import com.amazonaws.services.costexplorer.model.GetCostForecastResult;
import com.amazonaws.services.costexplorer.model.GetDimensionValuesRequest;
import com.amazonaws.services.costexplorer.model.GetDimensionValuesResult;
import com.amazonaws.services.costexplorer.model.GetReservationCoverageRequest;
import com.amazonaws.services.costexplorer.model.GetReservationCoverageResult;
import com.amazonaws.services.costexplorer.model.GetReservationPurchaseRecommendationRequest;
import com.amazonaws.services.costexplorer.model.GetReservationPurchaseRecommendationResult;
import com.amazonaws.services.costexplorer.model.GetReservationUtilizationRequest;
import com.amazonaws.services.costexplorer.model.GetReservationUtilizationResult;
import com.amazonaws.services.costexplorer.model.GetRightsizingRecommendationRequest;
import com.amazonaws.services.costexplorer.model.GetRightsizingRecommendationResult;
import com.amazonaws.services.costexplorer.model.GetSavingsPlanPurchaseRecommendationDetailsRequest;
import com.amazonaws.services.costexplorer.model.GetSavingsPlanPurchaseRecommendationDetailsResult;
import com.amazonaws.services.costexplorer.model.GetSavingsPlansCoverageRequest;
import com.amazonaws.services.costexplorer.model.GetSavingsPlansCoverageResult;
import com.amazonaws.services.costexplorer.model.GetSavingsPlansPurchaseRecommendationRequest;
import com.amazonaws.services.costexplorer.model.GetSavingsPlansPurchaseRecommendationResult;
import com.amazonaws.services.costexplorer.model.GetSavingsPlansUtilizationDetailsRequest;
import com.amazonaws.services.costexplorer.model.GetSavingsPlansUtilizationDetailsResult;
import com.amazonaws.services.costexplorer.model.GetSavingsPlansUtilizationRequest;
import com.amazonaws.services.costexplorer.model.GetSavingsPlansUtilizationResult;
import com.amazonaws.services.costexplorer.model.GetTagsRequest;
import com.amazonaws.services.costexplorer.model.GetTagsResult;
import com.amazonaws.services.costexplorer.model.GetUsageForecastRequest;
import com.amazonaws.services.costexplorer.model.GetUsageForecastResult;
import com.amazonaws.services.costexplorer.model.ListCostAllocationTagsRequest;
import com.amazonaws.services.costexplorer.model.ListCostAllocationTagsResult;
import com.amazonaws.services.costexplorer.model.ListCostCategoryDefinitionsRequest;
import com.amazonaws.services.costexplorer.model.ListCostCategoryDefinitionsResult;
import com.amazonaws.services.costexplorer.model.ListSavingsPlansPurchaseRecommendationGenerationRequest;
import com.amazonaws.services.costexplorer.model.ListSavingsPlansPurchaseRecommendationGenerationResult;
import com.amazonaws.services.costexplorer.model.ListTagsForResourceRequest;
import com.amazonaws.services.costexplorer.model.ListTagsForResourceResult;
import com.amazonaws.services.costexplorer.model.ProvideAnomalyFeedbackRequest;
import com.amazonaws.services.costexplorer.model.ProvideAnomalyFeedbackResult;
import com.amazonaws.services.costexplorer.model.StartSavingsPlansPurchaseRecommendationGenerationRequest;
import com.amazonaws.services.costexplorer.model.StartSavingsPlansPurchaseRecommendationGenerationResult;
import com.amazonaws.services.costexplorer.model.TagResourceRequest;
import com.amazonaws.services.costexplorer.model.TagResourceResult;
import com.amazonaws.services.costexplorer.model.UntagResourceRequest;
import com.amazonaws.services.costexplorer.model.UntagResourceResult;
import com.amazonaws.services.costexplorer.model.UpdateAnomalyMonitorRequest;
import com.amazonaws.services.costexplorer.model.UpdateAnomalyMonitorResult;
import com.amazonaws.services.costexplorer.model.UpdateAnomalySubscriptionRequest;
import com.amazonaws.services.costexplorer.model.UpdateAnomalySubscriptionResult;
import com.amazonaws.services.costexplorer.model.UpdateCostAllocationTagsStatusRequest;
import com.amazonaws.services.costexplorer.model.UpdateCostAllocationTagsStatusResult;
import com.amazonaws.services.costexplorer.model.UpdateCostCategoryDefinitionRequest;
import com.amazonaws.services.costexplorer.model.UpdateCostCategoryDefinitionResult;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;

@ThreadSafe
public class AWSCostExplorerAsyncClient
extends AWSCostExplorerClient
implements AWSCostExplorerAsync {
    private static final int DEFAULT_THREAD_POOL_SIZE = 50;
    private final ExecutorService executorService;

    public static AWSCostExplorerAsyncClientBuilder asyncBuilder() {
        return AWSCostExplorerAsyncClientBuilder.standard();
    }

    AWSCostExplorerAsyncClient(AwsAsyncClientParams asyncClientParams) {
        this(asyncClientParams, false);
    }

    AWSCostExplorerAsyncClient(AwsAsyncClientParams asyncClientParams, boolean endpointDiscoveryEnabled) {
        super((AwsSyncClientParams)asyncClientParams, endpointDiscoveryEnabled);
        this.executorService = asyncClientParams.getExecutor();
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    @Override
    public Future<CreateAnomalyMonitorResult> createAnomalyMonitorAsync(CreateAnomalyMonitorRequest request) {
        return this.createAnomalyMonitorAsync(request, null);
    }

    @Override
    public Future<CreateAnomalyMonitorResult> createAnomalyMonitorAsync(CreateAnomalyMonitorRequest request, final AsyncHandler<CreateAnomalyMonitorRequest, CreateAnomalyMonitorResult> asyncHandler) {
        final CreateAnomalyMonitorRequest finalRequest = (CreateAnomalyMonitorRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CreateAnomalyMonitorResult>(){

            @Override
            public CreateAnomalyMonitorResult call() throws Exception {
                CreateAnomalyMonitorResult result = null;
                try {
                    result = AWSCostExplorerAsyncClient.this.executeCreateAnomalyMonitor(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CreateAnomalySubscriptionResult> createAnomalySubscriptionAsync(CreateAnomalySubscriptionRequest request) {
        return this.createAnomalySubscriptionAsync(request, null);
    }

    @Override
    public Future<CreateAnomalySubscriptionResult> createAnomalySubscriptionAsync(CreateAnomalySubscriptionRequest request, final AsyncHandler<CreateAnomalySubscriptionRequest, CreateAnomalySubscriptionResult> asyncHandler) {
        final CreateAnomalySubscriptionRequest finalRequest = (CreateAnomalySubscriptionRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CreateAnomalySubscriptionResult>(){

            @Override
            public CreateAnomalySubscriptionResult call() throws Exception {
                CreateAnomalySubscriptionResult result = null;
                try {
                    result = AWSCostExplorerAsyncClient.this.executeCreateAnomalySubscription(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CreateCostCategoryDefinitionResult> createCostCategoryDefinitionAsync(CreateCostCategoryDefinitionRequest request) {
        return this.createCostCategoryDefinitionAsync(request, null);
    }

    @Override
    public Future<CreateCostCategoryDefinitionResult> createCostCategoryDefinitionAsync(CreateCostCategoryDefinitionRequest request, final AsyncHandler<CreateCostCategoryDefinitionRequest, CreateCostCategoryDefinitionResult> asyncHandler) {
        final CreateCostCategoryDefinitionRequest finalRequest = (CreateCostCategoryDefinitionRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CreateCostCategoryDefinitionResult>(){

            @Override
            public CreateCostCategoryDefinitionResult call() throws Exception {
                CreateCostCategoryDefinitionResult result = null;
                try {
                    result = AWSCostExplorerAsyncClient.this.executeCreateCostCategoryDefinition(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteAnomalyMonitorResult> deleteAnomalyMonitorAsync(DeleteAnomalyMonitorRequest request) {
        return this.deleteAnomalyMonitorAsync(request, null);
    }

    @Override
    public Future<DeleteAnomalyMonitorResult> deleteAnomalyMonitorAsync(DeleteAnomalyMonitorRequest request, final AsyncHandler<DeleteAnomalyMonitorRequest, DeleteAnomalyMonitorResult> asyncHandler) {
        final DeleteAnomalyMonitorRequest finalRequest = (DeleteAnomalyMonitorRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DeleteAnomalyMonitorResult>(){

            @Override
            public DeleteAnomalyMonitorResult call() throws Exception {
                DeleteAnomalyMonitorResult result = null;
                try {
                    result = AWSCostExplorerAsyncClient.this.executeDeleteAnomalyMonitor(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteAnomalySubscriptionResult> deleteAnomalySubscriptionAsync(DeleteAnomalySubscriptionRequest request) {
        return this.deleteAnomalySubscriptionAsync(request, null);
    }

    @Override
    public Future<DeleteAnomalySubscriptionResult> deleteAnomalySubscriptionAsync(DeleteAnomalySubscriptionRequest request, final AsyncHandler<DeleteAnomalySubscriptionRequest, DeleteAnomalySubscriptionResult> asyncHandler) {
        final DeleteAnomalySubscriptionRequest finalRequest = (DeleteAnomalySubscriptionRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DeleteAnomalySubscriptionResult>(){

            @Override
            public DeleteAnomalySubscriptionResult call() throws Exception {
                DeleteAnomalySubscriptionResult result = null;
                try {
                    result = AWSCostExplorerAsyncClient.this.executeDeleteAnomalySubscription(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteCostCategoryDefinitionResult> deleteCostCategoryDefinitionAsync(DeleteCostCategoryDefinitionRequest request) {
        return this.deleteCostCategoryDefinitionAsync(request, null);
    }

    @Override
    public Future<DeleteCostCategoryDefinitionResult> deleteCostCategoryDefinitionAsync(DeleteCostCategoryDefinitionRequest request, final AsyncHandler<DeleteCostCategoryDefinitionRequest, DeleteCostCategoryDefinitionResult> asyncHandler) {
        final DeleteCostCategoryDefinitionRequest finalRequest = (DeleteCostCategoryDefinitionRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DeleteCostCategoryDefinitionResult>(){

            @Override
            public DeleteCostCategoryDefinitionResult call() throws Exception {
                DeleteCostCategoryDefinitionResult result = null;
                try {
                    result = AWSCostExplorerAsyncClient.this.executeDeleteCostCategoryDefinition(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeCostCategoryDefinitionResult> describeCostCategoryDefinitionAsync(DescribeCostCategoryDefinitionRequest request) {
        return this.describeCostCategoryDefinitionAsync(request, null);
    }

    @Override
    public Future<DescribeCostCategoryDefinitionResult> describeCostCategoryDefinitionAsync(DescribeCostCategoryDefinitionRequest request, final AsyncHandler<DescribeCostCategoryDefinitionRequest, DescribeCostCategoryDefinitionResult> asyncHandler) {
        final DescribeCostCategoryDefinitionRequest finalRequest = (DescribeCostCategoryDefinitionRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DescribeCostCategoryDefinitionResult>(){

            @Override
            public DescribeCostCategoryDefinitionResult call() throws Exception {
                DescribeCostCategoryDefinitionResult result = null;
                try {
                    result = AWSCostExplorerAsyncClient.this.executeDescribeCostCategoryDefinition(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetAnomaliesResult> getAnomaliesAsync(GetAnomaliesRequest request) {
        return this.getAnomaliesAsync(request, null);
    }

    @Override
    public Future<GetAnomaliesResult> getAnomaliesAsync(GetAnomaliesRequest request, final AsyncHandler<GetAnomaliesRequest, GetAnomaliesResult> asyncHandler) {
        final GetAnomaliesRequest finalRequest = (GetAnomaliesRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetAnomaliesResult>(){

            @Override
            public GetAnomaliesResult call() throws Exception {
                GetAnomaliesResult result = null;
                try {
                    result = AWSCostExplorerAsyncClient.this.executeGetAnomalies(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetAnomalyMonitorsResult> getAnomalyMonitorsAsync(GetAnomalyMonitorsRequest request) {
        return this.getAnomalyMonitorsAsync(request, null);
    }

    @Override
    public Future<GetAnomalyMonitorsResult> getAnomalyMonitorsAsync(GetAnomalyMonitorsRequest request, final AsyncHandler<GetAnomalyMonitorsRequest, GetAnomalyMonitorsResult> asyncHandler) {
        final GetAnomalyMonitorsRequest finalRequest = (GetAnomalyMonitorsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetAnomalyMonitorsResult>(){

            @Override
            public GetAnomalyMonitorsResult call() throws Exception {
                GetAnomalyMonitorsResult result = null;
                try {
                    result = AWSCostExplorerAsyncClient.this.executeGetAnomalyMonitors(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetAnomalySubscriptionsResult> getAnomalySubscriptionsAsync(GetAnomalySubscriptionsRequest request) {
        return this.getAnomalySubscriptionsAsync(request, null);
    }

    @Override
    public Future<GetAnomalySubscriptionsResult> getAnomalySubscriptionsAsync(GetAnomalySubscriptionsRequest request, final AsyncHandler<GetAnomalySubscriptionsRequest, GetAnomalySubscriptionsResult> asyncHandler) {
        final GetAnomalySubscriptionsRequest finalRequest = (GetAnomalySubscriptionsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetAnomalySubscriptionsResult>(){

            @Override
            public GetAnomalySubscriptionsResult call() throws Exception {
                GetAnomalySubscriptionsResult result = null;
                try {
                    result = AWSCostExplorerAsyncClient.this.executeGetAnomalySubscriptions(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetCostAndUsageResult> getCostAndUsageAsync(GetCostAndUsageRequest request) {
        return this.getCostAndUsageAsync(request, null);
    }

    @Override
    public Future<GetCostAndUsageResult> getCostAndUsageAsync(GetCostAndUsageRequest request, final AsyncHandler<GetCostAndUsageRequest, GetCostAndUsageResult> asyncHandler) {
        final GetCostAndUsageRequest finalRequest = (GetCostAndUsageRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetCostAndUsageResult>(){

            @Override
            public GetCostAndUsageResult call() throws Exception {
                GetCostAndUsageResult result = null;
                try {
                    result = AWSCostExplorerAsyncClient.this.executeGetCostAndUsage(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetCostAndUsageWithResourcesResult> getCostAndUsageWithResourcesAsync(GetCostAndUsageWithResourcesRequest request) {
        return this.getCostAndUsageWithResourcesAsync(request, null);
    }

    @Override
    public Future<GetCostAndUsageWithResourcesResult> getCostAndUsageWithResourcesAsync(GetCostAndUsageWithResourcesRequest request, final AsyncHandler<GetCostAndUsageWithResourcesRequest, GetCostAndUsageWithResourcesResult> asyncHandler) {
        final GetCostAndUsageWithResourcesRequest finalRequest = (GetCostAndUsageWithResourcesRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetCostAndUsageWithResourcesResult>(){

            @Override
            public GetCostAndUsageWithResourcesResult call() throws Exception {
                GetCostAndUsageWithResourcesResult result = null;
                try {
                    result = AWSCostExplorerAsyncClient.this.executeGetCostAndUsageWithResources(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetCostCategoriesResult> getCostCategoriesAsync(GetCostCategoriesRequest request) {
        return this.getCostCategoriesAsync(request, null);
    }

    @Override
    public Future<GetCostCategoriesResult> getCostCategoriesAsync(GetCostCategoriesRequest request, final AsyncHandler<GetCostCategoriesRequest, GetCostCategoriesResult> asyncHandler) {
        final GetCostCategoriesRequest finalRequest = (GetCostCategoriesRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetCostCategoriesResult>(){

            @Override
            public GetCostCategoriesResult call() throws Exception {
                GetCostCategoriesResult result = null;
                try {
                    result = AWSCostExplorerAsyncClient.this.executeGetCostCategories(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetCostForecastResult> getCostForecastAsync(GetCostForecastRequest request) {
        return this.getCostForecastAsync(request, null);
    }

    @Override
    public Future<GetCostForecastResult> getCostForecastAsync(GetCostForecastRequest request, final AsyncHandler<GetCostForecastRequest, GetCostForecastResult> asyncHandler) {
        final GetCostForecastRequest finalRequest = (GetCostForecastRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetCostForecastResult>(){

            @Override
            public GetCostForecastResult call() throws Exception {
                GetCostForecastResult result = null;
                try {
                    result = AWSCostExplorerAsyncClient.this.executeGetCostForecast(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetDimensionValuesResult> getDimensionValuesAsync(GetDimensionValuesRequest request) {
        return this.getDimensionValuesAsync(request, null);
    }

    @Override
    public Future<GetDimensionValuesResult> getDimensionValuesAsync(GetDimensionValuesRequest request, final AsyncHandler<GetDimensionValuesRequest, GetDimensionValuesResult> asyncHandler) {
        final GetDimensionValuesRequest finalRequest = (GetDimensionValuesRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetDimensionValuesResult>(){

            @Override
            public GetDimensionValuesResult call() throws Exception {
                GetDimensionValuesResult result = null;
                try {
                    result = AWSCostExplorerAsyncClient.this.executeGetDimensionValues(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetReservationCoverageResult> getReservationCoverageAsync(GetReservationCoverageRequest request) {
        return this.getReservationCoverageAsync(request, null);
    }

    @Override
    public Future<GetReservationCoverageResult> getReservationCoverageAsync(GetReservationCoverageRequest request, final AsyncHandler<GetReservationCoverageRequest, GetReservationCoverageResult> asyncHandler) {
        final GetReservationCoverageRequest finalRequest = (GetReservationCoverageRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetReservationCoverageResult>(){

            @Override
            public GetReservationCoverageResult call() throws Exception {
                GetReservationCoverageResult result = null;
                try {
                    result = AWSCostExplorerAsyncClient.this.executeGetReservationCoverage(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetReservationPurchaseRecommendationResult> getReservationPurchaseRecommendationAsync(GetReservationPurchaseRecommendationRequest request) {
        return this.getReservationPurchaseRecommendationAsync(request, null);
    }

    @Override
    public Future<GetReservationPurchaseRecommendationResult> getReservationPurchaseRecommendationAsync(GetReservationPurchaseRecommendationRequest request, final AsyncHandler<GetReservationPurchaseRecommendationRequest, GetReservationPurchaseRecommendationResult> asyncHandler) {
        final GetReservationPurchaseRecommendationRequest finalRequest = (GetReservationPurchaseRecommendationRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetReservationPurchaseRecommendationResult>(){

            @Override
            public GetReservationPurchaseRecommendationResult call() throws Exception {
                GetReservationPurchaseRecommendationResult result = null;
                try {
                    result = AWSCostExplorerAsyncClient.this.executeGetReservationPurchaseRecommendation(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetReservationUtilizationResult> getReservationUtilizationAsync(GetReservationUtilizationRequest request) {
        return this.getReservationUtilizationAsync(request, null);
    }

    @Override
    public Future<GetReservationUtilizationResult> getReservationUtilizationAsync(GetReservationUtilizationRequest request, final AsyncHandler<GetReservationUtilizationRequest, GetReservationUtilizationResult> asyncHandler) {
        final GetReservationUtilizationRequest finalRequest = (GetReservationUtilizationRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetReservationUtilizationResult>(){

            @Override
            public GetReservationUtilizationResult call() throws Exception {
                GetReservationUtilizationResult result = null;
                try {
                    result = AWSCostExplorerAsyncClient.this.executeGetReservationUtilization(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetRightsizingRecommendationResult> getRightsizingRecommendationAsync(GetRightsizingRecommendationRequest request) {
        return this.getRightsizingRecommendationAsync(request, null);
    }

    @Override
    public Future<GetRightsizingRecommendationResult> getRightsizingRecommendationAsync(GetRightsizingRecommendationRequest request, final AsyncHandler<GetRightsizingRecommendationRequest, GetRightsizingRecommendationResult> asyncHandler) {
        final GetRightsizingRecommendationRequest finalRequest = (GetRightsizingRecommendationRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetRightsizingRecommendationResult>(){

            @Override
            public GetRightsizingRecommendationResult call() throws Exception {
                GetRightsizingRecommendationResult result = null;
                try {
                    result = AWSCostExplorerAsyncClient.this.executeGetRightsizingRecommendation(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetSavingsPlanPurchaseRecommendationDetailsResult> getSavingsPlanPurchaseRecommendationDetailsAsync(GetSavingsPlanPurchaseRecommendationDetailsRequest request) {
        return this.getSavingsPlanPurchaseRecommendationDetailsAsync(request, null);
    }

    @Override
    public Future<GetSavingsPlanPurchaseRecommendationDetailsResult> getSavingsPlanPurchaseRecommendationDetailsAsync(GetSavingsPlanPurchaseRecommendationDetailsRequest request, final AsyncHandler<GetSavingsPlanPurchaseRecommendationDetailsRequest, GetSavingsPlanPurchaseRecommendationDetailsResult> asyncHandler) {
        final GetSavingsPlanPurchaseRecommendationDetailsRequest finalRequest = (GetSavingsPlanPurchaseRecommendationDetailsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetSavingsPlanPurchaseRecommendationDetailsResult>(){

            @Override
            public GetSavingsPlanPurchaseRecommendationDetailsResult call() throws Exception {
                GetSavingsPlanPurchaseRecommendationDetailsResult result = null;
                try {
                    result = AWSCostExplorerAsyncClient.this.executeGetSavingsPlanPurchaseRecommendationDetails(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetSavingsPlansCoverageResult> getSavingsPlansCoverageAsync(GetSavingsPlansCoverageRequest request) {
        return this.getSavingsPlansCoverageAsync(request, null);
    }

    @Override
    public Future<GetSavingsPlansCoverageResult> getSavingsPlansCoverageAsync(GetSavingsPlansCoverageRequest request, final AsyncHandler<GetSavingsPlansCoverageRequest, GetSavingsPlansCoverageResult> asyncHandler) {
        final GetSavingsPlansCoverageRequest finalRequest = (GetSavingsPlansCoverageRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetSavingsPlansCoverageResult>(){

            @Override
            public GetSavingsPlansCoverageResult call() throws Exception {
                GetSavingsPlansCoverageResult result = null;
                try {
                    result = AWSCostExplorerAsyncClient.this.executeGetSavingsPlansCoverage(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetSavingsPlansPurchaseRecommendationResult> getSavingsPlansPurchaseRecommendationAsync(GetSavingsPlansPurchaseRecommendationRequest request) {
        return this.getSavingsPlansPurchaseRecommendationAsync(request, null);
    }

    @Override
    public Future<GetSavingsPlansPurchaseRecommendationResult> getSavingsPlansPurchaseRecommendationAsync(GetSavingsPlansPurchaseRecommendationRequest request, final AsyncHandler<GetSavingsPlansPurchaseRecommendationRequest, GetSavingsPlansPurchaseRecommendationResult> asyncHandler) {
        final GetSavingsPlansPurchaseRecommendationRequest finalRequest = (GetSavingsPlansPurchaseRecommendationRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetSavingsPlansPurchaseRecommendationResult>(){

            @Override
            public GetSavingsPlansPurchaseRecommendationResult call() throws Exception {
                GetSavingsPlansPurchaseRecommendationResult result = null;
                try {
                    result = AWSCostExplorerAsyncClient.this.executeGetSavingsPlansPurchaseRecommendation(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetSavingsPlansUtilizationResult> getSavingsPlansUtilizationAsync(GetSavingsPlansUtilizationRequest request) {
        return this.getSavingsPlansUtilizationAsync(request, null);
    }

    @Override
    public Future<GetSavingsPlansUtilizationResult> getSavingsPlansUtilizationAsync(GetSavingsPlansUtilizationRequest request, final AsyncHandler<GetSavingsPlansUtilizationRequest, GetSavingsPlansUtilizationResult> asyncHandler) {
        final GetSavingsPlansUtilizationRequest finalRequest = (GetSavingsPlansUtilizationRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetSavingsPlansUtilizationResult>(){

            @Override
            public GetSavingsPlansUtilizationResult call() throws Exception {
                GetSavingsPlansUtilizationResult result = null;
                try {
                    result = AWSCostExplorerAsyncClient.this.executeGetSavingsPlansUtilization(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetSavingsPlansUtilizationDetailsResult> getSavingsPlansUtilizationDetailsAsync(GetSavingsPlansUtilizationDetailsRequest request) {
        return this.getSavingsPlansUtilizationDetailsAsync(request, null);
    }

    @Override
    public Future<GetSavingsPlansUtilizationDetailsResult> getSavingsPlansUtilizationDetailsAsync(GetSavingsPlansUtilizationDetailsRequest request, final AsyncHandler<GetSavingsPlansUtilizationDetailsRequest, GetSavingsPlansUtilizationDetailsResult> asyncHandler) {
        final GetSavingsPlansUtilizationDetailsRequest finalRequest = (GetSavingsPlansUtilizationDetailsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetSavingsPlansUtilizationDetailsResult>(){

            @Override
            public GetSavingsPlansUtilizationDetailsResult call() throws Exception {
                GetSavingsPlansUtilizationDetailsResult result = null;
                try {
                    result = AWSCostExplorerAsyncClient.this.executeGetSavingsPlansUtilizationDetails(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetTagsResult> getTagsAsync(GetTagsRequest request) {
        return this.getTagsAsync(request, null);
    }

    @Override
    public Future<GetTagsResult> getTagsAsync(GetTagsRequest request, final AsyncHandler<GetTagsRequest, GetTagsResult> asyncHandler) {
        final GetTagsRequest finalRequest = (GetTagsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetTagsResult>(){

            @Override
            public GetTagsResult call() throws Exception {
                GetTagsResult result = null;
                try {
                    result = AWSCostExplorerAsyncClient.this.executeGetTags(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetUsageForecastResult> getUsageForecastAsync(GetUsageForecastRequest request) {
        return this.getUsageForecastAsync(request, null);
    }

    @Override
    public Future<GetUsageForecastResult> getUsageForecastAsync(GetUsageForecastRequest request, final AsyncHandler<GetUsageForecastRequest, GetUsageForecastResult> asyncHandler) {
        final GetUsageForecastRequest finalRequest = (GetUsageForecastRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetUsageForecastResult>(){

            @Override
            public GetUsageForecastResult call() throws Exception {
                GetUsageForecastResult result = null;
                try {
                    result = AWSCostExplorerAsyncClient.this.executeGetUsageForecast(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListCostAllocationTagsResult> listCostAllocationTagsAsync(ListCostAllocationTagsRequest request) {
        return this.listCostAllocationTagsAsync(request, null);
    }

    @Override
    public Future<ListCostAllocationTagsResult> listCostAllocationTagsAsync(ListCostAllocationTagsRequest request, final AsyncHandler<ListCostAllocationTagsRequest, ListCostAllocationTagsResult> asyncHandler) {
        final ListCostAllocationTagsRequest finalRequest = (ListCostAllocationTagsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListCostAllocationTagsResult>(){

            @Override
            public ListCostAllocationTagsResult call() throws Exception {
                ListCostAllocationTagsResult result = null;
                try {
                    result = AWSCostExplorerAsyncClient.this.executeListCostAllocationTags(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListCostCategoryDefinitionsResult> listCostCategoryDefinitionsAsync(ListCostCategoryDefinitionsRequest request) {
        return this.listCostCategoryDefinitionsAsync(request, null);
    }

    @Override
    public Future<ListCostCategoryDefinitionsResult> listCostCategoryDefinitionsAsync(ListCostCategoryDefinitionsRequest request, final AsyncHandler<ListCostCategoryDefinitionsRequest, ListCostCategoryDefinitionsResult> asyncHandler) {
        final ListCostCategoryDefinitionsRequest finalRequest = (ListCostCategoryDefinitionsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListCostCategoryDefinitionsResult>(){

            @Override
            public ListCostCategoryDefinitionsResult call() throws Exception {
                ListCostCategoryDefinitionsResult result = null;
                try {
                    result = AWSCostExplorerAsyncClient.this.executeListCostCategoryDefinitions(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListSavingsPlansPurchaseRecommendationGenerationResult> listSavingsPlansPurchaseRecommendationGenerationAsync(ListSavingsPlansPurchaseRecommendationGenerationRequest request) {
        return this.listSavingsPlansPurchaseRecommendationGenerationAsync(request, null);
    }

    @Override
    public Future<ListSavingsPlansPurchaseRecommendationGenerationResult> listSavingsPlansPurchaseRecommendationGenerationAsync(ListSavingsPlansPurchaseRecommendationGenerationRequest request, final AsyncHandler<ListSavingsPlansPurchaseRecommendationGenerationRequest, ListSavingsPlansPurchaseRecommendationGenerationResult> asyncHandler) {
        final ListSavingsPlansPurchaseRecommendationGenerationRequest finalRequest = (ListSavingsPlansPurchaseRecommendationGenerationRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListSavingsPlansPurchaseRecommendationGenerationResult>(){

            @Override
            public ListSavingsPlansPurchaseRecommendationGenerationResult call() throws Exception {
                ListSavingsPlansPurchaseRecommendationGenerationResult result = null;
                try {
                    result = AWSCostExplorerAsyncClient.this.executeListSavingsPlansPurchaseRecommendationGeneration(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListTagsForResourceResult> listTagsForResourceAsync(ListTagsForResourceRequest request) {
        return this.listTagsForResourceAsync(request, null);
    }

    @Override
    public Future<ListTagsForResourceResult> listTagsForResourceAsync(ListTagsForResourceRequest request, final AsyncHandler<ListTagsForResourceRequest, ListTagsForResourceResult> asyncHandler) {
        final ListTagsForResourceRequest finalRequest = (ListTagsForResourceRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListTagsForResourceResult>(){

            @Override
            public ListTagsForResourceResult call() throws Exception {
                ListTagsForResourceResult result = null;
                try {
                    result = AWSCostExplorerAsyncClient.this.executeListTagsForResource(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ProvideAnomalyFeedbackResult> provideAnomalyFeedbackAsync(ProvideAnomalyFeedbackRequest request) {
        return this.provideAnomalyFeedbackAsync(request, null);
    }

    @Override
    public Future<ProvideAnomalyFeedbackResult> provideAnomalyFeedbackAsync(ProvideAnomalyFeedbackRequest request, final AsyncHandler<ProvideAnomalyFeedbackRequest, ProvideAnomalyFeedbackResult> asyncHandler) {
        final ProvideAnomalyFeedbackRequest finalRequest = (ProvideAnomalyFeedbackRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ProvideAnomalyFeedbackResult>(){

            @Override
            public ProvideAnomalyFeedbackResult call() throws Exception {
                ProvideAnomalyFeedbackResult result = null;
                try {
                    result = AWSCostExplorerAsyncClient.this.executeProvideAnomalyFeedback(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<StartSavingsPlansPurchaseRecommendationGenerationResult> startSavingsPlansPurchaseRecommendationGenerationAsync(StartSavingsPlansPurchaseRecommendationGenerationRequest request) {
        return this.startSavingsPlansPurchaseRecommendationGenerationAsync(request, null);
    }

    @Override
    public Future<StartSavingsPlansPurchaseRecommendationGenerationResult> startSavingsPlansPurchaseRecommendationGenerationAsync(StartSavingsPlansPurchaseRecommendationGenerationRequest request, final AsyncHandler<StartSavingsPlansPurchaseRecommendationGenerationRequest, StartSavingsPlansPurchaseRecommendationGenerationResult> asyncHandler) {
        final StartSavingsPlansPurchaseRecommendationGenerationRequest finalRequest = (StartSavingsPlansPurchaseRecommendationGenerationRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<StartSavingsPlansPurchaseRecommendationGenerationResult>(){

            @Override
            public StartSavingsPlansPurchaseRecommendationGenerationResult call() throws Exception {
                StartSavingsPlansPurchaseRecommendationGenerationResult result = null;
                try {
                    result = AWSCostExplorerAsyncClient.this.executeStartSavingsPlansPurchaseRecommendationGeneration(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<TagResourceResult> tagResourceAsync(TagResourceRequest request) {
        return this.tagResourceAsync(request, null);
    }

    @Override
    public Future<TagResourceResult> tagResourceAsync(TagResourceRequest request, final AsyncHandler<TagResourceRequest, TagResourceResult> asyncHandler) {
        final TagResourceRequest finalRequest = (TagResourceRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<TagResourceResult>(){

            @Override
            public TagResourceResult call() throws Exception {
                TagResourceResult result = null;
                try {
                    result = AWSCostExplorerAsyncClient.this.executeTagResource(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UntagResourceResult> untagResourceAsync(UntagResourceRequest request) {
        return this.untagResourceAsync(request, null);
    }

    @Override
    public Future<UntagResourceResult> untagResourceAsync(UntagResourceRequest request, final AsyncHandler<UntagResourceRequest, UntagResourceResult> asyncHandler) {
        final UntagResourceRequest finalRequest = (UntagResourceRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<UntagResourceResult>(){

            @Override
            public UntagResourceResult call() throws Exception {
                UntagResourceResult result = null;
                try {
                    result = AWSCostExplorerAsyncClient.this.executeUntagResource(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UpdateAnomalyMonitorResult> updateAnomalyMonitorAsync(UpdateAnomalyMonitorRequest request) {
        return this.updateAnomalyMonitorAsync(request, null);
    }

    @Override
    public Future<UpdateAnomalyMonitorResult> updateAnomalyMonitorAsync(UpdateAnomalyMonitorRequest request, final AsyncHandler<UpdateAnomalyMonitorRequest, UpdateAnomalyMonitorResult> asyncHandler) {
        final UpdateAnomalyMonitorRequest finalRequest = (UpdateAnomalyMonitorRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<UpdateAnomalyMonitorResult>(){

            @Override
            public UpdateAnomalyMonitorResult call() throws Exception {
                UpdateAnomalyMonitorResult result = null;
                try {
                    result = AWSCostExplorerAsyncClient.this.executeUpdateAnomalyMonitor(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UpdateAnomalySubscriptionResult> updateAnomalySubscriptionAsync(UpdateAnomalySubscriptionRequest request) {
        return this.updateAnomalySubscriptionAsync(request, null);
    }

    @Override
    public Future<UpdateAnomalySubscriptionResult> updateAnomalySubscriptionAsync(UpdateAnomalySubscriptionRequest request, final AsyncHandler<UpdateAnomalySubscriptionRequest, UpdateAnomalySubscriptionResult> asyncHandler) {
        final UpdateAnomalySubscriptionRequest finalRequest = (UpdateAnomalySubscriptionRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<UpdateAnomalySubscriptionResult>(){

            @Override
            public UpdateAnomalySubscriptionResult call() throws Exception {
                UpdateAnomalySubscriptionResult result = null;
                try {
                    result = AWSCostExplorerAsyncClient.this.executeUpdateAnomalySubscription(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UpdateCostAllocationTagsStatusResult> updateCostAllocationTagsStatusAsync(UpdateCostAllocationTagsStatusRequest request) {
        return this.updateCostAllocationTagsStatusAsync(request, null);
    }

    @Override
    public Future<UpdateCostAllocationTagsStatusResult> updateCostAllocationTagsStatusAsync(UpdateCostAllocationTagsStatusRequest request, final AsyncHandler<UpdateCostAllocationTagsStatusRequest, UpdateCostAllocationTagsStatusResult> asyncHandler) {
        final UpdateCostAllocationTagsStatusRequest finalRequest = (UpdateCostAllocationTagsStatusRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<UpdateCostAllocationTagsStatusResult>(){

            @Override
            public UpdateCostAllocationTagsStatusResult call() throws Exception {
                UpdateCostAllocationTagsStatusResult result = null;
                try {
                    result = AWSCostExplorerAsyncClient.this.executeUpdateCostAllocationTagsStatus(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UpdateCostCategoryDefinitionResult> updateCostCategoryDefinitionAsync(UpdateCostCategoryDefinitionRequest request) {
        return this.updateCostCategoryDefinitionAsync(request, null);
    }

    @Override
    public Future<UpdateCostCategoryDefinitionResult> updateCostCategoryDefinitionAsync(UpdateCostCategoryDefinitionRequest request, final AsyncHandler<UpdateCostCategoryDefinitionRequest, UpdateCostCategoryDefinitionResult> asyncHandler) {
        final UpdateCostCategoryDefinitionRequest finalRequest = (UpdateCostCategoryDefinitionRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<UpdateCostCategoryDefinitionResult>(){

            @Override
            public UpdateCostCategoryDefinitionResult call() throws Exception {
                UpdateCostCategoryDefinitionResult result = null;
                try {
                    result = AWSCostExplorerAsyncClient.this.executeUpdateCostCategoryDefinition(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public void shutdown() {
        super.shutdown();
        this.executorService.shutdownNow();
    }
}

