/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.costexplorer.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.costexplorer.model.CostCategoryProcessingStatus;
import com.amazonaws.services.costexplorer.model.CostCategoryRule;
import com.amazonaws.services.costexplorer.model.CostCategoryRuleVersion;
import com.amazonaws.services.costexplorer.model.transform.CostCategoryMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class CostCategory
implements Serializable,
Cloneable,
StructuredPojo {
    private String costCategoryArn;
    private String effectiveStart;
    private String effectiveEnd;
    private String name;
    private String ruleVersion;
    private List<CostCategoryRule> rules;
    private List<CostCategoryProcessingStatus> processingStatus;
    private String defaultValue;

    public void setCostCategoryArn(String costCategoryArn) {
        this.costCategoryArn = costCategoryArn;
    }

    public String getCostCategoryArn() {
        return this.costCategoryArn;
    }

    public CostCategory withCostCategoryArn(String costCategoryArn) {
        this.setCostCategoryArn(costCategoryArn);
        return this;
    }

    public void setEffectiveStart(String effectiveStart) {
        this.effectiveStart = effectiveStart;
    }

    public String getEffectiveStart() {
        return this.effectiveStart;
    }

    public CostCategory withEffectiveStart(String effectiveStart) {
        this.setEffectiveStart(effectiveStart);
        return this;
    }

    public void setEffectiveEnd(String effectiveEnd) {
        this.effectiveEnd = effectiveEnd;
    }

    public String getEffectiveEnd() {
        return this.effectiveEnd;
    }

    public CostCategory withEffectiveEnd(String effectiveEnd) {
        this.setEffectiveEnd(effectiveEnd);
        return this;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public CostCategory withName(String name) {
        this.setName(name);
        return this;
    }

    public void setRuleVersion(String ruleVersion) {
        this.ruleVersion = ruleVersion;
    }

    public String getRuleVersion() {
        return this.ruleVersion;
    }

    public CostCategory withRuleVersion(String ruleVersion) {
        this.setRuleVersion(ruleVersion);
        return this;
    }

    public CostCategory withRuleVersion(CostCategoryRuleVersion ruleVersion) {
        this.ruleVersion = ruleVersion.toString();
        return this;
    }

    public List<CostCategoryRule> getRules() {
        return this.rules;
    }

    public void setRules(Collection<CostCategoryRule> rules) {
        if (rules == null) {
            this.rules = null;
            return;
        }
        this.rules = new ArrayList<CostCategoryRule>(rules);
    }

    public CostCategory withRules(CostCategoryRule ... rules) {
        if (this.rules == null) {
            this.setRules(new ArrayList<CostCategoryRule>(rules.length));
        }
        for (CostCategoryRule ele : rules) {
            this.rules.add(ele);
        }
        return this;
    }

    public CostCategory withRules(Collection<CostCategoryRule> rules) {
        this.setRules(rules);
        return this;
    }

    public List<CostCategoryProcessingStatus> getProcessingStatus() {
        return this.processingStatus;
    }

    public void setProcessingStatus(Collection<CostCategoryProcessingStatus> processingStatus) {
        if (processingStatus == null) {
            this.processingStatus = null;
            return;
        }
        this.processingStatus = new ArrayList<CostCategoryProcessingStatus>(processingStatus);
    }

    public CostCategory withProcessingStatus(CostCategoryProcessingStatus ... processingStatus) {
        if (this.processingStatus == null) {
            this.setProcessingStatus(new ArrayList<CostCategoryProcessingStatus>(processingStatus.length));
        }
        for (CostCategoryProcessingStatus ele : processingStatus) {
            this.processingStatus.add(ele);
        }
        return this;
    }

    public CostCategory withProcessingStatus(Collection<CostCategoryProcessingStatus> processingStatus) {
        this.setProcessingStatus(processingStatus);
        return this;
    }

    public void setDefaultValue(String defaultValue) {
        this.defaultValue = defaultValue;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public CostCategory withDefaultValue(String defaultValue) {
        this.setDefaultValue(defaultValue);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getCostCategoryArn() != null) {
            sb.append("CostCategoryArn: ").append(this.getCostCategoryArn()).append(",");
        }
        if (this.getEffectiveStart() != null) {
            sb.append("EffectiveStart: ").append(this.getEffectiveStart()).append(",");
        }
        if (this.getEffectiveEnd() != null) {
            sb.append("EffectiveEnd: ").append(this.getEffectiveEnd()).append(",");
        }
        if (this.getName() != null) {
            sb.append("Name: ").append(this.getName()).append(",");
        }
        if (this.getRuleVersion() != null) {
            sb.append("RuleVersion: ").append(this.getRuleVersion()).append(",");
        }
        if (this.getRules() != null) {
            sb.append("Rules: ").append(this.getRules()).append(",");
        }
        if (this.getProcessingStatus() != null) {
            sb.append("ProcessingStatus: ").append(this.getProcessingStatus()).append(",");
        }
        if (this.getDefaultValue() != null) {
            sb.append("DefaultValue: ").append(this.getDefaultValue());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CostCategory)) {
            return false;
        }
        CostCategory other = (CostCategory)obj;
        if (other.getCostCategoryArn() == null ^ this.getCostCategoryArn() == null) {
            return false;
        }
        if (other.getCostCategoryArn() != null && !other.getCostCategoryArn().equals(this.getCostCategoryArn())) {
            return false;
        }
        if (other.getEffectiveStart() == null ^ this.getEffectiveStart() == null) {
            return false;
        }
        if (other.getEffectiveStart() != null && !other.getEffectiveStart().equals(this.getEffectiveStart())) {
            return false;
        }
        if (other.getEffectiveEnd() == null ^ this.getEffectiveEnd() == null) {
            return false;
        }
        if (other.getEffectiveEnd() != null && !other.getEffectiveEnd().equals(this.getEffectiveEnd())) {
            return false;
        }
        if (other.getName() == null ^ this.getName() == null) {
            return false;
        }
        if (other.getName() != null && !other.getName().equals(this.getName())) {
            return false;
        }
        if (other.getRuleVersion() == null ^ this.getRuleVersion() == null) {
            return false;
        }
        if (other.getRuleVersion() != null && !other.getRuleVersion().equals(this.getRuleVersion())) {
            return false;
        }
        if (other.getRules() == null ^ this.getRules() == null) {
            return false;
        }
        if (other.getRules() != null && !other.getRules().equals(this.getRules())) {
            return false;
        }
        if (other.getProcessingStatus() == null ^ this.getProcessingStatus() == null) {
            return false;
        }
        if (other.getProcessingStatus() != null && !other.getProcessingStatus().equals(this.getProcessingStatus())) {
            return false;
        }
        if (other.getDefaultValue() == null ^ this.getDefaultValue() == null) {
            return false;
        }
        return other.getDefaultValue() == null || other.getDefaultValue().equals(this.getDefaultValue());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getCostCategoryArn() == null ? 0 : this.getCostCategoryArn().hashCode());
        hashCode = 31 * hashCode + (this.getEffectiveStart() == null ? 0 : this.getEffectiveStart().hashCode());
        hashCode = 31 * hashCode + (this.getEffectiveEnd() == null ? 0 : this.getEffectiveEnd().hashCode());
        hashCode = 31 * hashCode + (this.getName() == null ? 0 : this.getName().hashCode());
        hashCode = 31 * hashCode + (this.getRuleVersion() == null ? 0 : this.getRuleVersion().hashCode());
        hashCode = 31 * hashCode + (this.getRules() == null ? 0 : this.getRules().hashCode());
        hashCode = 31 * hashCode + (this.getProcessingStatus() == null ? 0 : this.getProcessingStatus().hashCode());
        hashCode = 31 * hashCode + (this.getDefaultValue() == null ? 0 : this.getDefaultValue().hashCode());
        return hashCode;
    }

    public CostCategory clone() {
        try {
            return (CostCategory)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        CostCategoryMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

