/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.costexplorer.model;

import com.amazonaws.AmazonWebServiceResult;
import com.amazonaws.ResponseMetadata;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class GetTagsResult
extends AmazonWebServiceResult<ResponseMetadata>
implements Serializable,
Cloneable {
    private String nextPageToken;
    private List<String> tags;
    private Integer returnSize;
    private Integer totalSize;

    public void setNextPageToken(String nextPageToken) {
        this.nextPageToken = nextPageToken;
    }

    public String getNextPageToken() {
        return this.nextPageToken;
    }

    public GetTagsResult withNextPageToken(String nextPageToken) {
        this.setNextPageToken(nextPageToken);
        return this;
    }

    public List<String> getTags() {
        return this.tags;
    }

    public void setTags(Collection<String> tags) {
        if (tags == null) {
            this.tags = null;
            return;
        }
        this.tags = new ArrayList<String>(tags);
    }

    public GetTagsResult withTags(String ... tags) {
        if (this.tags == null) {
            this.setTags(new ArrayList<String>(tags.length));
        }
        for (String ele : tags) {
            this.tags.add(ele);
        }
        return this;
    }

    public GetTagsResult withTags(Collection<String> tags) {
        this.setTags(tags);
        return this;
    }

    public void setReturnSize(Integer returnSize) {
        this.returnSize = returnSize;
    }

    public Integer getReturnSize() {
        return this.returnSize;
    }

    public GetTagsResult withReturnSize(Integer returnSize) {
        this.setReturnSize(returnSize);
        return this;
    }

    public void setTotalSize(Integer totalSize) {
        this.totalSize = totalSize;
    }

    public Integer getTotalSize() {
        return this.totalSize;
    }

    public GetTagsResult withTotalSize(Integer totalSize) {
        this.setTotalSize(totalSize);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getNextPageToken() != null) {
            sb.append("NextPageToken: ").append(this.getNextPageToken()).append(",");
        }
        if (this.getTags() != null) {
            sb.append("Tags: ").append(this.getTags()).append(",");
        }
        if (this.getReturnSize() != null) {
            sb.append("ReturnSize: ").append(this.getReturnSize()).append(",");
        }
        if (this.getTotalSize() != null) {
            sb.append("TotalSize: ").append(this.getTotalSize());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetTagsResult)) {
            return false;
        }
        GetTagsResult other = (GetTagsResult)obj;
        if (other.getNextPageToken() == null ^ this.getNextPageToken() == null) {
            return false;
        }
        if (other.getNextPageToken() != null && !other.getNextPageToken().equals(this.getNextPageToken())) {
            return false;
        }
        if (other.getTags() == null ^ this.getTags() == null) {
            return false;
        }
        if (other.getTags() != null && !other.getTags().equals(this.getTags())) {
            return false;
        }
        if (other.getReturnSize() == null ^ this.getReturnSize() == null) {
            return false;
        }
        if (other.getReturnSize() != null && !other.getReturnSize().equals(this.getReturnSize())) {
            return false;
        }
        if (other.getTotalSize() == null ^ this.getTotalSize() == null) {
            return false;
        }
        return other.getTotalSize() == null || other.getTotalSize().equals(this.getTotalSize());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getNextPageToken() == null ? 0 : this.getNextPageToken().hashCode());
        hashCode = 31 * hashCode + (this.getTags() == null ? 0 : this.getTags().hashCode());
        hashCode = 31 * hashCode + (this.getReturnSize() == null ? 0 : this.getReturnSize().hashCode());
        hashCode = 31 * hashCode + (this.getTotalSize() == null ? 0 : this.getTotalSize().hashCode());
        return hashCode;
    }

    public GetTagsResult clone() {
        try {
            return (GetTagsResult)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

