/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.auth;

import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AccountIdAware;

public class BasicAWSCredentials
implements AWSCredentials,
AccountIdAware {
    private final String accessKey;
    private final String secretKey;
    private final String accountId;

    public BasicAWSCredentials(String accessKey, String secretKey) {
        this(accessKey, secretKey, null);
    }

    public BasicAWSCredentials(String accessKey, String secretKey, String accountId) {
        if (accessKey == null) {
            throw new IllegalArgumentException("Access key cannot be null.");
        }
        if (secretKey == null) {
            throw new IllegalArgumentException("Secret key cannot be null.");
        }
        this.accessKey = accessKey;
        this.secretKey = secretKey;
        this.accountId = accountId;
    }

    @Override
    public String getAWSAccessKeyId() {
        return this.accessKey;
    }

    @Override
    public String getAWSSecretKey() {
        return this.secretKey;
    }

    @Override
    public String getAccountId() {
        return this.accountId;
    }
}

