/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.connectcases.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.connectcases.model.CaseFilter;
import com.amazonaws.services.connectcases.model.FieldIdentifier;
import com.amazonaws.services.connectcases.model.Sort;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class SearchCasesRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String domainId;
    private List<FieldIdentifier> fields;
    private CaseFilter filter;
    private Integer maxResults;
    private String nextToken;
    private String searchTerm;
    private List<Sort> sorts;

    public void setDomainId(String domainId) {
        this.domainId = domainId;
    }

    public String getDomainId() {
        return this.domainId;
    }

    public SearchCasesRequest withDomainId(String domainId) {
        this.setDomainId(domainId);
        return this;
    }

    public List<FieldIdentifier> getFields() {
        return this.fields;
    }

    public void setFields(Collection<FieldIdentifier> fields) {
        if (fields == null) {
            this.fields = null;
            return;
        }
        this.fields = new ArrayList<FieldIdentifier>(fields);
    }

    public SearchCasesRequest withFields(FieldIdentifier ... fields) {
        if (this.fields == null) {
            this.setFields(new ArrayList<FieldIdentifier>(fields.length));
        }
        for (FieldIdentifier ele : fields) {
            this.fields.add(ele);
        }
        return this;
    }

    public SearchCasesRequest withFields(Collection<FieldIdentifier> fields) {
        this.setFields(fields);
        return this;
    }

    public void setFilter(CaseFilter filter) {
        this.filter = filter;
    }

    public CaseFilter getFilter() {
        return this.filter;
    }

    public SearchCasesRequest withFilter(CaseFilter filter) {
        this.setFilter(filter);
        return this;
    }

    public void setMaxResults(Integer maxResults) {
        this.maxResults = maxResults;
    }

    public Integer getMaxResults() {
        return this.maxResults;
    }

    public SearchCasesRequest withMaxResults(Integer maxResults) {
        this.setMaxResults(maxResults);
        return this;
    }

    public void setNextToken(String nextToken) {
        this.nextToken = nextToken;
    }

    public String getNextToken() {
        return this.nextToken;
    }

    public SearchCasesRequest withNextToken(String nextToken) {
        this.setNextToken(nextToken);
        return this;
    }

    public void setSearchTerm(String searchTerm) {
        this.searchTerm = searchTerm;
    }

    public String getSearchTerm() {
        return this.searchTerm;
    }

    public SearchCasesRequest withSearchTerm(String searchTerm) {
        this.setSearchTerm(searchTerm);
        return this;
    }

    public List<Sort> getSorts() {
        return this.sorts;
    }

    public void setSorts(Collection<Sort> sorts) {
        if (sorts == null) {
            this.sorts = null;
            return;
        }
        this.sorts = new ArrayList<Sort>(sorts);
    }

    public SearchCasesRequest withSorts(Sort ... sorts) {
        if (this.sorts == null) {
            this.setSorts(new ArrayList<Sort>(sorts.length));
        }
        for (Sort ele : sorts) {
            this.sorts.add(ele);
        }
        return this;
    }

    public SearchCasesRequest withSorts(Collection<Sort> sorts) {
        this.setSorts(sorts);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getDomainId() != null) {
            sb.append("DomainId: ").append(this.getDomainId()).append(",");
        }
        if (this.getFields() != null) {
            sb.append("Fields: ").append(this.getFields()).append(",");
        }
        if (this.getFilter() != null) {
            sb.append("Filter: ").append(this.getFilter()).append(",");
        }
        if (this.getMaxResults() != null) {
            sb.append("MaxResults: ").append(this.getMaxResults()).append(",");
        }
        if (this.getNextToken() != null) {
            sb.append("NextToken: ").append(this.getNextToken()).append(",");
        }
        if (this.getSearchTerm() != null) {
            sb.append("SearchTerm: ").append(this.getSearchTerm()).append(",");
        }
        if (this.getSorts() != null) {
            sb.append("Sorts: ").append(this.getSorts());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SearchCasesRequest)) {
            return false;
        }
        SearchCasesRequest other = (SearchCasesRequest)obj;
        if (other.getDomainId() == null ^ this.getDomainId() == null) {
            return false;
        }
        if (other.getDomainId() != null && !other.getDomainId().equals(this.getDomainId())) {
            return false;
        }
        if (other.getFields() == null ^ this.getFields() == null) {
            return false;
        }
        if (other.getFields() != null && !other.getFields().equals(this.getFields())) {
            return false;
        }
        if (other.getFilter() == null ^ this.getFilter() == null) {
            return false;
        }
        if (other.getFilter() != null && !other.getFilter().equals(this.getFilter())) {
            return false;
        }
        if (other.getMaxResults() == null ^ this.getMaxResults() == null) {
            return false;
        }
        if (other.getMaxResults() != null && !other.getMaxResults().equals(this.getMaxResults())) {
            return false;
        }
        if (other.getNextToken() == null ^ this.getNextToken() == null) {
            return false;
        }
        if (other.getNextToken() != null && !other.getNextToken().equals(this.getNextToken())) {
            return false;
        }
        if (other.getSearchTerm() == null ^ this.getSearchTerm() == null) {
            return false;
        }
        if (other.getSearchTerm() != null && !other.getSearchTerm().equals(this.getSearchTerm())) {
            return false;
        }
        if (other.getSorts() == null ^ this.getSorts() == null) {
            return false;
        }
        return other.getSorts() == null || other.getSorts().equals(this.getSorts());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getDomainId() == null ? 0 : this.getDomainId().hashCode());
        hashCode = 31 * hashCode + (this.getFields() == null ? 0 : this.getFields().hashCode());
        hashCode = 31 * hashCode + (this.getFilter() == null ? 0 : this.getFilter().hashCode());
        hashCode = 31 * hashCode + (this.getMaxResults() == null ? 0 : this.getMaxResults().hashCode());
        hashCode = 31 * hashCode + (this.getNextToken() == null ? 0 : this.getNextToken().hashCode());
        hashCode = 31 * hashCode + (this.getSearchTerm() == null ? 0 : this.getSearchTerm().hashCode());
        hashCode = 31 * hashCode + (this.getSorts() == null ? 0 : this.getSorts().hashCode());
        return hashCode;
    }

    public SearchCasesRequest clone() {
        return (SearchCasesRequest)super.clone();
    }
}

