/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.connect.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.connect.model.RuleAction;
import com.amazonaws.services.connect.model.RulePublishStatus;
import com.amazonaws.services.connect.model.RuleTriggerEventSource;
import com.amazonaws.services.connect.model.transform.RuleMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Rule
implements Serializable,
Cloneable,
StructuredPojo {
    private String name;
    private String ruleId;
    private String ruleArn;
    private RuleTriggerEventSource triggerEventSource;
    private String function;
    private List<RuleAction> actions;
    private String publishStatus;
    private Date createdTime;
    private Date lastUpdatedTime;
    private String lastUpdatedBy;
    private Map<String, String> tags;

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public Rule withName(String name) {
        this.setName(name);
        return this;
    }

    public void setRuleId(String ruleId) {
        this.ruleId = ruleId;
    }

    public String getRuleId() {
        return this.ruleId;
    }

    public Rule withRuleId(String ruleId) {
        this.setRuleId(ruleId);
        return this;
    }

    public void setRuleArn(String ruleArn) {
        this.ruleArn = ruleArn;
    }

    public String getRuleArn() {
        return this.ruleArn;
    }

    public Rule withRuleArn(String ruleArn) {
        this.setRuleArn(ruleArn);
        return this;
    }

    public void setTriggerEventSource(RuleTriggerEventSource triggerEventSource) {
        this.triggerEventSource = triggerEventSource;
    }

    public RuleTriggerEventSource getTriggerEventSource() {
        return this.triggerEventSource;
    }

    public Rule withTriggerEventSource(RuleTriggerEventSource triggerEventSource) {
        this.setTriggerEventSource(triggerEventSource);
        return this;
    }

    public void setFunction(String function) {
        this.function = function;
    }

    public String getFunction() {
        return this.function;
    }

    public Rule withFunction(String function) {
        this.setFunction(function);
        return this;
    }

    public List<RuleAction> getActions() {
        return this.actions;
    }

    public void setActions(Collection<RuleAction> actions) {
        if (actions == null) {
            this.actions = null;
            return;
        }
        this.actions = new ArrayList<RuleAction>(actions);
    }

    public Rule withActions(RuleAction ... actions) {
        if (this.actions == null) {
            this.setActions(new ArrayList<RuleAction>(actions.length));
        }
        for (RuleAction ele : actions) {
            this.actions.add(ele);
        }
        return this;
    }

    public Rule withActions(Collection<RuleAction> actions) {
        this.setActions(actions);
        return this;
    }

    public void setPublishStatus(String publishStatus) {
        this.publishStatus = publishStatus;
    }

    public String getPublishStatus() {
        return this.publishStatus;
    }

    public Rule withPublishStatus(String publishStatus) {
        this.setPublishStatus(publishStatus);
        return this;
    }

    public Rule withPublishStatus(RulePublishStatus publishStatus) {
        this.publishStatus = publishStatus.toString();
        return this;
    }

    public void setCreatedTime(Date createdTime) {
        this.createdTime = createdTime;
    }

    public Date getCreatedTime() {
        return this.createdTime;
    }

    public Rule withCreatedTime(Date createdTime) {
        this.setCreatedTime(createdTime);
        return this;
    }

    public void setLastUpdatedTime(Date lastUpdatedTime) {
        this.lastUpdatedTime = lastUpdatedTime;
    }

    public Date getLastUpdatedTime() {
        return this.lastUpdatedTime;
    }

    public Rule withLastUpdatedTime(Date lastUpdatedTime) {
        this.setLastUpdatedTime(lastUpdatedTime);
        return this;
    }

    public void setLastUpdatedBy(String lastUpdatedBy) {
        this.lastUpdatedBy = lastUpdatedBy;
    }

    public String getLastUpdatedBy() {
        return this.lastUpdatedBy;
    }

    public Rule withLastUpdatedBy(String lastUpdatedBy) {
        this.setLastUpdatedBy(lastUpdatedBy);
        return this;
    }

    public Map<String, String> getTags() {
        return this.tags;
    }

    public void setTags(Map<String, String> tags) {
        this.tags = tags;
    }

    public Rule withTags(Map<String, String> tags) {
        this.setTags(tags);
        return this;
    }

    public Rule addTagsEntry(String key, String value) {
        if (null == this.tags) {
            this.tags = new HashMap<String, String>();
        }
        if (this.tags.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.tags.put(key, value);
        return this;
    }

    public Rule clearTagsEntries() {
        this.tags = null;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getName() != null) {
            sb.append("Name: ").append(this.getName()).append(",");
        }
        if (this.getRuleId() != null) {
            sb.append("RuleId: ").append(this.getRuleId()).append(",");
        }
        if (this.getRuleArn() != null) {
            sb.append("RuleArn: ").append(this.getRuleArn()).append(",");
        }
        if (this.getTriggerEventSource() != null) {
            sb.append("TriggerEventSource: ").append(this.getTriggerEventSource()).append(",");
        }
        if (this.getFunction() != null) {
            sb.append("Function: ").append(this.getFunction()).append(",");
        }
        if (this.getActions() != null) {
            sb.append("Actions: ").append(this.getActions()).append(",");
        }
        if (this.getPublishStatus() != null) {
            sb.append("PublishStatus: ").append(this.getPublishStatus()).append(",");
        }
        if (this.getCreatedTime() != null) {
            sb.append("CreatedTime: ").append(this.getCreatedTime()).append(",");
        }
        if (this.getLastUpdatedTime() != null) {
            sb.append("LastUpdatedTime: ").append(this.getLastUpdatedTime()).append(",");
        }
        if (this.getLastUpdatedBy() != null) {
            sb.append("LastUpdatedBy: ").append(this.getLastUpdatedBy()).append(",");
        }
        if (this.getTags() != null) {
            sb.append("Tags: ").append(this.getTags());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Rule)) {
            return false;
        }
        Rule other = (Rule)obj;
        if (other.getName() == null ^ this.getName() == null) {
            return false;
        }
        if (other.getName() != null && !other.getName().equals(this.getName())) {
            return false;
        }
        if (other.getRuleId() == null ^ this.getRuleId() == null) {
            return false;
        }
        if (other.getRuleId() != null && !other.getRuleId().equals(this.getRuleId())) {
            return false;
        }
        if (other.getRuleArn() == null ^ this.getRuleArn() == null) {
            return false;
        }
        if (other.getRuleArn() != null && !other.getRuleArn().equals(this.getRuleArn())) {
            return false;
        }
        if (other.getTriggerEventSource() == null ^ this.getTriggerEventSource() == null) {
            return false;
        }
        if (other.getTriggerEventSource() != null && !other.getTriggerEventSource().equals(this.getTriggerEventSource())) {
            return false;
        }
        if (other.getFunction() == null ^ this.getFunction() == null) {
            return false;
        }
        if (other.getFunction() != null && !other.getFunction().equals(this.getFunction())) {
            return false;
        }
        if (other.getActions() == null ^ this.getActions() == null) {
            return false;
        }
        if (other.getActions() != null && !other.getActions().equals(this.getActions())) {
            return false;
        }
        if (other.getPublishStatus() == null ^ this.getPublishStatus() == null) {
            return false;
        }
        if (other.getPublishStatus() != null && !other.getPublishStatus().equals(this.getPublishStatus())) {
            return false;
        }
        if (other.getCreatedTime() == null ^ this.getCreatedTime() == null) {
            return false;
        }
        if (other.getCreatedTime() != null && !other.getCreatedTime().equals(this.getCreatedTime())) {
            return false;
        }
        if (other.getLastUpdatedTime() == null ^ this.getLastUpdatedTime() == null) {
            return false;
        }
        if (other.getLastUpdatedTime() != null && !other.getLastUpdatedTime().equals(this.getLastUpdatedTime())) {
            return false;
        }
        if (other.getLastUpdatedBy() == null ^ this.getLastUpdatedBy() == null) {
            return false;
        }
        if (other.getLastUpdatedBy() != null && !other.getLastUpdatedBy().equals(this.getLastUpdatedBy())) {
            return false;
        }
        if (other.getTags() == null ^ this.getTags() == null) {
            return false;
        }
        return other.getTags() == null || other.getTags().equals(this.getTags());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getName() == null ? 0 : this.getName().hashCode());
        hashCode = 31 * hashCode + (this.getRuleId() == null ? 0 : this.getRuleId().hashCode());
        hashCode = 31 * hashCode + (this.getRuleArn() == null ? 0 : this.getRuleArn().hashCode());
        hashCode = 31 * hashCode + (this.getTriggerEventSource() == null ? 0 : this.getTriggerEventSource().hashCode());
        hashCode = 31 * hashCode + (this.getFunction() == null ? 0 : this.getFunction().hashCode());
        hashCode = 31 * hashCode + (this.getActions() == null ? 0 : this.getActions().hashCode());
        hashCode = 31 * hashCode + (this.getPublishStatus() == null ? 0 : this.getPublishStatus().hashCode());
        hashCode = 31 * hashCode + (this.getCreatedTime() == null ? 0 : this.getCreatedTime().hashCode());
        hashCode = 31 * hashCode + (this.getLastUpdatedTime() == null ? 0 : this.getLastUpdatedTime().hashCode());
        hashCode = 31 * hashCode + (this.getLastUpdatedBy() == null ? 0 : this.getLastUpdatedBy().hashCode());
        hashCode = 31 * hashCode + (this.getTags() == null ? 0 : this.getTags().hashCode());
        return hashCode;
    }

    public Rule clone() {
        try {
            return (Rule)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        RuleMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

