/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.connect.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.connect.model.Dimensions;
import com.amazonaws.services.connect.model.HistoricalMetricData;
import com.amazonaws.services.connect.model.transform.HistoricalMetricResultMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class HistoricalMetricResult
implements Serializable,
Cloneable,
StructuredPojo {
    private Dimensions dimensions;
    private List<HistoricalMetricData> collections;

    public void setDimensions(Dimensions dimensions) {
        this.dimensions = dimensions;
    }

    public Dimensions getDimensions() {
        return this.dimensions;
    }

    public HistoricalMetricResult withDimensions(Dimensions dimensions) {
        this.setDimensions(dimensions);
        return this;
    }

    public List<HistoricalMetricData> getCollections() {
        return this.collections;
    }

    public void setCollections(Collection<HistoricalMetricData> collections) {
        if (collections == null) {
            this.collections = null;
            return;
        }
        this.collections = new ArrayList<HistoricalMetricData>(collections);
    }

    public HistoricalMetricResult withCollections(HistoricalMetricData ... collections) {
        if (this.collections == null) {
            this.setCollections(new ArrayList<HistoricalMetricData>(collections.length));
        }
        for (HistoricalMetricData ele : collections) {
            this.collections.add(ele);
        }
        return this;
    }

    public HistoricalMetricResult withCollections(Collection<HistoricalMetricData> collections) {
        this.setCollections(collections);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getDimensions() != null) {
            sb.append("Dimensions: ").append(this.getDimensions()).append(",");
        }
        if (this.getCollections() != null) {
            sb.append("Collections: ").append(this.getCollections());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof HistoricalMetricResult)) {
            return false;
        }
        HistoricalMetricResult other = (HistoricalMetricResult)obj;
        if (other.getDimensions() == null ^ this.getDimensions() == null) {
            return false;
        }
        if (other.getDimensions() != null && !other.getDimensions().equals(this.getDimensions())) {
            return false;
        }
        if (other.getCollections() == null ^ this.getCollections() == null) {
            return false;
        }
        return other.getCollections() == null || other.getCollections().equals(this.getCollections());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getDimensions() == null ? 0 : this.getDimensions().hashCode());
        hashCode = 31 * hashCode + (this.getCollections() == null ? 0 : this.getCollections().hashCode());
        return hashCode;
    }

    public HistoricalMetricResult clone() {
        try {
            return (HistoricalMetricResult)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        HistoricalMetricResultMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

