/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.config.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.config.model.AggregateResourceIdentifier;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;

public class BatchGetAggregateResourceConfigRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String configurationAggregatorName;
    private SdkInternalList<AggregateResourceIdentifier> resourceIdentifiers;

    public void setConfigurationAggregatorName(String configurationAggregatorName) {
        this.configurationAggregatorName = configurationAggregatorName;
    }

    public String getConfigurationAggregatorName() {
        return this.configurationAggregatorName;
    }

    public BatchGetAggregateResourceConfigRequest withConfigurationAggregatorName(String configurationAggregatorName) {
        this.setConfigurationAggregatorName(configurationAggregatorName);
        return this;
    }

    public List<AggregateResourceIdentifier> getResourceIdentifiers() {
        if (this.resourceIdentifiers == null) {
            this.resourceIdentifiers = new SdkInternalList();
        }
        return this.resourceIdentifiers;
    }

    public void setResourceIdentifiers(Collection<AggregateResourceIdentifier> resourceIdentifiers) {
        if (resourceIdentifiers == null) {
            this.resourceIdentifiers = null;
            return;
        }
        this.resourceIdentifiers = new SdkInternalList(resourceIdentifiers);
    }

    public BatchGetAggregateResourceConfigRequest withResourceIdentifiers(AggregateResourceIdentifier ... resourceIdentifiers) {
        if (this.resourceIdentifiers == null) {
            this.setResourceIdentifiers((Collection<AggregateResourceIdentifier>)new SdkInternalList(resourceIdentifiers.length));
        }
        for (AggregateResourceIdentifier ele : resourceIdentifiers) {
            this.resourceIdentifiers.add((Object)ele);
        }
        return this;
    }

    public BatchGetAggregateResourceConfigRequest withResourceIdentifiers(Collection<AggregateResourceIdentifier> resourceIdentifiers) {
        this.setResourceIdentifiers(resourceIdentifiers);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getConfigurationAggregatorName() != null) {
            sb.append("ConfigurationAggregatorName: ").append(this.getConfigurationAggregatorName()).append(",");
        }
        if (this.getResourceIdentifiers() != null) {
            sb.append("ResourceIdentifiers: ").append(this.getResourceIdentifiers());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchGetAggregateResourceConfigRequest)) {
            return false;
        }
        BatchGetAggregateResourceConfigRequest other = (BatchGetAggregateResourceConfigRequest)obj;
        if (other.getConfigurationAggregatorName() == null ^ this.getConfigurationAggregatorName() == null) {
            return false;
        }
        if (other.getConfigurationAggregatorName() != null && !other.getConfigurationAggregatorName().equals(this.getConfigurationAggregatorName())) {
            return false;
        }
        if (other.getResourceIdentifiers() == null ^ this.getResourceIdentifiers() == null) {
            return false;
        }
        return other.getResourceIdentifiers() == null || other.getResourceIdentifiers().equals(this.getResourceIdentifiers());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getConfigurationAggregatorName() == null ? 0 : this.getConfigurationAggregatorName().hashCode());
        hashCode = 31 * hashCode + (this.getResourceIdentifiers() == null ? 0 : this.getResourceIdentifiers().hashCode());
        return hashCode;
    }

    public BatchGetAggregateResourceConfigRequest clone() {
        return (BatchGetAggregateResourceConfigRequest)super.clone();
    }
}

