/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.comprehendmedical.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.comprehendmedical.model.ICD10CMAttribute;
import com.amazonaws.services.comprehendmedical.model.ICD10CMConcept;
import com.amazonaws.services.comprehendmedical.model.ICD10CMEntityCategory;
import com.amazonaws.services.comprehendmedical.model.ICD10CMEntityType;
import com.amazonaws.services.comprehendmedical.model.ICD10CMTrait;
import com.amazonaws.services.comprehendmedical.model.transform.ICD10CMEntityMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ICD10CMEntity
implements Serializable,
Cloneable,
StructuredPojo {
    private Integer id;
    private String text;
    private String category;
    private String type;
    private Float score;
    private Integer beginOffset;
    private Integer endOffset;
    private List<ICD10CMAttribute> attributes;
    private List<ICD10CMTrait> traits;
    private List<ICD10CMConcept> iCD10CMConcepts;

    public void setId(Integer id) {
        this.id = id;
    }

    public Integer getId() {
        return this.id;
    }

    public ICD10CMEntity withId(Integer id) {
        this.setId(id);
        return this;
    }

    public void setText(String text) {
        this.text = text;
    }

    public String getText() {
        return this.text;
    }

    public ICD10CMEntity withText(String text) {
        this.setText(text);
        return this;
    }

    public void setCategory(String category) {
        this.category = category;
    }

    public String getCategory() {
        return this.category;
    }

    public ICD10CMEntity withCategory(String category) {
        this.setCategory(category);
        return this;
    }

    public ICD10CMEntity withCategory(ICD10CMEntityCategory category) {
        this.category = category.toString();
        return this;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getType() {
        return this.type;
    }

    public ICD10CMEntity withType(String type) {
        this.setType(type);
        return this;
    }

    public ICD10CMEntity withType(ICD10CMEntityType type) {
        this.type = type.toString();
        return this;
    }

    public void setScore(Float score) {
        this.score = score;
    }

    public Float getScore() {
        return this.score;
    }

    public ICD10CMEntity withScore(Float score) {
        this.setScore(score);
        return this;
    }

    public void setBeginOffset(Integer beginOffset) {
        this.beginOffset = beginOffset;
    }

    public Integer getBeginOffset() {
        return this.beginOffset;
    }

    public ICD10CMEntity withBeginOffset(Integer beginOffset) {
        this.setBeginOffset(beginOffset);
        return this;
    }

    public void setEndOffset(Integer endOffset) {
        this.endOffset = endOffset;
    }

    public Integer getEndOffset() {
        return this.endOffset;
    }

    public ICD10CMEntity withEndOffset(Integer endOffset) {
        this.setEndOffset(endOffset);
        return this;
    }

    public List<ICD10CMAttribute> getAttributes() {
        return this.attributes;
    }

    public void setAttributes(Collection<ICD10CMAttribute> attributes) {
        if (attributes == null) {
            this.attributes = null;
            return;
        }
        this.attributes = new ArrayList<ICD10CMAttribute>(attributes);
    }

    public ICD10CMEntity withAttributes(ICD10CMAttribute ... attributes) {
        if (this.attributes == null) {
            this.setAttributes(new ArrayList<ICD10CMAttribute>(attributes.length));
        }
        for (ICD10CMAttribute ele : attributes) {
            this.attributes.add(ele);
        }
        return this;
    }

    public ICD10CMEntity withAttributes(Collection<ICD10CMAttribute> attributes) {
        this.setAttributes(attributes);
        return this;
    }

    public List<ICD10CMTrait> getTraits() {
        return this.traits;
    }

    public void setTraits(Collection<ICD10CMTrait> traits) {
        if (traits == null) {
            this.traits = null;
            return;
        }
        this.traits = new ArrayList<ICD10CMTrait>(traits);
    }

    public ICD10CMEntity withTraits(ICD10CMTrait ... traits) {
        if (this.traits == null) {
            this.setTraits(new ArrayList<ICD10CMTrait>(traits.length));
        }
        for (ICD10CMTrait ele : traits) {
            this.traits.add(ele);
        }
        return this;
    }

    public ICD10CMEntity withTraits(Collection<ICD10CMTrait> traits) {
        this.setTraits(traits);
        return this;
    }

    public List<ICD10CMConcept> getICD10CMConcepts() {
        return this.iCD10CMConcepts;
    }

    public void setICD10CMConcepts(Collection<ICD10CMConcept> iCD10CMConcepts) {
        if (iCD10CMConcepts == null) {
            this.iCD10CMConcepts = null;
            return;
        }
        this.iCD10CMConcepts = new ArrayList<ICD10CMConcept>(iCD10CMConcepts);
    }

    public ICD10CMEntity withICD10CMConcepts(ICD10CMConcept ... iCD10CMConcepts) {
        if (this.iCD10CMConcepts == null) {
            this.setICD10CMConcepts(new ArrayList<ICD10CMConcept>(iCD10CMConcepts.length));
        }
        for (ICD10CMConcept ele : iCD10CMConcepts) {
            this.iCD10CMConcepts.add(ele);
        }
        return this;
    }

    public ICD10CMEntity withICD10CMConcepts(Collection<ICD10CMConcept> iCD10CMConcepts) {
        this.setICD10CMConcepts(iCD10CMConcepts);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getId() != null) {
            sb.append("Id: ").append(this.getId()).append(",");
        }
        if (this.getText() != null) {
            sb.append("Text: ").append(this.getText()).append(",");
        }
        if (this.getCategory() != null) {
            sb.append("Category: ").append(this.getCategory()).append(",");
        }
        if (this.getType() != null) {
            sb.append("Type: ").append(this.getType()).append(",");
        }
        if (this.getScore() != null) {
            sb.append("Score: ").append(this.getScore()).append(",");
        }
        if (this.getBeginOffset() != null) {
            sb.append("BeginOffset: ").append(this.getBeginOffset()).append(",");
        }
        if (this.getEndOffset() != null) {
            sb.append("EndOffset: ").append(this.getEndOffset()).append(",");
        }
        if (this.getAttributes() != null) {
            sb.append("Attributes: ").append(this.getAttributes()).append(",");
        }
        if (this.getTraits() != null) {
            sb.append("Traits: ").append(this.getTraits()).append(",");
        }
        if (this.getICD10CMConcepts() != null) {
            sb.append("ICD10CMConcepts: ").append(this.getICD10CMConcepts());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ICD10CMEntity)) {
            return false;
        }
        ICD10CMEntity other = (ICD10CMEntity)obj;
        if (other.getId() == null ^ this.getId() == null) {
            return false;
        }
        if (other.getId() != null && !other.getId().equals(this.getId())) {
            return false;
        }
        if (other.getText() == null ^ this.getText() == null) {
            return false;
        }
        if (other.getText() != null && !other.getText().equals(this.getText())) {
            return false;
        }
        if (other.getCategory() == null ^ this.getCategory() == null) {
            return false;
        }
        if (other.getCategory() != null && !other.getCategory().equals(this.getCategory())) {
            return false;
        }
        if (other.getType() == null ^ this.getType() == null) {
            return false;
        }
        if (other.getType() != null && !other.getType().equals(this.getType())) {
            return false;
        }
        if (other.getScore() == null ^ this.getScore() == null) {
            return false;
        }
        if (other.getScore() != null && !other.getScore().equals(this.getScore())) {
            return false;
        }
        if (other.getBeginOffset() == null ^ this.getBeginOffset() == null) {
            return false;
        }
        if (other.getBeginOffset() != null && !other.getBeginOffset().equals(this.getBeginOffset())) {
            return false;
        }
        if (other.getEndOffset() == null ^ this.getEndOffset() == null) {
            return false;
        }
        if (other.getEndOffset() != null && !other.getEndOffset().equals(this.getEndOffset())) {
            return false;
        }
        if (other.getAttributes() == null ^ this.getAttributes() == null) {
            return false;
        }
        if (other.getAttributes() != null && !other.getAttributes().equals(this.getAttributes())) {
            return false;
        }
        if (other.getTraits() == null ^ this.getTraits() == null) {
            return false;
        }
        if (other.getTraits() != null && !other.getTraits().equals(this.getTraits())) {
            return false;
        }
        if (other.getICD10CMConcepts() == null ^ this.getICD10CMConcepts() == null) {
            return false;
        }
        return other.getICD10CMConcepts() == null || other.getICD10CMConcepts().equals(this.getICD10CMConcepts());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getId() == null ? 0 : this.getId().hashCode());
        hashCode = 31 * hashCode + (this.getText() == null ? 0 : this.getText().hashCode());
        hashCode = 31 * hashCode + (this.getCategory() == null ? 0 : this.getCategory().hashCode());
        hashCode = 31 * hashCode + (this.getType() == null ? 0 : this.getType().hashCode());
        hashCode = 31 * hashCode + (this.getScore() == null ? 0 : this.getScore().hashCode());
        hashCode = 31 * hashCode + (this.getBeginOffset() == null ? 0 : this.getBeginOffset().hashCode());
        hashCode = 31 * hashCode + (this.getEndOffset() == null ? 0 : this.getEndOffset().hashCode());
        hashCode = 31 * hashCode + (this.getAttributes() == null ? 0 : this.getAttributes().hashCode());
        hashCode = 31 * hashCode + (this.getTraits() == null ? 0 : this.getTraits().hashCode());
        hashCode = 31 * hashCode + (this.getICD10CMConcepts() == null ? 0 : this.getICD10CMConcepts().hashCode());
        return hashCode;
    }

    public ICD10CMEntity clone() {
        try {
            return (ICD10CMEntity)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ICD10CMEntityMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

