/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.comprehendmedical;

import com.amazonaws.AmazonWebServiceClient;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.AmazonWebServiceResponse;
import com.amazonaws.ClientConfigurationFactory;
import com.amazonaws.Request;
import com.amazonaws.Response;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.client.AwsSyncClientParams;
import com.amazonaws.client.builder.AdvancedConfig;
import com.amazonaws.handlers.HandlerChainFactory;
import com.amazonaws.handlers.HandlerContextKey;
import com.amazonaws.http.ExecutionContext;
import com.amazonaws.http.HttpResponseHandler;
import com.amazonaws.metrics.MetricType;
import com.amazonaws.protocol.json.JsonClientMetadata;
import com.amazonaws.protocol.json.JsonErrorResponseMetadata;
import com.amazonaws.protocol.json.JsonErrorShapeMetadata;
import com.amazonaws.protocol.json.JsonOperationMetadata;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.services.comprehendmedical.AWSComprehendMedical;
import com.amazonaws.services.comprehendmedical.AWSComprehendMedicalClientBuilder;
import com.amazonaws.services.comprehendmedical.model.AWSComprehendMedicalException;
import com.amazonaws.services.comprehendmedical.model.DescribeEntitiesDetectionV2JobRequest;
import com.amazonaws.services.comprehendmedical.model.DescribeEntitiesDetectionV2JobResult;
import com.amazonaws.services.comprehendmedical.model.DescribeICD10CMInferenceJobRequest;
import com.amazonaws.services.comprehendmedical.model.DescribeICD10CMInferenceJobResult;
import com.amazonaws.services.comprehendmedical.model.DescribePHIDetectionJobRequest;
import com.amazonaws.services.comprehendmedical.model.DescribePHIDetectionJobResult;
import com.amazonaws.services.comprehendmedical.model.DescribeRxNormInferenceJobRequest;
import com.amazonaws.services.comprehendmedical.model.DescribeRxNormInferenceJobResult;
import com.amazonaws.services.comprehendmedical.model.DetectEntitiesRequest;
import com.amazonaws.services.comprehendmedical.model.DetectEntitiesResult;
import com.amazonaws.services.comprehendmedical.model.DetectEntitiesV2Request;
import com.amazonaws.services.comprehendmedical.model.DetectEntitiesV2Result;
import com.amazonaws.services.comprehendmedical.model.DetectPHIRequest;
import com.amazonaws.services.comprehendmedical.model.DetectPHIResult;
import com.amazonaws.services.comprehendmedical.model.InferICD10CMRequest;
import com.amazonaws.services.comprehendmedical.model.InferICD10CMResult;
import com.amazonaws.services.comprehendmedical.model.InferRxNormRequest;
import com.amazonaws.services.comprehendmedical.model.InferRxNormResult;
import com.amazonaws.services.comprehendmedical.model.ListEntitiesDetectionV2JobsRequest;
import com.amazonaws.services.comprehendmedical.model.ListEntitiesDetectionV2JobsResult;
import com.amazonaws.services.comprehendmedical.model.ListICD10CMInferenceJobsRequest;
import com.amazonaws.services.comprehendmedical.model.ListICD10CMInferenceJobsResult;
import com.amazonaws.services.comprehendmedical.model.ListPHIDetectionJobsRequest;
import com.amazonaws.services.comprehendmedical.model.ListPHIDetectionJobsResult;
import com.amazonaws.services.comprehendmedical.model.ListRxNormInferenceJobsRequest;
import com.amazonaws.services.comprehendmedical.model.ListRxNormInferenceJobsResult;
import com.amazonaws.services.comprehendmedical.model.StartEntitiesDetectionV2JobRequest;
import com.amazonaws.services.comprehendmedical.model.StartEntitiesDetectionV2JobResult;
import com.amazonaws.services.comprehendmedical.model.StartICD10CMInferenceJobRequest;
import com.amazonaws.services.comprehendmedical.model.StartICD10CMInferenceJobResult;
import com.amazonaws.services.comprehendmedical.model.StartPHIDetectionJobRequest;
import com.amazonaws.services.comprehendmedical.model.StartPHIDetectionJobResult;
import com.amazonaws.services.comprehendmedical.model.StartRxNormInferenceJobRequest;
import com.amazonaws.services.comprehendmedical.model.StartRxNormInferenceJobResult;
import com.amazonaws.services.comprehendmedical.model.StopEntitiesDetectionV2JobRequest;
import com.amazonaws.services.comprehendmedical.model.StopEntitiesDetectionV2JobResult;
import com.amazonaws.services.comprehendmedical.model.StopICD10CMInferenceJobRequest;
import com.amazonaws.services.comprehendmedical.model.StopICD10CMInferenceJobResult;
import com.amazonaws.services.comprehendmedical.model.StopPHIDetectionJobRequest;
import com.amazonaws.services.comprehendmedical.model.StopPHIDetectionJobResult;
import com.amazonaws.services.comprehendmedical.model.StopRxNormInferenceJobRequest;
import com.amazonaws.services.comprehendmedical.model.StopRxNormInferenceJobResult;
import com.amazonaws.services.comprehendmedical.model.transform.DescribeEntitiesDetectionV2JobRequestProtocolMarshaller;
import com.amazonaws.services.comprehendmedical.model.transform.DescribeEntitiesDetectionV2JobResultJsonUnmarshaller;
import com.amazonaws.services.comprehendmedical.model.transform.DescribeICD10CMInferenceJobRequestProtocolMarshaller;
import com.amazonaws.services.comprehendmedical.model.transform.DescribeICD10CMInferenceJobResultJsonUnmarshaller;
import com.amazonaws.services.comprehendmedical.model.transform.DescribePHIDetectionJobRequestProtocolMarshaller;
import com.amazonaws.services.comprehendmedical.model.transform.DescribePHIDetectionJobResultJsonUnmarshaller;
import com.amazonaws.services.comprehendmedical.model.transform.DescribeRxNormInferenceJobRequestProtocolMarshaller;
import com.amazonaws.services.comprehendmedical.model.transform.DescribeRxNormInferenceJobResultJsonUnmarshaller;
import com.amazonaws.services.comprehendmedical.model.transform.DetectEntitiesRequestProtocolMarshaller;
import com.amazonaws.services.comprehendmedical.model.transform.DetectEntitiesResultJsonUnmarshaller;
import com.amazonaws.services.comprehendmedical.model.transform.DetectEntitiesV2RequestProtocolMarshaller;
import com.amazonaws.services.comprehendmedical.model.transform.DetectEntitiesV2ResultJsonUnmarshaller;
import com.amazonaws.services.comprehendmedical.model.transform.DetectPHIRequestProtocolMarshaller;
import com.amazonaws.services.comprehendmedical.model.transform.DetectPHIResultJsonUnmarshaller;
import com.amazonaws.services.comprehendmedical.model.transform.InferICD10CMRequestProtocolMarshaller;
import com.amazonaws.services.comprehendmedical.model.transform.InferICD10CMResultJsonUnmarshaller;
import com.amazonaws.services.comprehendmedical.model.transform.InferRxNormRequestProtocolMarshaller;
import com.amazonaws.services.comprehendmedical.model.transform.InferRxNormResultJsonUnmarshaller;
import com.amazonaws.services.comprehendmedical.model.transform.InternalServerExceptionUnmarshaller;
import com.amazonaws.services.comprehendmedical.model.transform.InvalidEncodingExceptionUnmarshaller;
import com.amazonaws.services.comprehendmedical.model.transform.InvalidRequestExceptionUnmarshaller;
import com.amazonaws.services.comprehendmedical.model.transform.ListEntitiesDetectionV2JobsRequestProtocolMarshaller;
import com.amazonaws.services.comprehendmedical.model.transform.ListEntitiesDetectionV2JobsResultJsonUnmarshaller;
import com.amazonaws.services.comprehendmedical.model.transform.ListICD10CMInferenceJobsRequestProtocolMarshaller;
import com.amazonaws.services.comprehendmedical.model.transform.ListICD10CMInferenceJobsResultJsonUnmarshaller;
import com.amazonaws.services.comprehendmedical.model.transform.ListPHIDetectionJobsRequestProtocolMarshaller;
import com.amazonaws.services.comprehendmedical.model.transform.ListPHIDetectionJobsResultJsonUnmarshaller;
import com.amazonaws.services.comprehendmedical.model.transform.ListRxNormInferenceJobsRequestProtocolMarshaller;
import com.amazonaws.services.comprehendmedical.model.transform.ListRxNormInferenceJobsResultJsonUnmarshaller;
import com.amazonaws.services.comprehendmedical.model.transform.ResourceNotFoundExceptionUnmarshaller;
import com.amazonaws.services.comprehendmedical.model.transform.ServiceUnavailableExceptionUnmarshaller;
import com.amazonaws.services.comprehendmedical.model.transform.StartEntitiesDetectionV2JobRequestProtocolMarshaller;
import com.amazonaws.services.comprehendmedical.model.transform.StartEntitiesDetectionV2JobResultJsonUnmarshaller;
import com.amazonaws.services.comprehendmedical.model.transform.StartICD10CMInferenceJobRequestProtocolMarshaller;
import com.amazonaws.services.comprehendmedical.model.transform.StartICD10CMInferenceJobResultJsonUnmarshaller;
import com.amazonaws.services.comprehendmedical.model.transform.StartPHIDetectionJobRequestProtocolMarshaller;
import com.amazonaws.services.comprehendmedical.model.transform.StartPHIDetectionJobResultJsonUnmarshaller;
import com.amazonaws.services.comprehendmedical.model.transform.StartRxNormInferenceJobRequestProtocolMarshaller;
import com.amazonaws.services.comprehendmedical.model.transform.StartRxNormInferenceJobResultJsonUnmarshaller;
import com.amazonaws.services.comprehendmedical.model.transform.StopEntitiesDetectionV2JobRequestProtocolMarshaller;
import com.amazonaws.services.comprehendmedical.model.transform.StopEntitiesDetectionV2JobResultJsonUnmarshaller;
import com.amazonaws.services.comprehendmedical.model.transform.StopICD10CMInferenceJobRequestProtocolMarshaller;
import com.amazonaws.services.comprehendmedical.model.transform.StopICD10CMInferenceJobResultJsonUnmarshaller;
import com.amazonaws.services.comprehendmedical.model.transform.StopPHIDetectionJobRequestProtocolMarshaller;
import com.amazonaws.services.comprehendmedical.model.transform.StopPHIDetectionJobResultJsonUnmarshaller;
import com.amazonaws.services.comprehendmedical.model.transform.StopRxNormInferenceJobRequestProtocolMarshaller;
import com.amazonaws.services.comprehendmedical.model.transform.StopRxNormInferenceJobResultJsonUnmarshaller;
import com.amazonaws.services.comprehendmedical.model.transform.TextSizeLimitExceededExceptionUnmarshaller;
import com.amazonaws.services.comprehendmedical.model.transform.TooManyRequestsExceptionUnmarshaller;
import com.amazonaws.services.comprehendmedical.model.transform.ValidationExceptionUnmarshaller;
import com.amazonaws.transform.JsonErrorUnmarshaller;
import com.amazonaws.transform.Unmarshaller;
import com.amazonaws.util.AWSRequestMetrics;
import com.amazonaws.util.CredentialUtils;
import java.net.URI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@ThreadSafe
public class AWSComprehendMedicalClient
extends AmazonWebServiceClient
implements AWSComprehendMedical {
    private final AWSCredentialsProvider awsCredentialsProvider;
    private static final Log log = LogFactory.getLog(AWSComprehendMedical.class);
    private static final String DEFAULT_SIGNING_NAME = "comprehendmedical";
    protected static final ClientConfigurationFactory configFactory = new ClientConfigurationFactory();
    private final AdvancedConfig advancedConfig;
    private static final SdkJsonProtocolFactory protocolFactory = new SdkJsonProtocolFactory(new JsonClientMetadata().withProtocolVersion("1.1").withSupportsCbor(false).withSupportsIon(false).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InvalidRequestException").withExceptionUnmarshaller((JsonErrorUnmarshaller)InvalidRequestExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ResourceNotFoundException").withExceptionUnmarshaller((JsonErrorUnmarshaller)ResourceNotFoundExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InvalidEncodingException").withExceptionUnmarshaller((JsonErrorUnmarshaller)InvalidEncodingExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ValidationException").withExceptionUnmarshaller((JsonErrorUnmarshaller)ValidationExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ServiceUnavailableException").withExceptionUnmarshaller((JsonErrorUnmarshaller)ServiceUnavailableExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("TextSizeLimitExceededException").withExceptionUnmarshaller((JsonErrorUnmarshaller)TextSizeLimitExceededExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InternalServerException").withExceptionUnmarshaller((JsonErrorUnmarshaller)InternalServerExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("TooManyRequestsException").withExceptionUnmarshaller((JsonErrorUnmarshaller)TooManyRequestsExceptionUnmarshaller.getInstance())).withBaseServiceExceptionClass(AWSComprehendMedicalException.class));

    public static AWSComprehendMedicalClientBuilder builder() {
        return AWSComprehendMedicalClientBuilder.standard();
    }

    AWSComprehendMedicalClient(AwsSyncClientParams clientParams) {
        this(clientParams, false);
    }

    AWSComprehendMedicalClient(AwsSyncClientParams clientParams, boolean endpointDiscoveryEnabled) {
        super(clientParams);
        this.awsCredentialsProvider = clientParams.getCredentialsProvider();
        this.advancedConfig = clientParams.getAdvancedConfig();
        this.init();
    }

    private void init() {
        this.setServiceNameIntern(DEFAULT_SIGNING_NAME);
        this.setEndpointPrefix(DEFAULT_SIGNING_NAME);
        this.setEndpoint("comprehendmedical.us-east-1.amazonaws.com");
        HandlerChainFactory chainFactory = new HandlerChainFactory();
        this.requestHandler2s.addAll(chainFactory.newRequestHandlerChain("/com/amazonaws/services/comprehendmedical/request.handlers"));
        this.requestHandler2s.addAll(chainFactory.newRequestHandler2Chain("/com/amazonaws/services/comprehendmedical/request.handler2s"));
        this.requestHandler2s.addAll(chainFactory.getGlobalHandlers());
    }

    @Override
    public DescribeEntitiesDetectionV2JobResult describeEntitiesDetectionV2Job(DescribeEntitiesDetectionV2JobRequest request) {
        request = (DescribeEntitiesDetectionV2JobRequest)this.beforeClientExecution(request);
        return this.executeDescribeEntitiesDetectionV2Job(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DescribeEntitiesDetectionV2JobResult executeDescribeEntitiesDetectionV2Job(DescribeEntitiesDetectionV2JobRequest describeEntitiesDetectionV2JobRequest) {
        ExecutionContext executionContext = this.createExecutionContext(describeEntitiesDetectionV2JobRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DescribeEntitiesDetectionV2JobRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DescribeEntitiesDetectionV2JobRequestProtocolMarshaller(protocolFactory).marshall((DescribeEntitiesDetectionV2JobRequest)super.beforeMarshalling((AmazonWebServiceRequest)describeEntitiesDetectionV2JobRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"ComprehendMedical");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DescribeEntitiesDetectionV2Job");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DescribeEntitiesDetectionV2JobResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DescribeEntitiesDetectionV2JobResult describeEntitiesDetectionV2JobResult = (DescribeEntitiesDetectionV2JobResult)response.getAwsResponse();
            return describeEntitiesDetectionV2JobResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DescribeICD10CMInferenceJobResult describeICD10CMInferenceJob(DescribeICD10CMInferenceJobRequest request) {
        request = (DescribeICD10CMInferenceJobRequest)this.beforeClientExecution(request);
        return this.executeDescribeICD10CMInferenceJob(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DescribeICD10CMInferenceJobResult executeDescribeICD10CMInferenceJob(DescribeICD10CMInferenceJobRequest describeICD10CMInferenceJobRequest) {
        ExecutionContext executionContext = this.createExecutionContext(describeICD10CMInferenceJobRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DescribeICD10CMInferenceJobRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DescribeICD10CMInferenceJobRequestProtocolMarshaller(protocolFactory).marshall((DescribeICD10CMInferenceJobRequest)super.beforeMarshalling((AmazonWebServiceRequest)describeICD10CMInferenceJobRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"ComprehendMedical");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DescribeICD10CMInferenceJob");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DescribeICD10CMInferenceJobResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DescribeICD10CMInferenceJobResult describeICD10CMInferenceJobResult = (DescribeICD10CMInferenceJobResult)response.getAwsResponse();
            return describeICD10CMInferenceJobResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DescribePHIDetectionJobResult describePHIDetectionJob(DescribePHIDetectionJobRequest request) {
        request = (DescribePHIDetectionJobRequest)this.beforeClientExecution(request);
        return this.executeDescribePHIDetectionJob(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DescribePHIDetectionJobResult executeDescribePHIDetectionJob(DescribePHIDetectionJobRequest describePHIDetectionJobRequest) {
        ExecutionContext executionContext = this.createExecutionContext(describePHIDetectionJobRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DescribePHIDetectionJobRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DescribePHIDetectionJobRequestProtocolMarshaller(protocolFactory).marshall((DescribePHIDetectionJobRequest)super.beforeMarshalling((AmazonWebServiceRequest)describePHIDetectionJobRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"ComprehendMedical");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DescribePHIDetectionJob");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DescribePHIDetectionJobResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DescribePHIDetectionJobResult describePHIDetectionJobResult = (DescribePHIDetectionJobResult)response.getAwsResponse();
            return describePHIDetectionJobResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DescribeRxNormInferenceJobResult describeRxNormInferenceJob(DescribeRxNormInferenceJobRequest request) {
        request = (DescribeRxNormInferenceJobRequest)this.beforeClientExecution(request);
        return this.executeDescribeRxNormInferenceJob(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DescribeRxNormInferenceJobResult executeDescribeRxNormInferenceJob(DescribeRxNormInferenceJobRequest describeRxNormInferenceJobRequest) {
        ExecutionContext executionContext = this.createExecutionContext(describeRxNormInferenceJobRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DescribeRxNormInferenceJobRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DescribeRxNormInferenceJobRequestProtocolMarshaller(protocolFactory).marshall((DescribeRxNormInferenceJobRequest)super.beforeMarshalling((AmazonWebServiceRequest)describeRxNormInferenceJobRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"ComprehendMedical");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DescribeRxNormInferenceJob");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DescribeRxNormInferenceJobResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DescribeRxNormInferenceJobResult describeRxNormInferenceJobResult = (DescribeRxNormInferenceJobResult)response.getAwsResponse();
            return describeRxNormInferenceJobResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    @Deprecated
    public DetectEntitiesResult detectEntities(DetectEntitiesRequest request) {
        request = (DetectEntitiesRequest)this.beforeClientExecution(request);
        return this.executeDetectEntities(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DetectEntitiesResult executeDetectEntities(DetectEntitiesRequest detectEntitiesRequest) {
        ExecutionContext executionContext = this.createExecutionContext(detectEntitiesRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DetectEntitiesRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DetectEntitiesRequestProtocolMarshaller(protocolFactory).marshall((DetectEntitiesRequest)super.beforeMarshalling((AmazonWebServiceRequest)detectEntitiesRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"ComprehendMedical");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DetectEntities");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DetectEntitiesResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DetectEntitiesResult detectEntitiesResult = (DetectEntitiesResult)response.getAwsResponse();
            return detectEntitiesResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DetectEntitiesV2Result detectEntitiesV2(DetectEntitiesV2Request request) {
        request = (DetectEntitiesV2Request)this.beforeClientExecution(request);
        return this.executeDetectEntitiesV2(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DetectEntitiesV2Result executeDetectEntitiesV2(DetectEntitiesV2Request detectEntitiesV2Request) {
        ExecutionContext executionContext = this.createExecutionContext(detectEntitiesV2Request);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DetectEntitiesV2Request> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DetectEntitiesV2RequestProtocolMarshaller(protocolFactory).marshall((DetectEntitiesV2Request)super.beforeMarshalling((AmazonWebServiceRequest)detectEntitiesV2Request));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"ComprehendMedical");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DetectEntitiesV2");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DetectEntitiesV2ResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DetectEntitiesV2Result detectEntitiesV2Result = (DetectEntitiesV2Result)response.getAwsResponse();
            return detectEntitiesV2Result;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DetectPHIResult detectPHI(DetectPHIRequest request) {
        request = (DetectPHIRequest)this.beforeClientExecution(request);
        return this.executeDetectPHI(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DetectPHIResult executeDetectPHI(DetectPHIRequest detectPHIRequest) {
        ExecutionContext executionContext = this.createExecutionContext(detectPHIRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DetectPHIRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DetectPHIRequestProtocolMarshaller(protocolFactory).marshall((DetectPHIRequest)super.beforeMarshalling((AmazonWebServiceRequest)detectPHIRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"ComprehendMedical");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DetectPHI");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DetectPHIResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DetectPHIResult detectPHIResult = (DetectPHIResult)response.getAwsResponse();
            return detectPHIResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public InferICD10CMResult inferICD10CM(InferICD10CMRequest request) {
        request = (InferICD10CMRequest)this.beforeClientExecution(request);
        return this.executeInferICD10CM(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final InferICD10CMResult executeInferICD10CM(InferICD10CMRequest inferICD10CMRequest) {
        ExecutionContext executionContext = this.createExecutionContext(inferICD10CMRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<InferICD10CMRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new InferICD10CMRequestProtocolMarshaller(protocolFactory).marshall((InferICD10CMRequest)super.beforeMarshalling((AmazonWebServiceRequest)inferICD10CMRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"ComprehendMedical");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"InferICD10CM");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new InferICD10CMResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            InferICD10CMResult inferICD10CMResult = (InferICD10CMResult)response.getAwsResponse();
            return inferICD10CMResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public InferRxNormResult inferRxNorm(InferRxNormRequest request) {
        request = (InferRxNormRequest)this.beforeClientExecution(request);
        return this.executeInferRxNorm(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final InferRxNormResult executeInferRxNorm(InferRxNormRequest inferRxNormRequest) {
        ExecutionContext executionContext = this.createExecutionContext(inferRxNormRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<InferRxNormRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new InferRxNormRequestProtocolMarshaller(protocolFactory).marshall((InferRxNormRequest)super.beforeMarshalling((AmazonWebServiceRequest)inferRxNormRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"ComprehendMedical");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"InferRxNorm");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new InferRxNormResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            InferRxNormResult inferRxNormResult = (InferRxNormResult)response.getAwsResponse();
            return inferRxNormResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListEntitiesDetectionV2JobsResult listEntitiesDetectionV2Jobs(ListEntitiesDetectionV2JobsRequest request) {
        request = (ListEntitiesDetectionV2JobsRequest)this.beforeClientExecution(request);
        return this.executeListEntitiesDetectionV2Jobs(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListEntitiesDetectionV2JobsResult executeListEntitiesDetectionV2Jobs(ListEntitiesDetectionV2JobsRequest listEntitiesDetectionV2JobsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listEntitiesDetectionV2JobsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListEntitiesDetectionV2JobsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListEntitiesDetectionV2JobsRequestProtocolMarshaller(protocolFactory).marshall((ListEntitiesDetectionV2JobsRequest)super.beforeMarshalling((AmazonWebServiceRequest)listEntitiesDetectionV2JobsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"ComprehendMedical");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ListEntitiesDetectionV2Jobs");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListEntitiesDetectionV2JobsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListEntitiesDetectionV2JobsResult listEntitiesDetectionV2JobsResult = (ListEntitiesDetectionV2JobsResult)response.getAwsResponse();
            return listEntitiesDetectionV2JobsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListICD10CMInferenceJobsResult listICD10CMInferenceJobs(ListICD10CMInferenceJobsRequest request) {
        request = (ListICD10CMInferenceJobsRequest)this.beforeClientExecution(request);
        return this.executeListICD10CMInferenceJobs(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListICD10CMInferenceJobsResult executeListICD10CMInferenceJobs(ListICD10CMInferenceJobsRequest listICD10CMInferenceJobsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listICD10CMInferenceJobsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListICD10CMInferenceJobsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListICD10CMInferenceJobsRequestProtocolMarshaller(protocolFactory).marshall((ListICD10CMInferenceJobsRequest)super.beforeMarshalling((AmazonWebServiceRequest)listICD10CMInferenceJobsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"ComprehendMedical");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ListICD10CMInferenceJobs");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListICD10CMInferenceJobsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListICD10CMInferenceJobsResult listICD10CMInferenceJobsResult = (ListICD10CMInferenceJobsResult)response.getAwsResponse();
            return listICD10CMInferenceJobsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListPHIDetectionJobsResult listPHIDetectionJobs(ListPHIDetectionJobsRequest request) {
        request = (ListPHIDetectionJobsRequest)this.beforeClientExecution(request);
        return this.executeListPHIDetectionJobs(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListPHIDetectionJobsResult executeListPHIDetectionJobs(ListPHIDetectionJobsRequest listPHIDetectionJobsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listPHIDetectionJobsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListPHIDetectionJobsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListPHIDetectionJobsRequestProtocolMarshaller(protocolFactory).marshall((ListPHIDetectionJobsRequest)super.beforeMarshalling((AmazonWebServiceRequest)listPHIDetectionJobsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"ComprehendMedical");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ListPHIDetectionJobs");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListPHIDetectionJobsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListPHIDetectionJobsResult listPHIDetectionJobsResult = (ListPHIDetectionJobsResult)response.getAwsResponse();
            return listPHIDetectionJobsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListRxNormInferenceJobsResult listRxNormInferenceJobs(ListRxNormInferenceJobsRequest request) {
        request = (ListRxNormInferenceJobsRequest)this.beforeClientExecution(request);
        return this.executeListRxNormInferenceJobs(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListRxNormInferenceJobsResult executeListRxNormInferenceJobs(ListRxNormInferenceJobsRequest listRxNormInferenceJobsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listRxNormInferenceJobsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListRxNormInferenceJobsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListRxNormInferenceJobsRequestProtocolMarshaller(protocolFactory).marshall((ListRxNormInferenceJobsRequest)super.beforeMarshalling((AmazonWebServiceRequest)listRxNormInferenceJobsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"ComprehendMedical");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ListRxNormInferenceJobs");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListRxNormInferenceJobsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListRxNormInferenceJobsResult listRxNormInferenceJobsResult = (ListRxNormInferenceJobsResult)response.getAwsResponse();
            return listRxNormInferenceJobsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public StartEntitiesDetectionV2JobResult startEntitiesDetectionV2Job(StartEntitiesDetectionV2JobRequest request) {
        request = (StartEntitiesDetectionV2JobRequest)this.beforeClientExecution(request);
        return this.executeStartEntitiesDetectionV2Job(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final StartEntitiesDetectionV2JobResult executeStartEntitiesDetectionV2Job(StartEntitiesDetectionV2JobRequest startEntitiesDetectionV2JobRequest) {
        ExecutionContext executionContext = this.createExecutionContext(startEntitiesDetectionV2JobRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<StartEntitiesDetectionV2JobRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new StartEntitiesDetectionV2JobRequestProtocolMarshaller(protocolFactory).marshall((StartEntitiesDetectionV2JobRequest)super.beforeMarshalling((AmazonWebServiceRequest)startEntitiesDetectionV2JobRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"ComprehendMedical");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"StartEntitiesDetectionV2Job");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new StartEntitiesDetectionV2JobResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            StartEntitiesDetectionV2JobResult startEntitiesDetectionV2JobResult = (StartEntitiesDetectionV2JobResult)response.getAwsResponse();
            return startEntitiesDetectionV2JobResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public StartICD10CMInferenceJobResult startICD10CMInferenceJob(StartICD10CMInferenceJobRequest request) {
        request = (StartICD10CMInferenceJobRequest)this.beforeClientExecution(request);
        return this.executeStartICD10CMInferenceJob(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final StartICD10CMInferenceJobResult executeStartICD10CMInferenceJob(StartICD10CMInferenceJobRequest startICD10CMInferenceJobRequest) {
        ExecutionContext executionContext = this.createExecutionContext(startICD10CMInferenceJobRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<StartICD10CMInferenceJobRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new StartICD10CMInferenceJobRequestProtocolMarshaller(protocolFactory).marshall((StartICD10CMInferenceJobRequest)super.beforeMarshalling((AmazonWebServiceRequest)startICD10CMInferenceJobRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"ComprehendMedical");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"StartICD10CMInferenceJob");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new StartICD10CMInferenceJobResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            StartICD10CMInferenceJobResult startICD10CMInferenceJobResult = (StartICD10CMInferenceJobResult)response.getAwsResponse();
            return startICD10CMInferenceJobResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public StartPHIDetectionJobResult startPHIDetectionJob(StartPHIDetectionJobRequest request) {
        request = (StartPHIDetectionJobRequest)this.beforeClientExecution(request);
        return this.executeStartPHIDetectionJob(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final StartPHIDetectionJobResult executeStartPHIDetectionJob(StartPHIDetectionJobRequest startPHIDetectionJobRequest) {
        ExecutionContext executionContext = this.createExecutionContext(startPHIDetectionJobRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<StartPHIDetectionJobRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new StartPHIDetectionJobRequestProtocolMarshaller(protocolFactory).marshall((StartPHIDetectionJobRequest)super.beforeMarshalling((AmazonWebServiceRequest)startPHIDetectionJobRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"ComprehendMedical");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"StartPHIDetectionJob");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new StartPHIDetectionJobResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            StartPHIDetectionJobResult startPHIDetectionJobResult = (StartPHIDetectionJobResult)response.getAwsResponse();
            return startPHIDetectionJobResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public StartRxNormInferenceJobResult startRxNormInferenceJob(StartRxNormInferenceJobRequest request) {
        request = (StartRxNormInferenceJobRequest)this.beforeClientExecution(request);
        return this.executeStartRxNormInferenceJob(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final StartRxNormInferenceJobResult executeStartRxNormInferenceJob(StartRxNormInferenceJobRequest startRxNormInferenceJobRequest) {
        ExecutionContext executionContext = this.createExecutionContext(startRxNormInferenceJobRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<StartRxNormInferenceJobRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new StartRxNormInferenceJobRequestProtocolMarshaller(protocolFactory).marshall((StartRxNormInferenceJobRequest)super.beforeMarshalling((AmazonWebServiceRequest)startRxNormInferenceJobRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"ComprehendMedical");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"StartRxNormInferenceJob");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new StartRxNormInferenceJobResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            StartRxNormInferenceJobResult startRxNormInferenceJobResult = (StartRxNormInferenceJobResult)response.getAwsResponse();
            return startRxNormInferenceJobResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public StopEntitiesDetectionV2JobResult stopEntitiesDetectionV2Job(StopEntitiesDetectionV2JobRequest request) {
        request = (StopEntitiesDetectionV2JobRequest)this.beforeClientExecution(request);
        return this.executeStopEntitiesDetectionV2Job(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final StopEntitiesDetectionV2JobResult executeStopEntitiesDetectionV2Job(StopEntitiesDetectionV2JobRequest stopEntitiesDetectionV2JobRequest) {
        ExecutionContext executionContext = this.createExecutionContext(stopEntitiesDetectionV2JobRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<StopEntitiesDetectionV2JobRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new StopEntitiesDetectionV2JobRequestProtocolMarshaller(protocolFactory).marshall((StopEntitiesDetectionV2JobRequest)super.beforeMarshalling((AmazonWebServiceRequest)stopEntitiesDetectionV2JobRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"ComprehendMedical");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"StopEntitiesDetectionV2Job");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new StopEntitiesDetectionV2JobResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            StopEntitiesDetectionV2JobResult stopEntitiesDetectionV2JobResult = (StopEntitiesDetectionV2JobResult)response.getAwsResponse();
            return stopEntitiesDetectionV2JobResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public StopICD10CMInferenceJobResult stopICD10CMInferenceJob(StopICD10CMInferenceJobRequest request) {
        request = (StopICD10CMInferenceJobRequest)this.beforeClientExecution(request);
        return this.executeStopICD10CMInferenceJob(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final StopICD10CMInferenceJobResult executeStopICD10CMInferenceJob(StopICD10CMInferenceJobRequest stopICD10CMInferenceJobRequest) {
        ExecutionContext executionContext = this.createExecutionContext(stopICD10CMInferenceJobRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<StopICD10CMInferenceJobRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new StopICD10CMInferenceJobRequestProtocolMarshaller(protocolFactory).marshall((StopICD10CMInferenceJobRequest)super.beforeMarshalling((AmazonWebServiceRequest)stopICD10CMInferenceJobRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"ComprehendMedical");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"StopICD10CMInferenceJob");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new StopICD10CMInferenceJobResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            StopICD10CMInferenceJobResult stopICD10CMInferenceJobResult = (StopICD10CMInferenceJobResult)response.getAwsResponse();
            return stopICD10CMInferenceJobResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public StopPHIDetectionJobResult stopPHIDetectionJob(StopPHIDetectionJobRequest request) {
        request = (StopPHIDetectionJobRequest)this.beforeClientExecution(request);
        return this.executeStopPHIDetectionJob(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final StopPHIDetectionJobResult executeStopPHIDetectionJob(StopPHIDetectionJobRequest stopPHIDetectionJobRequest) {
        ExecutionContext executionContext = this.createExecutionContext(stopPHIDetectionJobRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<StopPHIDetectionJobRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new StopPHIDetectionJobRequestProtocolMarshaller(protocolFactory).marshall((StopPHIDetectionJobRequest)super.beforeMarshalling((AmazonWebServiceRequest)stopPHIDetectionJobRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"ComprehendMedical");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"StopPHIDetectionJob");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new StopPHIDetectionJobResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            StopPHIDetectionJobResult stopPHIDetectionJobResult = (StopPHIDetectionJobResult)response.getAwsResponse();
            return stopPHIDetectionJobResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public StopRxNormInferenceJobResult stopRxNormInferenceJob(StopRxNormInferenceJobRequest request) {
        request = (StopRxNormInferenceJobRequest)this.beforeClientExecution(request);
        return this.executeStopRxNormInferenceJob(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final StopRxNormInferenceJobResult executeStopRxNormInferenceJob(StopRxNormInferenceJobRequest stopRxNormInferenceJobRequest) {
        ExecutionContext executionContext = this.createExecutionContext(stopRxNormInferenceJobRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<StopRxNormInferenceJobRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new StopRxNormInferenceJobRequestProtocolMarshaller(protocolFactory).marshall((StopRxNormInferenceJobRequest)super.beforeMarshalling((AmazonWebServiceRequest)stopRxNormInferenceJobRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"ComprehendMedical");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"StopRxNormInferenceJob");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new StopRxNormInferenceJobResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            StopRxNormInferenceJobResult stopRxNormInferenceJobResult = (StopRxNormInferenceJobResult)response.getAwsResponse();
            return stopRxNormInferenceJobResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ResponseMetadata getCachedResponseMetadata(AmazonWebServiceRequest request) {
        return this.client.getResponseMetadataForRequest(request);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> invoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext) {
        return this.invoke(request, responseHandler, executionContext, null, null);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> invoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext, URI cachedEndpoint, URI uriFromEndpointTrait) {
        executionContext.setCredentialsProvider(CredentialUtils.getCredentialsProvider((AmazonWebServiceRequest)request.getOriginalRequest(), (AWSCredentialsProvider)this.awsCredentialsProvider));
        return this.doInvoke(request, responseHandler, executionContext, cachedEndpoint, uriFromEndpointTrait);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> anonymousInvoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext) {
        return this.doInvoke(request, responseHandler, executionContext, null, null);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> doInvoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext, URI discoveredEndpoint, URI uriFromEndpointTrait) {
        if (discoveredEndpoint != null) {
            request.setEndpoint(discoveredEndpoint);
            request.getOriginalRequest().getRequestClientOptions().appendUserAgent("endpoint-discovery");
        } else if (uriFromEndpointTrait != null) {
            request.setEndpoint(uriFromEndpointTrait);
        } else {
            request.setEndpoint(this.endpoint);
        }
        request.setTimeOffset(this.timeOffset);
        HttpResponseHandler errorResponseHandler = protocolFactory.createErrorResponseHandler(new JsonErrorResponseMetadata());
        return this.client.execute(request, responseHandler, errorResponseHandler, executionContext);
    }

    @SdkInternalApi
    static SdkJsonProtocolFactory getProtocolFactory() {
        return protocolFactory;
    }
}

