/*
 * Copyright 2018-2023 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.comprehend.model.transform;

import java.math.*;

import javax.annotation.Generated;

import com.amazonaws.services.comprehend.model.*;
import com.amazonaws.transform.SimpleTypeJsonUnmarshallers.*;
import com.amazonaws.transform.*;

import com.fasterxml.jackson.core.JsonToken;
import static com.fasterxml.jackson.core.JsonToken.*;

/**
 * DocumentClassifierInputDataConfig JSON Unmarshaller
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class DocumentClassifierInputDataConfigJsonUnmarshaller implements Unmarshaller<DocumentClassifierInputDataConfig, JsonUnmarshallerContext> {

    public DocumentClassifierInputDataConfig unmarshall(JsonUnmarshallerContext context) throws Exception {
        DocumentClassifierInputDataConfig documentClassifierInputDataConfig = new DocumentClassifierInputDataConfig();

        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;

        JsonToken token = context.getCurrentToken();
        if (token == null)
            token = context.nextToken();
        if (token == VALUE_NULL) {
            return null;
        }

        while (true) {
            if (token == null)
                break;

            if (token == FIELD_NAME || token == START_OBJECT) {
                if (context.testExpression("DataFormat", targetDepth)) {
                    context.nextToken();
                    documentClassifierInputDataConfig.setDataFormat(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("S3Uri", targetDepth)) {
                    context.nextToken();
                    documentClassifierInputDataConfig.setS3Uri(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("TestS3Uri", targetDepth)) {
                    context.nextToken();
                    documentClassifierInputDataConfig.setTestS3Uri(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("LabelDelimiter", targetDepth)) {
                    context.nextToken();
                    documentClassifierInputDataConfig.setLabelDelimiter(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("AugmentedManifests", targetDepth)) {
                    context.nextToken();
                    documentClassifierInputDataConfig.setAugmentedManifests(new ListUnmarshaller<AugmentedManifestsListItem>(
                            AugmentedManifestsListItemJsonUnmarshaller.getInstance())

                    .unmarshall(context));
                }
                if (context.testExpression("DocumentType", targetDepth)) {
                    context.nextToken();
                    documentClassifierInputDataConfig.setDocumentType(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("Documents", targetDepth)) {
                    context.nextToken();
                    documentClassifierInputDataConfig.setDocuments(DocumentClassifierDocumentsJsonUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("DocumentReaderConfig", targetDepth)) {
                    context.nextToken();
                    documentClassifierInputDataConfig.setDocumentReaderConfig(DocumentReaderConfigJsonUnmarshaller.getInstance().unmarshall(context));
                }
            } else if (token == END_ARRAY || token == END_OBJECT) {
                if (context.getLastParsedParentElement() == null || context.getLastParsedParentElement().equals(currentParentElement)) {
                    if (context.getCurrentDepth() <= originalDepth)
                        break;
                }
            }
            token = context.nextToken();
        }

        return documentClassifierInputDataConfig;
    }

    private static DocumentClassifierInputDataConfigJsonUnmarshaller instance;

    public static DocumentClassifierInputDataConfigJsonUnmarshaller getInstance() {
        if (instance == null)
            instance = new DocumentClassifierInputDataConfigJsonUnmarshaller();
        return instance;
    }
}
