/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.comprehend.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.comprehend.model.DocumentReadAction;
import com.amazonaws.services.comprehend.model.DocumentReadFeatureTypes;
import com.amazonaws.services.comprehend.model.DocumentReadMode;
import com.amazonaws.services.comprehend.model.transform.DocumentReaderConfigMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class DocumentReaderConfig
implements Serializable,
Cloneable,
StructuredPojo {
    private String documentReadAction;
    private String documentReadMode;
    private List<String> featureTypes;

    public void setDocumentReadAction(String documentReadAction) {
        this.documentReadAction = documentReadAction;
    }

    public String getDocumentReadAction() {
        return this.documentReadAction;
    }

    public DocumentReaderConfig withDocumentReadAction(String documentReadAction) {
        this.setDocumentReadAction(documentReadAction);
        return this;
    }

    public DocumentReaderConfig withDocumentReadAction(DocumentReadAction documentReadAction) {
        this.documentReadAction = documentReadAction.toString();
        return this;
    }

    public void setDocumentReadMode(String documentReadMode) {
        this.documentReadMode = documentReadMode;
    }

    public String getDocumentReadMode() {
        return this.documentReadMode;
    }

    public DocumentReaderConfig withDocumentReadMode(String documentReadMode) {
        this.setDocumentReadMode(documentReadMode);
        return this;
    }

    public DocumentReaderConfig withDocumentReadMode(DocumentReadMode documentReadMode) {
        this.documentReadMode = documentReadMode.toString();
        return this;
    }

    public List<String> getFeatureTypes() {
        return this.featureTypes;
    }

    public void setFeatureTypes(Collection<String> featureTypes) {
        if (featureTypes == null) {
            this.featureTypes = null;
            return;
        }
        this.featureTypes = new ArrayList<String>(featureTypes);
    }

    public DocumentReaderConfig withFeatureTypes(String ... featureTypes) {
        if (this.featureTypes == null) {
            this.setFeatureTypes(new ArrayList<String>(featureTypes.length));
        }
        for (String ele : featureTypes) {
            this.featureTypes.add(ele);
        }
        return this;
    }

    public DocumentReaderConfig withFeatureTypes(Collection<String> featureTypes) {
        this.setFeatureTypes(featureTypes);
        return this;
    }

    public DocumentReaderConfig withFeatureTypes(DocumentReadFeatureTypes ... featureTypes) {
        ArrayList<String> featureTypesCopy = new ArrayList<String>(featureTypes.length);
        for (DocumentReadFeatureTypes value : featureTypes) {
            featureTypesCopy.add(value.toString());
        }
        if (this.getFeatureTypes() == null) {
            this.setFeatureTypes(featureTypesCopy);
        } else {
            this.getFeatureTypes().addAll(featureTypesCopy);
        }
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getDocumentReadAction() != null) {
            sb.append("DocumentReadAction: ").append(this.getDocumentReadAction()).append(",");
        }
        if (this.getDocumentReadMode() != null) {
            sb.append("DocumentReadMode: ").append(this.getDocumentReadMode()).append(",");
        }
        if (this.getFeatureTypes() != null) {
            sb.append("FeatureTypes: ").append(this.getFeatureTypes());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DocumentReaderConfig)) {
            return false;
        }
        DocumentReaderConfig other = (DocumentReaderConfig)obj;
        if (other.getDocumentReadAction() == null ^ this.getDocumentReadAction() == null) {
            return false;
        }
        if (other.getDocumentReadAction() != null && !other.getDocumentReadAction().equals(this.getDocumentReadAction())) {
            return false;
        }
        if (other.getDocumentReadMode() == null ^ this.getDocumentReadMode() == null) {
            return false;
        }
        if (other.getDocumentReadMode() != null && !other.getDocumentReadMode().equals(this.getDocumentReadMode())) {
            return false;
        }
        if (other.getFeatureTypes() == null ^ this.getFeatureTypes() == null) {
            return false;
        }
        return other.getFeatureTypes() == null || other.getFeatureTypes().equals(this.getFeatureTypes());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getDocumentReadAction() == null ? 0 : this.getDocumentReadAction().hashCode());
        hashCode = 31 * hashCode + (this.getDocumentReadMode() == null ? 0 : this.getDocumentReadMode().hashCode());
        hashCode = 31 * hashCode + (this.getFeatureTypes() == null ? 0 : this.getFeatureTypes().hashCode());
        return hashCode;
    }

    public DocumentReaderConfig clone() {
        try {
            return (DocumentReaderConfig)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        DocumentReaderConfigMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

