/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cognitoidp.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.cognitoidp.model.DeviceType;
import java.util.Date;
import java.util.List;

@SdkInternalApi
public class DeviceTypeMarshaller {
    private static final MarshallingInfo<String> DEVICEKEY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DeviceKey").build();
    private static final MarshallingInfo<List> DEVICEATTRIBUTES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DeviceAttributes").build();
    private static final MarshallingInfo<Date> DEVICECREATEDATE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DeviceCreateDate").timestampFormat("unixTimestamp").build();
    private static final MarshallingInfo<Date> DEVICELASTMODIFIEDDATE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DeviceLastModifiedDate").timestampFormat("unixTimestamp").build();
    private static final MarshallingInfo<Date> DEVICELASTAUTHENTICATEDDATE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DeviceLastAuthenticatedDate").timestampFormat("unixTimestamp").build();
    private static final DeviceTypeMarshaller instance = new DeviceTypeMarshaller();

    public static DeviceTypeMarshaller getInstance() {
        return instance;
    }

    public void marshall(DeviceType deviceType, ProtocolMarshaller protocolMarshaller) {
        if (deviceType == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)deviceType.getDeviceKey(), DEVICEKEY_BINDING);
            protocolMarshaller.marshall(deviceType.getDeviceAttributes(), DEVICEATTRIBUTES_BINDING);
            protocolMarshaller.marshall((Object)deviceType.getDeviceCreateDate(), DEVICECREATEDATE_BINDING);
            protocolMarshaller.marshall((Object)deviceType.getDeviceLastModifiedDate(), DEVICELASTMODIFIEDDATE_BINDING);
            protocolMarshaller.marshall((Object)deviceType.getDeviceLastAuthenticatedDate(), DEVICELASTAUTHENTICATEDDATE_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

