/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.codepipeline;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.ClientConfiguration;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.DefaultAWSCredentialsProviderChain;
import com.amazonaws.client.AwsAsyncClientParams;
import com.amazonaws.client.AwsSyncClientParams;
import com.amazonaws.handlers.AsyncHandler;
import com.amazonaws.services.codepipeline.AWSCodePipelineAsync;
import com.amazonaws.services.codepipeline.AWSCodePipelineAsyncClientBuilder;
import com.amazonaws.services.codepipeline.AWSCodePipelineClient;
import com.amazonaws.services.codepipeline.model.AcknowledgeJobRequest;
import com.amazonaws.services.codepipeline.model.AcknowledgeJobResult;
import com.amazonaws.services.codepipeline.model.AcknowledgeThirdPartyJobRequest;
import com.amazonaws.services.codepipeline.model.AcknowledgeThirdPartyJobResult;
import com.amazonaws.services.codepipeline.model.CreateCustomActionTypeRequest;
import com.amazonaws.services.codepipeline.model.CreateCustomActionTypeResult;
import com.amazonaws.services.codepipeline.model.CreatePipelineRequest;
import com.amazonaws.services.codepipeline.model.CreatePipelineResult;
import com.amazonaws.services.codepipeline.model.DeleteCustomActionTypeRequest;
import com.amazonaws.services.codepipeline.model.DeleteCustomActionTypeResult;
import com.amazonaws.services.codepipeline.model.DeletePipelineRequest;
import com.amazonaws.services.codepipeline.model.DeletePipelineResult;
import com.amazonaws.services.codepipeline.model.DeleteWebhookRequest;
import com.amazonaws.services.codepipeline.model.DeleteWebhookResult;
import com.amazonaws.services.codepipeline.model.DeregisterWebhookWithThirdPartyRequest;
import com.amazonaws.services.codepipeline.model.DeregisterWebhookWithThirdPartyResult;
import com.amazonaws.services.codepipeline.model.DisableStageTransitionRequest;
import com.amazonaws.services.codepipeline.model.DisableStageTransitionResult;
import com.amazonaws.services.codepipeline.model.EnableStageTransitionRequest;
import com.amazonaws.services.codepipeline.model.EnableStageTransitionResult;
import com.amazonaws.services.codepipeline.model.GetJobDetailsRequest;
import com.amazonaws.services.codepipeline.model.GetJobDetailsResult;
import com.amazonaws.services.codepipeline.model.GetPipelineExecutionRequest;
import com.amazonaws.services.codepipeline.model.GetPipelineExecutionResult;
import com.amazonaws.services.codepipeline.model.GetPipelineRequest;
import com.amazonaws.services.codepipeline.model.GetPipelineResult;
import com.amazonaws.services.codepipeline.model.GetPipelineStateRequest;
import com.amazonaws.services.codepipeline.model.GetPipelineStateResult;
import com.amazonaws.services.codepipeline.model.GetThirdPartyJobDetailsRequest;
import com.amazonaws.services.codepipeline.model.GetThirdPartyJobDetailsResult;
import com.amazonaws.services.codepipeline.model.ListActionExecutionsRequest;
import com.amazonaws.services.codepipeline.model.ListActionExecutionsResult;
import com.amazonaws.services.codepipeline.model.ListActionTypesRequest;
import com.amazonaws.services.codepipeline.model.ListActionTypesResult;
import com.amazonaws.services.codepipeline.model.ListPipelineExecutionsRequest;
import com.amazonaws.services.codepipeline.model.ListPipelineExecutionsResult;
import com.amazonaws.services.codepipeline.model.ListPipelinesRequest;
import com.amazonaws.services.codepipeline.model.ListPipelinesResult;
import com.amazonaws.services.codepipeline.model.ListTagsForResourceRequest;
import com.amazonaws.services.codepipeline.model.ListTagsForResourceResult;
import com.amazonaws.services.codepipeline.model.ListWebhooksRequest;
import com.amazonaws.services.codepipeline.model.ListWebhooksResult;
import com.amazonaws.services.codepipeline.model.PollForJobsRequest;
import com.amazonaws.services.codepipeline.model.PollForJobsResult;
import com.amazonaws.services.codepipeline.model.PollForThirdPartyJobsRequest;
import com.amazonaws.services.codepipeline.model.PollForThirdPartyJobsResult;
import com.amazonaws.services.codepipeline.model.PutActionRevisionRequest;
import com.amazonaws.services.codepipeline.model.PutActionRevisionResult;
import com.amazonaws.services.codepipeline.model.PutApprovalResultRequest;
import com.amazonaws.services.codepipeline.model.PutApprovalResultResult;
import com.amazonaws.services.codepipeline.model.PutJobFailureResultRequest;
import com.amazonaws.services.codepipeline.model.PutJobFailureResultResult;
import com.amazonaws.services.codepipeline.model.PutJobSuccessResultRequest;
import com.amazonaws.services.codepipeline.model.PutJobSuccessResultResult;
import com.amazonaws.services.codepipeline.model.PutThirdPartyJobFailureResultRequest;
import com.amazonaws.services.codepipeline.model.PutThirdPartyJobFailureResultResult;
import com.amazonaws.services.codepipeline.model.PutThirdPartyJobSuccessResultRequest;
import com.amazonaws.services.codepipeline.model.PutThirdPartyJobSuccessResultResult;
import com.amazonaws.services.codepipeline.model.PutWebhookRequest;
import com.amazonaws.services.codepipeline.model.PutWebhookResult;
import com.amazonaws.services.codepipeline.model.RegisterWebhookWithThirdPartyRequest;
import com.amazonaws.services.codepipeline.model.RegisterWebhookWithThirdPartyResult;
import com.amazonaws.services.codepipeline.model.RetryStageExecutionRequest;
import com.amazonaws.services.codepipeline.model.RetryStageExecutionResult;
import com.amazonaws.services.codepipeline.model.StartPipelineExecutionRequest;
import com.amazonaws.services.codepipeline.model.StartPipelineExecutionResult;
import com.amazonaws.services.codepipeline.model.StopPipelineExecutionRequest;
import com.amazonaws.services.codepipeline.model.StopPipelineExecutionResult;
import com.amazonaws.services.codepipeline.model.TagResourceRequest;
import com.amazonaws.services.codepipeline.model.TagResourceResult;
import com.amazonaws.services.codepipeline.model.UntagResourceRequest;
import com.amazonaws.services.codepipeline.model.UntagResourceResult;
import com.amazonaws.services.codepipeline.model.UpdatePipelineRequest;
import com.amazonaws.services.codepipeline.model.UpdatePipelineResult;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;

@ThreadSafe
public class AWSCodePipelineAsyncClient
extends AWSCodePipelineClient
implements AWSCodePipelineAsync {
    private static final int DEFAULT_THREAD_POOL_SIZE = 50;
    private final ExecutorService executorService;

    @Deprecated
    public AWSCodePipelineAsyncClient() {
        this((AWSCredentialsProvider)DefaultAWSCredentialsProviderChain.getInstance());
    }

    @Deprecated
    public AWSCodePipelineAsyncClient(ClientConfiguration clientConfiguration) {
        this((AWSCredentialsProvider)DefaultAWSCredentialsProviderChain.getInstance(), clientConfiguration, Executors.newFixedThreadPool(clientConfiguration.getMaxConnections()));
    }

    @Deprecated
    public AWSCodePipelineAsyncClient(AWSCredentials awsCredentials) {
        this(awsCredentials, Executors.newFixedThreadPool(50));
    }

    @Deprecated
    public AWSCodePipelineAsyncClient(AWSCredentials awsCredentials, ExecutorService executorService) {
        this(awsCredentials, configFactory.getConfig(), executorService);
    }

    @Deprecated
    public AWSCodePipelineAsyncClient(AWSCredentials awsCredentials, ClientConfiguration clientConfiguration, ExecutorService executorService) {
        super(awsCredentials, clientConfiguration);
        this.executorService = executorService;
    }

    @Deprecated
    public AWSCodePipelineAsyncClient(AWSCredentialsProvider awsCredentialsProvider) {
        this(awsCredentialsProvider, Executors.newFixedThreadPool(50));
    }

    @Deprecated
    public AWSCodePipelineAsyncClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration) {
        this(awsCredentialsProvider, clientConfiguration, Executors.newFixedThreadPool(clientConfiguration.getMaxConnections()));
    }

    @Deprecated
    public AWSCodePipelineAsyncClient(AWSCredentialsProvider awsCredentialsProvider, ExecutorService executorService) {
        this(awsCredentialsProvider, configFactory.getConfig(), executorService);
    }

    @Deprecated
    public AWSCodePipelineAsyncClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration, ExecutorService executorService) {
        super(awsCredentialsProvider, clientConfiguration);
        this.executorService = executorService;
    }

    public static AWSCodePipelineAsyncClientBuilder asyncBuilder() {
        return AWSCodePipelineAsyncClientBuilder.standard();
    }

    AWSCodePipelineAsyncClient(AwsAsyncClientParams asyncClientParams) {
        this(asyncClientParams, false);
    }

    AWSCodePipelineAsyncClient(AwsAsyncClientParams asyncClientParams, boolean endpointDiscoveryEnabled) {
        super((AwsSyncClientParams)asyncClientParams, endpointDiscoveryEnabled);
        this.executorService = asyncClientParams.getExecutor();
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    @Override
    public Future<AcknowledgeJobResult> acknowledgeJobAsync(AcknowledgeJobRequest request) {
        return this.acknowledgeJobAsync(request, null);
    }

    @Override
    public Future<AcknowledgeJobResult> acknowledgeJobAsync(AcknowledgeJobRequest request, final AsyncHandler<AcknowledgeJobRequest, AcknowledgeJobResult> asyncHandler) {
        final AcknowledgeJobRequest finalRequest = (AcknowledgeJobRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<AcknowledgeJobResult>(){

            @Override
            public AcknowledgeJobResult call() throws Exception {
                AcknowledgeJobResult result = null;
                try {
                    result = AWSCodePipelineAsyncClient.this.executeAcknowledgeJob(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<AcknowledgeThirdPartyJobResult> acknowledgeThirdPartyJobAsync(AcknowledgeThirdPartyJobRequest request) {
        return this.acknowledgeThirdPartyJobAsync(request, null);
    }

    @Override
    public Future<AcknowledgeThirdPartyJobResult> acknowledgeThirdPartyJobAsync(AcknowledgeThirdPartyJobRequest request, final AsyncHandler<AcknowledgeThirdPartyJobRequest, AcknowledgeThirdPartyJobResult> asyncHandler) {
        final AcknowledgeThirdPartyJobRequest finalRequest = (AcknowledgeThirdPartyJobRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<AcknowledgeThirdPartyJobResult>(){

            @Override
            public AcknowledgeThirdPartyJobResult call() throws Exception {
                AcknowledgeThirdPartyJobResult result = null;
                try {
                    result = AWSCodePipelineAsyncClient.this.executeAcknowledgeThirdPartyJob(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CreateCustomActionTypeResult> createCustomActionTypeAsync(CreateCustomActionTypeRequest request) {
        return this.createCustomActionTypeAsync(request, null);
    }

    @Override
    public Future<CreateCustomActionTypeResult> createCustomActionTypeAsync(CreateCustomActionTypeRequest request, final AsyncHandler<CreateCustomActionTypeRequest, CreateCustomActionTypeResult> asyncHandler) {
        final CreateCustomActionTypeRequest finalRequest = (CreateCustomActionTypeRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CreateCustomActionTypeResult>(){

            @Override
            public CreateCustomActionTypeResult call() throws Exception {
                CreateCustomActionTypeResult result = null;
                try {
                    result = AWSCodePipelineAsyncClient.this.executeCreateCustomActionType(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CreatePipelineResult> createPipelineAsync(CreatePipelineRequest request) {
        return this.createPipelineAsync(request, null);
    }

    @Override
    public Future<CreatePipelineResult> createPipelineAsync(CreatePipelineRequest request, final AsyncHandler<CreatePipelineRequest, CreatePipelineResult> asyncHandler) {
        final CreatePipelineRequest finalRequest = (CreatePipelineRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CreatePipelineResult>(){

            @Override
            public CreatePipelineResult call() throws Exception {
                CreatePipelineResult result = null;
                try {
                    result = AWSCodePipelineAsyncClient.this.executeCreatePipeline(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteCustomActionTypeResult> deleteCustomActionTypeAsync(DeleteCustomActionTypeRequest request) {
        return this.deleteCustomActionTypeAsync(request, null);
    }

    @Override
    public Future<DeleteCustomActionTypeResult> deleteCustomActionTypeAsync(DeleteCustomActionTypeRequest request, final AsyncHandler<DeleteCustomActionTypeRequest, DeleteCustomActionTypeResult> asyncHandler) {
        final DeleteCustomActionTypeRequest finalRequest = (DeleteCustomActionTypeRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DeleteCustomActionTypeResult>(){

            @Override
            public DeleteCustomActionTypeResult call() throws Exception {
                DeleteCustomActionTypeResult result = null;
                try {
                    result = AWSCodePipelineAsyncClient.this.executeDeleteCustomActionType(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeletePipelineResult> deletePipelineAsync(DeletePipelineRequest request) {
        return this.deletePipelineAsync(request, null);
    }

    @Override
    public Future<DeletePipelineResult> deletePipelineAsync(DeletePipelineRequest request, final AsyncHandler<DeletePipelineRequest, DeletePipelineResult> asyncHandler) {
        final DeletePipelineRequest finalRequest = (DeletePipelineRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DeletePipelineResult>(){

            @Override
            public DeletePipelineResult call() throws Exception {
                DeletePipelineResult result = null;
                try {
                    result = AWSCodePipelineAsyncClient.this.executeDeletePipeline(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteWebhookResult> deleteWebhookAsync(DeleteWebhookRequest request) {
        return this.deleteWebhookAsync(request, null);
    }

    @Override
    public Future<DeleteWebhookResult> deleteWebhookAsync(DeleteWebhookRequest request, final AsyncHandler<DeleteWebhookRequest, DeleteWebhookResult> asyncHandler) {
        final DeleteWebhookRequest finalRequest = (DeleteWebhookRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DeleteWebhookResult>(){

            @Override
            public DeleteWebhookResult call() throws Exception {
                DeleteWebhookResult result = null;
                try {
                    result = AWSCodePipelineAsyncClient.this.executeDeleteWebhook(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeregisterWebhookWithThirdPartyResult> deregisterWebhookWithThirdPartyAsync(DeregisterWebhookWithThirdPartyRequest request) {
        return this.deregisterWebhookWithThirdPartyAsync(request, null);
    }

    @Override
    public Future<DeregisterWebhookWithThirdPartyResult> deregisterWebhookWithThirdPartyAsync(DeregisterWebhookWithThirdPartyRequest request, final AsyncHandler<DeregisterWebhookWithThirdPartyRequest, DeregisterWebhookWithThirdPartyResult> asyncHandler) {
        final DeregisterWebhookWithThirdPartyRequest finalRequest = (DeregisterWebhookWithThirdPartyRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DeregisterWebhookWithThirdPartyResult>(){

            @Override
            public DeregisterWebhookWithThirdPartyResult call() throws Exception {
                DeregisterWebhookWithThirdPartyResult result = null;
                try {
                    result = AWSCodePipelineAsyncClient.this.executeDeregisterWebhookWithThirdParty(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DisableStageTransitionResult> disableStageTransitionAsync(DisableStageTransitionRequest request) {
        return this.disableStageTransitionAsync(request, null);
    }

    @Override
    public Future<DisableStageTransitionResult> disableStageTransitionAsync(DisableStageTransitionRequest request, final AsyncHandler<DisableStageTransitionRequest, DisableStageTransitionResult> asyncHandler) {
        final DisableStageTransitionRequest finalRequest = (DisableStageTransitionRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DisableStageTransitionResult>(){

            @Override
            public DisableStageTransitionResult call() throws Exception {
                DisableStageTransitionResult result = null;
                try {
                    result = AWSCodePipelineAsyncClient.this.executeDisableStageTransition(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<EnableStageTransitionResult> enableStageTransitionAsync(EnableStageTransitionRequest request) {
        return this.enableStageTransitionAsync(request, null);
    }

    @Override
    public Future<EnableStageTransitionResult> enableStageTransitionAsync(EnableStageTransitionRequest request, final AsyncHandler<EnableStageTransitionRequest, EnableStageTransitionResult> asyncHandler) {
        final EnableStageTransitionRequest finalRequest = (EnableStageTransitionRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<EnableStageTransitionResult>(){

            @Override
            public EnableStageTransitionResult call() throws Exception {
                EnableStageTransitionResult result = null;
                try {
                    result = AWSCodePipelineAsyncClient.this.executeEnableStageTransition(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetJobDetailsResult> getJobDetailsAsync(GetJobDetailsRequest request) {
        return this.getJobDetailsAsync(request, null);
    }

    @Override
    public Future<GetJobDetailsResult> getJobDetailsAsync(GetJobDetailsRequest request, final AsyncHandler<GetJobDetailsRequest, GetJobDetailsResult> asyncHandler) {
        final GetJobDetailsRequest finalRequest = (GetJobDetailsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetJobDetailsResult>(){

            @Override
            public GetJobDetailsResult call() throws Exception {
                GetJobDetailsResult result = null;
                try {
                    result = AWSCodePipelineAsyncClient.this.executeGetJobDetails(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetPipelineResult> getPipelineAsync(GetPipelineRequest request) {
        return this.getPipelineAsync(request, null);
    }

    @Override
    public Future<GetPipelineResult> getPipelineAsync(GetPipelineRequest request, final AsyncHandler<GetPipelineRequest, GetPipelineResult> asyncHandler) {
        final GetPipelineRequest finalRequest = (GetPipelineRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetPipelineResult>(){

            @Override
            public GetPipelineResult call() throws Exception {
                GetPipelineResult result = null;
                try {
                    result = AWSCodePipelineAsyncClient.this.executeGetPipeline(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetPipelineExecutionResult> getPipelineExecutionAsync(GetPipelineExecutionRequest request) {
        return this.getPipelineExecutionAsync(request, null);
    }

    @Override
    public Future<GetPipelineExecutionResult> getPipelineExecutionAsync(GetPipelineExecutionRequest request, final AsyncHandler<GetPipelineExecutionRequest, GetPipelineExecutionResult> asyncHandler) {
        final GetPipelineExecutionRequest finalRequest = (GetPipelineExecutionRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetPipelineExecutionResult>(){

            @Override
            public GetPipelineExecutionResult call() throws Exception {
                GetPipelineExecutionResult result = null;
                try {
                    result = AWSCodePipelineAsyncClient.this.executeGetPipelineExecution(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetPipelineStateResult> getPipelineStateAsync(GetPipelineStateRequest request) {
        return this.getPipelineStateAsync(request, null);
    }

    @Override
    public Future<GetPipelineStateResult> getPipelineStateAsync(GetPipelineStateRequest request, final AsyncHandler<GetPipelineStateRequest, GetPipelineStateResult> asyncHandler) {
        final GetPipelineStateRequest finalRequest = (GetPipelineStateRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetPipelineStateResult>(){

            @Override
            public GetPipelineStateResult call() throws Exception {
                GetPipelineStateResult result = null;
                try {
                    result = AWSCodePipelineAsyncClient.this.executeGetPipelineState(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetThirdPartyJobDetailsResult> getThirdPartyJobDetailsAsync(GetThirdPartyJobDetailsRequest request) {
        return this.getThirdPartyJobDetailsAsync(request, null);
    }

    @Override
    public Future<GetThirdPartyJobDetailsResult> getThirdPartyJobDetailsAsync(GetThirdPartyJobDetailsRequest request, final AsyncHandler<GetThirdPartyJobDetailsRequest, GetThirdPartyJobDetailsResult> asyncHandler) {
        final GetThirdPartyJobDetailsRequest finalRequest = (GetThirdPartyJobDetailsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetThirdPartyJobDetailsResult>(){

            @Override
            public GetThirdPartyJobDetailsResult call() throws Exception {
                GetThirdPartyJobDetailsResult result = null;
                try {
                    result = AWSCodePipelineAsyncClient.this.executeGetThirdPartyJobDetails(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListActionExecutionsResult> listActionExecutionsAsync(ListActionExecutionsRequest request) {
        return this.listActionExecutionsAsync(request, null);
    }

    @Override
    public Future<ListActionExecutionsResult> listActionExecutionsAsync(ListActionExecutionsRequest request, final AsyncHandler<ListActionExecutionsRequest, ListActionExecutionsResult> asyncHandler) {
        final ListActionExecutionsRequest finalRequest = (ListActionExecutionsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListActionExecutionsResult>(){

            @Override
            public ListActionExecutionsResult call() throws Exception {
                ListActionExecutionsResult result = null;
                try {
                    result = AWSCodePipelineAsyncClient.this.executeListActionExecutions(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListActionTypesResult> listActionTypesAsync(ListActionTypesRequest request) {
        return this.listActionTypesAsync(request, null);
    }

    @Override
    public Future<ListActionTypesResult> listActionTypesAsync(ListActionTypesRequest request, final AsyncHandler<ListActionTypesRequest, ListActionTypesResult> asyncHandler) {
        final ListActionTypesRequest finalRequest = (ListActionTypesRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListActionTypesResult>(){

            @Override
            public ListActionTypesResult call() throws Exception {
                ListActionTypesResult result = null;
                try {
                    result = AWSCodePipelineAsyncClient.this.executeListActionTypes(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListPipelineExecutionsResult> listPipelineExecutionsAsync(ListPipelineExecutionsRequest request) {
        return this.listPipelineExecutionsAsync(request, null);
    }

    @Override
    public Future<ListPipelineExecutionsResult> listPipelineExecutionsAsync(ListPipelineExecutionsRequest request, final AsyncHandler<ListPipelineExecutionsRequest, ListPipelineExecutionsResult> asyncHandler) {
        final ListPipelineExecutionsRequest finalRequest = (ListPipelineExecutionsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListPipelineExecutionsResult>(){

            @Override
            public ListPipelineExecutionsResult call() throws Exception {
                ListPipelineExecutionsResult result = null;
                try {
                    result = AWSCodePipelineAsyncClient.this.executeListPipelineExecutions(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListPipelinesResult> listPipelinesAsync(ListPipelinesRequest request) {
        return this.listPipelinesAsync(request, null);
    }

    @Override
    public Future<ListPipelinesResult> listPipelinesAsync(ListPipelinesRequest request, final AsyncHandler<ListPipelinesRequest, ListPipelinesResult> asyncHandler) {
        final ListPipelinesRequest finalRequest = (ListPipelinesRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListPipelinesResult>(){

            @Override
            public ListPipelinesResult call() throws Exception {
                ListPipelinesResult result = null;
                try {
                    result = AWSCodePipelineAsyncClient.this.executeListPipelines(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListTagsForResourceResult> listTagsForResourceAsync(ListTagsForResourceRequest request) {
        return this.listTagsForResourceAsync(request, null);
    }

    @Override
    public Future<ListTagsForResourceResult> listTagsForResourceAsync(ListTagsForResourceRequest request, final AsyncHandler<ListTagsForResourceRequest, ListTagsForResourceResult> asyncHandler) {
        final ListTagsForResourceRequest finalRequest = (ListTagsForResourceRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListTagsForResourceResult>(){

            @Override
            public ListTagsForResourceResult call() throws Exception {
                ListTagsForResourceResult result = null;
                try {
                    result = AWSCodePipelineAsyncClient.this.executeListTagsForResource(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListWebhooksResult> listWebhooksAsync(ListWebhooksRequest request) {
        return this.listWebhooksAsync(request, null);
    }

    @Override
    public Future<ListWebhooksResult> listWebhooksAsync(ListWebhooksRequest request, final AsyncHandler<ListWebhooksRequest, ListWebhooksResult> asyncHandler) {
        final ListWebhooksRequest finalRequest = (ListWebhooksRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListWebhooksResult>(){

            @Override
            public ListWebhooksResult call() throws Exception {
                ListWebhooksResult result = null;
                try {
                    result = AWSCodePipelineAsyncClient.this.executeListWebhooks(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<PollForJobsResult> pollForJobsAsync(PollForJobsRequest request) {
        return this.pollForJobsAsync(request, null);
    }

    @Override
    public Future<PollForJobsResult> pollForJobsAsync(PollForJobsRequest request, final AsyncHandler<PollForJobsRequest, PollForJobsResult> asyncHandler) {
        final PollForJobsRequest finalRequest = (PollForJobsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<PollForJobsResult>(){

            @Override
            public PollForJobsResult call() throws Exception {
                PollForJobsResult result = null;
                try {
                    result = AWSCodePipelineAsyncClient.this.executePollForJobs(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<PollForThirdPartyJobsResult> pollForThirdPartyJobsAsync(PollForThirdPartyJobsRequest request) {
        return this.pollForThirdPartyJobsAsync(request, null);
    }

    @Override
    public Future<PollForThirdPartyJobsResult> pollForThirdPartyJobsAsync(PollForThirdPartyJobsRequest request, final AsyncHandler<PollForThirdPartyJobsRequest, PollForThirdPartyJobsResult> asyncHandler) {
        final PollForThirdPartyJobsRequest finalRequest = (PollForThirdPartyJobsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<PollForThirdPartyJobsResult>(){

            @Override
            public PollForThirdPartyJobsResult call() throws Exception {
                PollForThirdPartyJobsResult result = null;
                try {
                    result = AWSCodePipelineAsyncClient.this.executePollForThirdPartyJobs(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<PutActionRevisionResult> putActionRevisionAsync(PutActionRevisionRequest request) {
        return this.putActionRevisionAsync(request, null);
    }

    @Override
    public Future<PutActionRevisionResult> putActionRevisionAsync(PutActionRevisionRequest request, final AsyncHandler<PutActionRevisionRequest, PutActionRevisionResult> asyncHandler) {
        final PutActionRevisionRequest finalRequest = (PutActionRevisionRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<PutActionRevisionResult>(){

            @Override
            public PutActionRevisionResult call() throws Exception {
                PutActionRevisionResult result = null;
                try {
                    result = AWSCodePipelineAsyncClient.this.executePutActionRevision(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<PutApprovalResultResult> putApprovalResultAsync(PutApprovalResultRequest request) {
        return this.putApprovalResultAsync(request, null);
    }

    @Override
    public Future<PutApprovalResultResult> putApprovalResultAsync(PutApprovalResultRequest request, final AsyncHandler<PutApprovalResultRequest, PutApprovalResultResult> asyncHandler) {
        final PutApprovalResultRequest finalRequest = (PutApprovalResultRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<PutApprovalResultResult>(){

            @Override
            public PutApprovalResultResult call() throws Exception {
                PutApprovalResultResult result = null;
                try {
                    result = AWSCodePipelineAsyncClient.this.executePutApprovalResult(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<PutJobFailureResultResult> putJobFailureResultAsync(PutJobFailureResultRequest request) {
        return this.putJobFailureResultAsync(request, null);
    }

    @Override
    public Future<PutJobFailureResultResult> putJobFailureResultAsync(PutJobFailureResultRequest request, final AsyncHandler<PutJobFailureResultRequest, PutJobFailureResultResult> asyncHandler) {
        final PutJobFailureResultRequest finalRequest = (PutJobFailureResultRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<PutJobFailureResultResult>(){

            @Override
            public PutJobFailureResultResult call() throws Exception {
                PutJobFailureResultResult result = null;
                try {
                    result = AWSCodePipelineAsyncClient.this.executePutJobFailureResult(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<PutJobSuccessResultResult> putJobSuccessResultAsync(PutJobSuccessResultRequest request) {
        return this.putJobSuccessResultAsync(request, null);
    }

    @Override
    public Future<PutJobSuccessResultResult> putJobSuccessResultAsync(PutJobSuccessResultRequest request, final AsyncHandler<PutJobSuccessResultRequest, PutJobSuccessResultResult> asyncHandler) {
        final PutJobSuccessResultRequest finalRequest = (PutJobSuccessResultRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<PutJobSuccessResultResult>(){

            @Override
            public PutJobSuccessResultResult call() throws Exception {
                PutJobSuccessResultResult result = null;
                try {
                    result = AWSCodePipelineAsyncClient.this.executePutJobSuccessResult(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<PutThirdPartyJobFailureResultResult> putThirdPartyJobFailureResultAsync(PutThirdPartyJobFailureResultRequest request) {
        return this.putThirdPartyJobFailureResultAsync(request, null);
    }

    @Override
    public Future<PutThirdPartyJobFailureResultResult> putThirdPartyJobFailureResultAsync(PutThirdPartyJobFailureResultRequest request, final AsyncHandler<PutThirdPartyJobFailureResultRequest, PutThirdPartyJobFailureResultResult> asyncHandler) {
        final PutThirdPartyJobFailureResultRequest finalRequest = (PutThirdPartyJobFailureResultRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<PutThirdPartyJobFailureResultResult>(){

            @Override
            public PutThirdPartyJobFailureResultResult call() throws Exception {
                PutThirdPartyJobFailureResultResult result = null;
                try {
                    result = AWSCodePipelineAsyncClient.this.executePutThirdPartyJobFailureResult(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<PutThirdPartyJobSuccessResultResult> putThirdPartyJobSuccessResultAsync(PutThirdPartyJobSuccessResultRequest request) {
        return this.putThirdPartyJobSuccessResultAsync(request, null);
    }

    @Override
    public Future<PutThirdPartyJobSuccessResultResult> putThirdPartyJobSuccessResultAsync(PutThirdPartyJobSuccessResultRequest request, final AsyncHandler<PutThirdPartyJobSuccessResultRequest, PutThirdPartyJobSuccessResultResult> asyncHandler) {
        final PutThirdPartyJobSuccessResultRequest finalRequest = (PutThirdPartyJobSuccessResultRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<PutThirdPartyJobSuccessResultResult>(){

            @Override
            public PutThirdPartyJobSuccessResultResult call() throws Exception {
                PutThirdPartyJobSuccessResultResult result = null;
                try {
                    result = AWSCodePipelineAsyncClient.this.executePutThirdPartyJobSuccessResult(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<PutWebhookResult> putWebhookAsync(PutWebhookRequest request) {
        return this.putWebhookAsync(request, null);
    }

    @Override
    public Future<PutWebhookResult> putWebhookAsync(PutWebhookRequest request, final AsyncHandler<PutWebhookRequest, PutWebhookResult> asyncHandler) {
        final PutWebhookRequest finalRequest = (PutWebhookRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<PutWebhookResult>(){

            @Override
            public PutWebhookResult call() throws Exception {
                PutWebhookResult result = null;
                try {
                    result = AWSCodePipelineAsyncClient.this.executePutWebhook(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<RegisterWebhookWithThirdPartyResult> registerWebhookWithThirdPartyAsync(RegisterWebhookWithThirdPartyRequest request) {
        return this.registerWebhookWithThirdPartyAsync(request, null);
    }

    @Override
    public Future<RegisterWebhookWithThirdPartyResult> registerWebhookWithThirdPartyAsync(RegisterWebhookWithThirdPartyRequest request, final AsyncHandler<RegisterWebhookWithThirdPartyRequest, RegisterWebhookWithThirdPartyResult> asyncHandler) {
        final RegisterWebhookWithThirdPartyRequest finalRequest = (RegisterWebhookWithThirdPartyRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<RegisterWebhookWithThirdPartyResult>(){

            @Override
            public RegisterWebhookWithThirdPartyResult call() throws Exception {
                RegisterWebhookWithThirdPartyResult result = null;
                try {
                    result = AWSCodePipelineAsyncClient.this.executeRegisterWebhookWithThirdParty(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<RetryStageExecutionResult> retryStageExecutionAsync(RetryStageExecutionRequest request) {
        return this.retryStageExecutionAsync(request, null);
    }

    @Override
    public Future<RetryStageExecutionResult> retryStageExecutionAsync(RetryStageExecutionRequest request, final AsyncHandler<RetryStageExecutionRequest, RetryStageExecutionResult> asyncHandler) {
        final RetryStageExecutionRequest finalRequest = (RetryStageExecutionRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<RetryStageExecutionResult>(){

            @Override
            public RetryStageExecutionResult call() throws Exception {
                RetryStageExecutionResult result = null;
                try {
                    result = AWSCodePipelineAsyncClient.this.executeRetryStageExecution(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<StartPipelineExecutionResult> startPipelineExecutionAsync(StartPipelineExecutionRequest request) {
        return this.startPipelineExecutionAsync(request, null);
    }

    @Override
    public Future<StartPipelineExecutionResult> startPipelineExecutionAsync(StartPipelineExecutionRequest request, final AsyncHandler<StartPipelineExecutionRequest, StartPipelineExecutionResult> asyncHandler) {
        final StartPipelineExecutionRequest finalRequest = (StartPipelineExecutionRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<StartPipelineExecutionResult>(){

            @Override
            public StartPipelineExecutionResult call() throws Exception {
                StartPipelineExecutionResult result = null;
                try {
                    result = AWSCodePipelineAsyncClient.this.executeStartPipelineExecution(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<StopPipelineExecutionResult> stopPipelineExecutionAsync(StopPipelineExecutionRequest request) {
        return this.stopPipelineExecutionAsync(request, null);
    }

    @Override
    public Future<StopPipelineExecutionResult> stopPipelineExecutionAsync(StopPipelineExecutionRequest request, final AsyncHandler<StopPipelineExecutionRequest, StopPipelineExecutionResult> asyncHandler) {
        final StopPipelineExecutionRequest finalRequest = (StopPipelineExecutionRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<StopPipelineExecutionResult>(){

            @Override
            public StopPipelineExecutionResult call() throws Exception {
                StopPipelineExecutionResult result = null;
                try {
                    result = AWSCodePipelineAsyncClient.this.executeStopPipelineExecution(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<TagResourceResult> tagResourceAsync(TagResourceRequest request) {
        return this.tagResourceAsync(request, null);
    }

    @Override
    public Future<TagResourceResult> tagResourceAsync(TagResourceRequest request, final AsyncHandler<TagResourceRequest, TagResourceResult> asyncHandler) {
        final TagResourceRequest finalRequest = (TagResourceRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<TagResourceResult>(){

            @Override
            public TagResourceResult call() throws Exception {
                TagResourceResult result = null;
                try {
                    result = AWSCodePipelineAsyncClient.this.executeTagResource(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UntagResourceResult> untagResourceAsync(UntagResourceRequest request) {
        return this.untagResourceAsync(request, null);
    }

    @Override
    public Future<UntagResourceResult> untagResourceAsync(UntagResourceRequest request, final AsyncHandler<UntagResourceRequest, UntagResourceResult> asyncHandler) {
        final UntagResourceRequest finalRequest = (UntagResourceRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<UntagResourceResult>(){

            @Override
            public UntagResourceResult call() throws Exception {
                UntagResourceResult result = null;
                try {
                    result = AWSCodePipelineAsyncClient.this.executeUntagResource(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UpdatePipelineResult> updatePipelineAsync(UpdatePipelineRequest request) {
        return this.updatePipelineAsync(request, null);
    }

    @Override
    public Future<UpdatePipelineResult> updatePipelineAsync(UpdatePipelineRequest request, final AsyncHandler<UpdatePipelineRequest, UpdatePipelineResult> asyncHandler) {
        final UpdatePipelineRequest finalRequest = (UpdatePipelineRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<UpdatePipelineResult>(){

            @Override
            public UpdatePipelineResult call() throws Exception {
                UpdatePipelineResult result = null;
                try {
                    result = AWSCodePipelineAsyncClient.this.executeUpdatePipeline(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public void shutdown() {
        super.shutdown();
        this.executorService.shutdownNow();
    }
}

