/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.codeguruprofiler.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.codeguruprofiler.model.AggregationPeriod;
import com.amazonaws.services.codeguruprofiler.model.FrameMetric;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;

public class BatchGetFrameMetricDataRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private Date endTime;
    private List<FrameMetric> frameMetrics;
    private String period;
    private String profilingGroupName;
    private Date startTime;
    private String targetResolution;

    public void setEndTime(Date endTime) {
        this.endTime = endTime;
    }

    public Date getEndTime() {
        return this.endTime;
    }

    public BatchGetFrameMetricDataRequest withEndTime(Date endTime) {
        this.setEndTime(endTime);
        return this;
    }

    public List<FrameMetric> getFrameMetrics() {
        return this.frameMetrics;
    }

    public void setFrameMetrics(Collection<FrameMetric> frameMetrics) {
        if (frameMetrics == null) {
            this.frameMetrics = null;
            return;
        }
        this.frameMetrics = new ArrayList<FrameMetric>(frameMetrics);
    }

    public BatchGetFrameMetricDataRequest withFrameMetrics(FrameMetric ... frameMetrics) {
        if (this.frameMetrics == null) {
            this.setFrameMetrics(new ArrayList<FrameMetric>(frameMetrics.length));
        }
        for (FrameMetric ele : frameMetrics) {
            this.frameMetrics.add(ele);
        }
        return this;
    }

    public BatchGetFrameMetricDataRequest withFrameMetrics(Collection<FrameMetric> frameMetrics) {
        this.setFrameMetrics(frameMetrics);
        return this;
    }

    public void setPeriod(String period) {
        this.period = period;
    }

    public String getPeriod() {
        return this.period;
    }

    public BatchGetFrameMetricDataRequest withPeriod(String period) {
        this.setPeriod(period);
        return this;
    }

    public void setProfilingGroupName(String profilingGroupName) {
        this.profilingGroupName = profilingGroupName;
    }

    public String getProfilingGroupName() {
        return this.profilingGroupName;
    }

    public BatchGetFrameMetricDataRequest withProfilingGroupName(String profilingGroupName) {
        this.setProfilingGroupName(profilingGroupName);
        return this;
    }

    public void setStartTime(Date startTime) {
        this.startTime = startTime;
    }

    public Date getStartTime() {
        return this.startTime;
    }

    public BatchGetFrameMetricDataRequest withStartTime(Date startTime) {
        this.setStartTime(startTime);
        return this;
    }

    public void setTargetResolution(String targetResolution) {
        this.targetResolution = targetResolution;
    }

    public String getTargetResolution() {
        return this.targetResolution;
    }

    public BatchGetFrameMetricDataRequest withTargetResolution(String targetResolution) {
        this.setTargetResolution(targetResolution);
        return this;
    }

    public BatchGetFrameMetricDataRequest withTargetResolution(AggregationPeriod targetResolution) {
        this.targetResolution = targetResolution.toString();
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getEndTime() != null) {
            sb.append("EndTime: ").append(this.getEndTime()).append(",");
        }
        if (this.getFrameMetrics() != null) {
            sb.append("FrameMetrics: ").append(this.getFrameMetrics()).append(",");
        }
        if (this.getPeriod() != null) {
            sb.append("Period: ").append(this.getPeriod()).append(",");
        }
        if (this.getProfilingGroupName() != null) {
            sb.append("ProfilingGroupName: ").append(this.getProfilingGroupName()).append(",");
        }
        if (this.getStartTime() != null) {
            sb.append("StartTime: ").append(this.getStartTime()).append(",");
        }
        if (this.getTargetResolution() != null) {
            sb.append("TargetResolution: ").append(this.getTargetResolution());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchGetFrameMetricDataRequest)) {
            return false;
        }
        BatchGetFrameMetricDataRequest other = (BatchGetFrameMetricDataRequest)obj;
        if (other.getEndTime() == null ^ this.getEndTime() == null) {
            return false;
        }
        if (other.getEndTime() != null && !other.getEndTime().equals(this.getEndTime())) {
            return false;
        }
        if (other.getFrameMetrics() == null ^ this.getFrameMetrics() == null) {
            return false;
        }
        if (other.getFrameMetrics() != null && !other.getFrameMetrics().equals(this.getFrameMetrics())) {
            return false;
        }
        if (other.getPeriod() == null ^ this.getPeriod() == null) {
            return false;
        }
        if (other.getPeriod() != null && !other.getPeriod().equals(this.getPeriod())) {
            return false;
        }
        if (other.getProfilingGroupName() == null ^ this.getProfilingGroupName() == null) {
            return false;
        }
        if (other.getProfilingGroupName() != null && !other.getProfilingGroupName().equals(this.getProfilingGroupName())) {
            return false;
        }
        if (other.getStartTime() == null ^ this.getStartTime() == null) {
            return false;
        }
        if (other.getStartTime() != null && !other.getStartTime().equals(this.getStartTime())) {
            return false;
        }
        if (other.getTargetResolution() == null ^ this.getTargetResolution() == null) {
            return false;
        }
        return other.getTargetResolution() == null || other.getTargetResolution().equals(this.getTargetResolution());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getEndTime() == null ? 0 : this.getEndTime().hashCode());
        hashCode = 31 * hashCode + (this.getFrameMetrics() == null ? 0 : this.getFrameMetrics().hashCode());
        hashCode = 31 * hashCode + (this.getPeriod() == null ? 0 : this.getPeriod().hashCode());
        hashCode = 31 * hashCode + (this.getProfilingGroupName() == null ? 0 : this.getProfilingGroupName().hashCode());
        hashCode = 31 * hashCode + (this.getStartTime() == null ? 0 : this.getStartTime().hashCode());
        hashCode = 31 * hashCode + (this.getTargetResolution() == null ? 0 : this.getTargetResolution().hashCode());
        return hashCode;
    }

    public BatchGetFrameMetricDataRequest clone() {
        return (BatchGetFrameMetricDataRequest)super.clone();
    }
}

