/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.codeguruprofiler.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.codeguruprofiler.model.Metric;
import java.util.List;

@SdkInternalApi
public class MetricMarshaller {
    private static final MarshallingInfo<String> FRAMENAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("frameName").build();
    private static final MarshallingInfo<List> THREADSTATES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("threadStates").build();
    private static final MarshallingInfo<String> TYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("type").build();
    private static final MetricMarshaller instance = new MetricMarshaller();

    public static MetricMarshaller getInstance() {
        return instance;
    }

    public void marshall(Metric metric, ProtocolMarshaller protocolMarshaller) {
        if (metric == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)metric.getFrameName(), FRAMENAME_BINDING);
            protocolMarshaller.marshall(metric.getThreadStates(), THREADSTATES_BINDING);
            protocolMarshaller.marshall((Object)metric.getType(), TYPE_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

