/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.codecommit.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.codecommit.model.SymbolicLink;

@SdkInternalApi
public class SymbolicLinkMarshaller {
    private static final MarshallingInfo<String> BLOBID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("blobId").build();
    private static final MarshallingInfo<String> ABSOLUTEPATH_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("absolutePath").build();
    private static final MarshallingInfo<String> RELATIVEPATH_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("relativePath").build();
    private static final MarshallingInfo<String> FILEMODE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("fileMode").build();
    private static final SymbolicLinkMarshaller instance = new SymbolicLinkMarshaller();

    public static SymbolicLinkMarshaller getInstance() {
        return instance;
    }

    public void marshall(SymbolicLink symbolicLink, ProtocolMarshaller protocolMarshaller) {
        if (symbolicLink == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)symbolicLink.getBlobId(), BLOBID_BINDING);
            protocolMarshaller.marshall((Object)symbolicLink.getAbsolutePath(), ABSOLUTEPATH_BINDING);
            protocolMarshaller.marshall((Object)symbolicLink.getRelativePath(), RELATIVEPATH_BINDING);
            protocolMarshaller.marshall((Object)symbolicLink.getFileMode(), FILEMODE_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

