/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.codecommit.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.codecommit.model.FileModeTypeEnum;
import com.amazonaws.services.codecommit.model.ReplacementTypeEnum;
import com.amazonaws.services.codecommit.model.transform.ReplaceContentEntryMarshaller;
import java.io.Serializable;
import java.nio.ByteBuffer;

public class ReplaceContentEntry
implements Serializable,
Cloneable,
StructuredPojo {
    private String filePath;
    private String replacementType;
    private ByteBuffer content;
    private String fileMode;

    public void setFilePath(String filePath) {
        this.filePath = filePath;
    }

    public String getFilePath() {
        return this.filePath;
    }

    public ReplaceContentEntry withFilePath(String filePath) {
        this.setFilePath(filePath);
        return this;
    }

    public void setReplacementType(String replacementType) {
        this.replacementType = replacementType;
    }

    public String getReplacementType() {
        return this.replacementType;
    }

    public ReplaceContentEntry withReplacementType(String replacementType) {
        this.setReplacementType(replacementType);
        return this;
    }

    public ReplaceContentEntry withReplacementType(ReplacementTypeEnum replacementType) {
        this.replacementType = replacementType.toString();
        return this;
    }

    public void setContent(ByteBuffer content) {
        this.content = content;
    }

    public ByteBuffer getContent() {
        return this.content;
    }

    public ReplaceContentEntry withContent(ByteBuffer content) {
        this.setContent(content);
        return this;
    }

    public void setFileMode(String fileMode) {
        this.fileMode = fileMode;
    }

    public String getFileMode() {
        return this.fileMode;
    }

    public ReplaceContentEntry withFileMode(String fileMode) {
        this.setFileMode(fileMode);
        return this;
    }

    public ReplaceContentEntry withFileMode(FileModeTypeEnum fileMode) {
        this.fileMode = fileMode.toString();
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getFilePath() != null) {
            sb.append("FilePath: ").append(this.getFilePath()).append(",");
        }
        if (this.getReplacementType() != null) {
            sb.append("ReplacementType: ").append(this.getReplacementType()).append(",");
        }
        if (this.getContent() != null) {
            sb.append("Content: ").append(this.getContent()).append(",");
        }
        if (this.getFileMode() != null) {
            sb.append("FileMode: ").append(this.getFileMode());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ReplaceContentEntry)) {
            return false;
        }
        ReplaceContentEntry other = (ReplaceContentEntry)obj;
        if (other.getFilePath() == null ^ this.getFilePath() == null) {
            return false;
        }
        if (other.getFilePath() != null && !other.getFilePath().equals(this.getFilePath())) {
            return false;
        }
        if (other.getReplacementType() == null ^ this.getReplacementType() == null) {
            return false;
        }
        if (other.getReplacementType() != null && !other.getReplacementType().equals(this.getReplacementType())) {
            return false;
        }
        if (other.getContent() == null ^ this.getContent() == null) {
            return false;
        }
        if (other.getContent() != null && !other.getContent().equals(this.getContent())) {
            return false;
        }
        if (other.getFileMode() == null ^ this.getFileMode() == null) {
            return false;
        }
        return other.getFileMode() == null || other.getFileMode().equals(this.getFileMode());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getFilePath() == null ? 0 : this.getFilePath().hashCode());
        hashCode = 31 * hashCode + (this.getReplacementType() == null ? 0 : this.getReplacementType().hashCode());
        hashCode = 31 * hashCode + (this.getContent() == null ? 0 : this.getContent().hashCode());
        hashCode = 31 * hashCode + (this.getFileMode() == null ? 0 : this.getFileMode().hashCode());
        return hashCode;
    }

    public ReplaceContentEntry clone() {
        try {
            return (ReplaceContentEntry)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ReplaceContentEntryMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

