/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.codebuild.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.codebuild.model.ReportPackagingType;
import com.amazonaws.services.codebuild.model.transform.S3ReportExportConfigMarshaller;
import java.io.Serializable;

public class S3ReportExportConfig
implements Serializable,
Cloneable,
StructuredPojo {
    private String bucket;
    private String path;
    private String packaging;
    private String encryptionKey;
    private Boolean encryptionDisabled;

    public void setBucket(String bucket) {
        this.bucket = bucket;
    }

    public String getBucket() {
        return this.bucket;
    }

    public S3ReportExportConfig withBucket(String bucket) {
        this.setBucket(bucket);
        return this;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public String getPath() {
        return this.path;
    }

    public S3ReportExportConfig withPath(String path) {
        this.setPath(path);
        return this;
    }

    public void setPackaging(String packaging) {
        this.packaging = packaging;
    }

    public String getPackaging() {
        return this.packaging;
    }

    public S3ReportExportConfig withPackaging(String packaging) {
        this.setPackaging(packaging);
        return this;
    }

    public S3ReportExportConfig withPackaging(ReportPackagingType packaging) {
        this.packaging = packaging.toString();
        return this;
    }

    public void setEncryptionKey(String encryptionKey) {
        this.encryptionKey = encryptionKey;
    }

    public String getEncryptionKey() {
        return this.encryptionKey;
    }

    public S3ReportExportConfig withEncryptionKey(String encryptionKey) {
        this.setEncryptionKey(encryptionKey);
        return this;
    }

    public void setEncryptionDisabled(Boolean encryptionDisabled) {
        this.encryptionDisabled = encryptionDisabled;
    }

    public Boolean getEncryptionDisabled() {
        return this.encryptionDisabled;
    }

    public S3ReportExportConfig withEncryptionDisabled(Boolean encryptionDisabled) {
        this.setEncryptionDisabled(encryptionDisabled);
        return this;
    }

    public Boolean isEncryptionDisabled() {
        return this.encryptionDisabled;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getBucket() != null) {
            sb.append("Bucket: ").append(this.getBucket()).append(",");
        }
        if (this.getPath() != null) {
            sb.append("Path: ").append(this.getPath()).append(",");
        }
        if (this.getPackaging() != null) {
            sb.append("Packaging: ").append(this.getPackaging()).append(",");
        }
        if (this.getEncryptionKey() != null) {
            sb.append("EncryptionKey: ").append(this.getEncryptionKey()).append(",");
        }
        if (this.getEncryptionDisabled() != null) {
            sb.append("EncryptionDisabled: ").append(this.getEncryptionDisabled());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof S3ReportExportConfig)) {
            return false;
        }
        S3ReportExportConfig other = (S3ReportExportConfig)obj;
        if (other.getBucket() == null ^ this.getBucket() == null) {
            return false;
        }
        if (other.getBucket() != null && !other.getBucket().equals(this.getBucket())) {
            return false;
        }
        if (other.getPath() == null ^ this.getPath() == null) {
            return false;
        }
        if (other.getPath() != null && !other.getPath().equals(this.getPath())) {
            return false;
        }
        if (other.getPackaging() == null ^ this.getPackaging() == null) {
            return false;
        }
        if (other.getPackaging() != null && !other.getPackaging().equals(this.getPackaging())) {
            return false;
        }
        if (other.getEncryptionKey() == null ^ this.getEncryptionKey() == null) {
            return false;
        }
        if (other.getEncryptionKey() != null && !other.getEncryptionKey().equals(this.getEncryptionKey())) {
            return false;
        }
        if (other.getEncryptionDisabled() == null ^ this.getEncryptionDisabled() == null) {
            return false;
        }
        return other.getEncryptionDisabled() == null || other.getEncryptionDisabled().equals(this.getEncryptionDisabled());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getBucket() == null ? 0 : this.getBucket().hashCode());
        hashCode = 31 * hashCode + (this.getPath() == null ? 0 : this.getPath().hashCode());
        hashCode = 31 * hashCode + (this.getPackaging() == null ? 0 : this.getPackaging().hashCode());
        hashCode = 31 * hashCode + (this.getEncryptionKey() == null ? 0 : this.getEncryptionKey().hashCode());
        hashCode = 31 * hashCode + (this.getEncryptionDisabled() == null ? 0 : this.getEncryptionDisabled().hashCode());
        return hashCode;
    }

    public S3ReportExportConfig clone() {
        try {
            return (S3ReportExportConfig)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        S3ReportExportConfigMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

