/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cloudwatchevidently.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.cloudwatchevidently.model.ProjectDataDelivery;

@SdkInternalApi
public class ProjectDataDeliveryMarshaller {
    private static final MarshallingInfo<StructuredPojo> CLOUDWATCHLOGS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("cloudWatchLogs").build();
    private static final MarshallingInfo<StructuredPojo> S3DESTINATION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("s3Destination").build();
    private static final ProjectDataDeliveryMarshaller instance = new ProjectDataDeliveryMarshaller();

    public static ProjectDataDeliveryMarshaller getInstance() {
        return instance;
    }

    public void marshall(ProjectDataDelivery projectDataDelivery, ProtocolMarshaller protocolMarshaller) {
        if (projectDataDelivery == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)projectDataDelivery.getCloudWatchLogs(), CLOUDWATCHLOGS_BINDING);
            protocolMarshaller.marshall((Object)projectDataDelivery.getS3Destination(), S3DESTINATION_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

