/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cloudwatchevidently.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.cloudwatchevidently.model.LaunchGroup;
import java.util.Map;

@SdkInternalApi
public class LaunchGroupMarshaller {
    private static final MarshallingInfo<String> DESCRIPTION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("description").build();
    private static final MarshallingInfo<Map> FEATUREVARIATIONS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.MAP).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("featureVariations").build();
    private static final MarshallingInfo<String> NAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("name").build();
    private static final LaunchGroupMarshaller instance = new LaunchGroupMarshaller();

    public static LaunchGroupMarshaller getInstance() {
        return instance;
    }

    public void marshall(LaunchGroup launchGroup, ProtocolMarshaller protocolMarshaller) {
        if (launchGroup == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)launchGroup.getDescription(), DESCRIPTION_BINDING);
            protocolMarshaller.marshall(launchGroup.getFeatureVariations(), FEATUREVARIATIONS_BINDING);
            protocolMarshaller.marshall((Object)launchGroup.getName(), NAME_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

