/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cloudwatch.model.transform;

import com.amazonaws.services.cloudwatch.model.MessageData;
import com.amazonaws.services.cloudwatch.model.MetricDataResult;
import com.amazonaws.services.cloudwatch.model.transform.MessageDataStaxUnmarshaller;
import com.amazonaws.transform.SimpleTypeStaxUnmarshallers;
import com.amazonaws.transform.StaxUnmarshallerContext;
import com.amazonaws.transform.Unmarshaller;
import java.util.ArrayList;
import java.util.Date;
import javax.xml.stream.events.XMLEvent;

public class MetricDataResultStaxUnmarshaller
implements Unmarshaller<MetricDataResult, StaxUnmarshallerContext> {
    private static MetricDataResultStaxUnmarshaller instance;

    public MetricDataResult unmarshall(StaxUnmarshallerContext context) throws Exception {
        MetricDataResult metricDataResult = new MetricDataResult();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (true) {
            XMLEvent xmlEvent;
            if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                return metricDataResult;
            }
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("Id", targetDepth)) {
                    metricDataResult.setId(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("Label", targetDepth)) {
                    metricDataResult.setLabel(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("Timestamps", targetDepth)) {
                    metricDataResult.withTimestamps(new ArrayList<Date>());
                    continue;
                }
                if (context.testExpression("Timestamps/member", targetDepth)) {
                    metricDataResult.withTimestamps(SimpleTypeStaxUnmarshallers.DateStaxUnmarshallerFactory.getInstance((String)"iso8601").unmarshall(context));
                    continue;
                }
                if (context.testExpression("Values", targetDepth)) {
                    metricDataResult.withValues(new ArrayList<Double>());
                    continue;
                }
                if (context.testExpression("Values/member", targetDepth)) {
                    metricDataResult.withValues(SimpleTypeStaxUnmarshallers.DoubleStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("StatusCode", targetDepth)) {
                    metricDataResult.setStatusCode(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("Messages", targetDepth)) {
                    metricDataResult.withMessages(new ArrayList<MessageData>());
                    continue;
                }
                if (!context.testExpression("Messages/member", targetDepth)) continue;
                metricDataResult.withMessages(MessageDataStaxUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
        }
        return metricDataResult;
    }

    public static MetricDataResultStaxUnmarshaller getInstance() {
        if (instance == null) {
            instance = new MetricDataResultStaxUnmarshaller();
        }
        return instance;
    }
}

