/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cloudwatch.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.cloudwatch.model.Dimension;
import com.amazonaws.services.cloudwatch.model.StandardUnit;
import com.amazonaws.services.cloudwatch.model.Statistic;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.Serializable;
import java.util.Collection;
import java.util.Date;
import java.util.List;

public class GetMetricStatisticsRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String namespace;
    private String metricName;
    private SdkInternalList<Dimension> dimensions;
    private Date startTime;
    private Date endTime;
    private Integer period;
    private SdkInternalList<String> statistics;
    private SdkInternalList<String> extendedStatistics;
    private String unit;

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public GetMetricStatisticsRequest withNamespace(String namespace) {
        this.setNamespace(namespace);
        return this;
    }

    public void setMetricName(String metricName) {
        this.metricName = metricName;
    }

    public String getMetricName() {
        return this.metricName;
    }

    public GetMetricStatisticsRequest withMetricName(String metricName) {
        this.setMetricName(metricName);
        return this;
    }

    public List<Dimension> getDimensions() {
        if (this.dimensions == null) {
            this.dimensions = new SdkInternalList();
        }
        return this.dimensions;
    }

    public void setDimensions(Collection<Dimension> dimensions) {
        if (dimensions == null) {
            this.dimensions = null;
            return;
        }
        this.dimensions = new SdkInternalList(dimensions);
    }

    public GetMetricStatisticsRequest withDimensions(Dimension ... dimensions) {
        if (this.dimensions == null) {
            this.setDimensions((Collection<Dimension>)new SdkInternalList(dimensions.length));
        }
        for (Dimension ele : dimensions) {
            this.dimensions.add((Object)ele);
        }
        return this;
    }

    public GetMetricStatisticsRequest withDimensions(Collection<Dimension> dimensions) {
        this.setDimensions(dimensions);
        return this;
    }

    public void setStartTime(Date startTime) {
        this.startTime = startTime;
    }

    public Date getStartTime() {
        return this.startTime;
    }

    public GetMetricStatisticsRequest withStartTime(Date startTime) {
        this.setStartTime(startTime);
        return this;
    }

    public void setEndTime(Date endTime) {
        this.endTime = endTime;
    }

    public Date getEndTime() {
        return this.endTime;
    }

    public GetMetricStatisticsRequest withEndTime(Date endTime) {
        this.setEndTime(endTime);
        return this;
    }

    public void setPeriod(Integer period) {
        this.period = period;
    }

    public Integer getPeriod() {
        return this.period;
    }

    public GetMetricStatisticsRequest withPeriod(Integer period) {
        this.setPeriod(period);
        return this;
    }

    public List<String> getStatistics() {
        if (this.statistics == null) {
            this.statistics = new SdkInternalList();
        }
        return this.statistics;
    }

    public void setStatistics(Collection<String> statistics) {
        if (statistics == null) {
            this.statistics = null;
            return;
        }
        this.statistics = new SdkInternalList(statistics);
    }

    public GetMetricStatisticsRequest withStatistics(String ... statistics) {
        if (this.statistics == null) {
            this.setStatistics((Collection<String>)new SdkInternalList(statistics.length));
        }
        for (String ele : statistics) {
            this.statistics.add((Object)ele);
        }
        return this;
    }

    public GetMetricStatisticsRequest withStatistics(Collection<String> statistics) {
        this.setStatistics(statistics);
        return this;
    }

    public GetMetricStatisticsRequest withStatistics(Statistic ... statistics) {
        SdkInternalList statisticsCopy = new SdkInternalList(statistics.length);
        for (Statistic value : statistics) {
            statisticsCopy.add((Object)value.toString());
        }
        if (this.getStatistics() == null) {
            this.setStatistics((Collection<String>)statisticsCopy);
        } else {
            this.getStatistics().addAll((Collection<String>)statisticsCopy);
        }
        return this;
    }

    public List<String> getExtendedStatistics() {
        if (this.extendedStatistics == null) {
            this.extendedStatistics = new SdkInternalList();
        }
        return this.extendedStatistics;
    }

    public void setExtendedStatistics(Collection<String> extendedStatistics) {
        if (extendedStatistics == null) {
            this.extendedStatistics = null;
            return;
        }
        this.extendedStatistics = new SdkInternalList(extendedStatistics);
    }

    public GetMetricStatisticsRequest withExtendedStatistics(String ... extendedStatistics) {
        if (this.extendedStatistics == null) {
            this.setExtendedStatistics((Collection<String>)new SdkInternalList(extendedStatistics.length));
        }
        for (String ele : extendedStatistics) {
            this.extendedStatistics.add((Object)ele);
        }
        return this;
    }

    public GetMetricStatisticsRequest withExtendedStatistics(Collection<String> extendedStatistics) {
        this.setExtendedStatistics(extendedStatistics);
        return this;
    }

    public void setUnit(String unit) {
        this.unit = unit;
    }

    @JsonProperty(value="unit")
    public String getUnit() {
        return this.unit;
    }

    public GetMetricStatisticsRequest withUnit(String unit) {
        this.setUnit(unit);
        return this;
    }

    @JsonIgnore
    public void setUnit(StandardUnit unit) {
        this.withUnit(unit);
    }

    public GetMetricStatisticsRequest withUnit(StandardUnit unit) {
        this.unit = unit.toString();
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getNamespace() != null) {
            sb.append("Namespace: ").append(this.getNamespace()).append(",");
        }
        if (this.getMetricName() != null) {
            sb.append("MetricName: ").append(this.getMetricName()).append(",");
        }
        if (this.getDimensions() != null) {
            sb.append("Dimensions: ").append(this.getDimensions()).append(",");
        }
        if (this.getStartTime() != null) {
            sb.append("StartTime: ").append(this.getStartTime()).append(",");
        }
        if (this.getEndTime() != null) {
            sb.append("EndTime: ").append(this.getEndTime()).append(",");
        }
        if (this.getPeriod() != null) {
            sb.append("Period: ").append(this.getPeriod()).append(",");
        }
        if (this.getStatistics() != null) {
            sb.append("Statistics: ").append(this.getStatistics()).append(",");
        }
        if (this.getExtendedStatistics() != null) {
            sb.append("ExtendedStatistics: ").append(this.getExtendedStatistics()).append(",");
        }
        if (this.getUnit() != null) {
            sb.append("Unit: ").append(this.getUnit());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetMetricStatisticsRequest)) {
            return false;
        }
        GetMetricStatisticsRequest other = (GetMetricStatisticsRequest)obj;
        if (other.getNamespace() == null ^ this.getNamespace() == null) {
            return false;
        }
        if (other.getNamespace() != null && !other.getNamespace().equals(this.getNamespace())) {
            return false;
        }
        if (other.getMetricName() == null ^ this.getMetricName() == null) {
            return false;
        }
        if (other.getMetricName() != null && !other.getMetricName().equals(this.getMetricName())) {
            return false;
        }
        if (other.getDimensions() == null ^ this.getDimensions() == null) {
            return false;
        }
        if (other.getDimensions() != null && !other.getDimensions().equals(this.getDimensions())) {
            return false;
        }
        if (other.getStartTime() == null ^ this.getStartTime() == null) {
            return false;
        }
        if (other.getStartTime() != null && !other.getStartTime().equals(this.getStartTime())) {
            return false;
        }
        if (other.getEndTime() == null ^ this.getEndTime() == null) {
            return false;
        }
        if (other.getEndTime() != null && !other.getEndTime().equals(this.getEndTime())) {
            return false;
        }
        if (other.getPeriod() == null ^ this.getPeriod() == null) {
            return false;
        }
        if (other.getPeriod() != null && !other.getPeriod().equals(this.getPeriod())) {
            return false;
        }
        if (other.getStatistics() == null ^ this.getStatistics() == null) {
            return false;
        }
        if (other.getStatistics() != null && !other.getStatistics().equals(this.getStatistics())) {
            return false;
        }
        if (other.getExtendedStatistics() == null ^ this.getExtendedStatistics() == null) {
            return false;
        }
        if (other.getExtendedStatistics() != null && !other.getExtendedStatistics().equals(this.getExtendedStatistics())) {
            return false;
        }
        if (other.getUnit() == null ^ this.getUnit() == null) {
            return false;
        }
        return other.getUnit() == null || other.getUnit().equals(this.getUnit());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getNamespace() == null ? 0 : this.getNamespace().hashCode());
        hashCode = 31 * hashCode + (this.getMetricName() == null ? 0 : this.getMetricName().hashCode());
        hashCode = 31 * hashCode + (this.getDimensions() == null ? 0 : this.getDimensions().hashCode());
        hashCode = 31 * hashCode + (this.getStartTime() == null ? 0 : this.getStartTime().hashCode());
        hashCode = 31 * hashCode + (this.getEndTime() == null ? 0 : this.getEndTime().hashCode());
        hashCode = 31 * hashCode + (this.getPeriod() == null ? 0 : this.getPeriod().hashCode());
        hashCode = 31 * hashCode + (this.getStatistics() == null ? 0 : this.getStatistics().hashCode());
        hashCode = 31 * hashCode + (this.getExtendedStatistics() == null ? 0 : this.getExtendedStatistics().hashCode());
        hashCode = 31 * hashCode + (this.getUnit() == null ? 0 : this.getUnit().hashCode());
        return hashCode;
    }

    public GetMetricStatisticsRequest clone() {
        return (GetMetricStatisticsRequest)super.clone();
    }
}

