/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cloudwatch.model;

import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.cloudwatch.model.Metric;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;

public class ListMetricsResult
implements Serializable,
Cloneable {
    private SdkInternalList<Metric> metrics;
    private String nextToken;

    public List<Metric> getMetrics() {
        if (this.metrics == null) {
            this.metrics = new SdkInternalList();
        }
        return this.metrics;
    }

    public void setMetrics(Collection<Metric> metrics) {
        if (metrics == null) {
            this.metrics = null;
            return;
        }
        this.metrics = new SdkInternalList(metrics);
    }

    public ListMetricsResult withMetrics(Metric ... metrics) {
        if (this.metrics == null) {
            this.setMetrics((Collection<Metric>)new SdkInternalList(metrics.length));
        }
        for (Metric ele : metrics) {
            this.metrics.add((Object)ele);
        }
        return this;
    }

    public ListMetricsResult withMetrics(Collection<Metric> metrics) {
        this.setMetrics(metrics);
        return this;
    }

    public void setNextToken(String nextToken) {
        this.nextToken = nextToken;
    }

    public String getNextToken() {
        return this.nextToken;
    }

    public ListMetricsResult withNextToken(String nextToken) {
        this.setNextToken(nextToken);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getMetrics() != null) {
            sb.append("Metrics: " + this.getMetrics() + ",");
        }
        if (this.getNextToken() != null) {
            sb.append("NextToken: " + this.getNextToken());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListMetricsResult)) {
            return false;
        }
        ListMetricsResult other = (ListMetricsResult)obj;
        if (other.getMetrics() == null ^ this.getMetrics() == null) {
            return false;
        }
        if (other.getMetrics() != null && !other.getMetrics().equals(this.getMetrics())) {
            return false;
        }
        if (other.getNextToken() == null ^ this.getNextToken() == null) {
            return false;
        }
        return other.getNextToken() == null || other.getNextToken().equals(this.getNextToken());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getMetrics() == null ? 0 : this.getMetrics().hashCode());
        hashCode = 31 * hashCode + (this.getNextToken() == null ? 0 : this.getNextToken().hashCode());
        return hashCode;
    }

    public ListMetricsResult clone() {
        try {
            return (ListMetricsResult)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

