/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cloudtrail.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.cloudtrail.model.Destination;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;

public class UpdateChannelRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String channel;
    private SdkInternalList<Destination> destinations;
    private String name;

    public void setChannel(String channel) {
        this.channel = channel;
    }

    public String getChannel() {
        return this.channel;
    }

    public UpdateChannelRequest withChannel(String channel) {
        this.setChannel(channel);
        return this;
    }

    public List<Destination> getDestinations() {
        if (this.destinations == null) {
            this.destinations = new SdkInternalList();
        }
        return this.destinations;
    }

    public void setDestinations(Collection<Destination> destinations) {
        if (destinations == null) {
            this.destinations = null;
            return;
        }
        this.destinations = new SdkInternalList(destinations);
    }

    public UpdateChannelRequest withDestinations(Destination ... destinations) {
        if (this.destinations == null) {
            this.setDestinations((Collection<Destination>)new SdkInternalList(destinations.length));
        }
        for (Destination ele : destinations) {
            this.destinations.add((Object)ele);
        }
        return this;
    }

    public UpdateChannelRequest withDestinations(Collection<Destination> destinations) {
        this.setDestinations(destinations);
        return this;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public UpdateChannelRequest withName(String name) {
        this.setName(name);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getChannel() != null) {
            sb.append("Channel: ").append(this.getChannel()).append(",");
        }
        if (this.getDestinations() != null) {
            sb.append("Destinations: ").append(this.getDestinations()).append(",");
        }
        if (this.getName() != null) {
            sb.append("Name: ").append(this.getName());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateChannelRequest)) {
            return false;
        }
        UpdateChannelRequest other = (UpdateChannelRequest)obj;
        if (other.getChannel() == null ^ this.getChannel() == null) {
            return false;
        }
        if (other.getChannel() != null && !other.getChannel().equals(this.getChannel())) {
            return false;
        }
        if (other.getDestinations() == null ^ this.getDestinations() == null) {
            return false;
        }
        if (other.getDestinations() != null && !other.getDestinations().equals(this.getDestinations())) {
            return false;
        }
        if (other.getName() == null ^ this.getName() == null) {
            return false;
        }
        return other.getName() == null || other.getName().equals(this.getName());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getChannel() == null ? 0 : this.getChannel().hashCode());
        hashCode = 31 * hashCode + (this.getDestinations() == null ? 0 : this.getDestinations().hashCode());
        hashCode = 31 * hashCode + (this.getName() == null ? 0 : this.getName().hashCode());
        return hashCode;
    }

    public UpdateChannelRequest clone() {
        return (UpdateChannelRequest)super.clone();
    }
}

