/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cloudtrail.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.cloudtrail.model.AdvancedEventSelector;
import com.amazonaws.services.cloudtrail.model.EventSelector;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;

public class PutEventSelectorsRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String trailName;
    private SdkInternalList<EventSelector> eventSelectors;
    private SdkInternalList<AdvancedEventSelector> advancedEventSelectors;

    public void setTrailName(String trailName) {
        this.trailName = trailName;
    }

    public String getTrailName() {
        return this.trailName;
    }

    public PutEventSelectorsRequest withTrailName(String trailName) {
        this.setTrailName(trailName);
        return this;
    }

    public List<EventSelector> getEventSelectors() {
        if (this.eventSelectors == null) {
            this.eventSelectors = new SdkInternalList();
        }
        return this.eventSelectors;
    }

    public void setEventSelectors(Collection<EventSelector> eventSelectors) {
        if (eventSelectors == null) {
            this.eventSelectors = null;
            return;
        }
        this.eventSelectors = new SdkInternalList(eventSelectors);
    }

    public PutEventSelectorsRequest withEventSelectors(EventSelector ... eventSelectors) {
        if (this.eventSelectors == null) {
            this.setEventSelectors((Collection<EventSelector>)new SdkInternalList(eventSelectors.length));
        }
        for (EventSelector ele : eventSelectors) {
            this.eventSelectors.add((Object)ele);
        }
        return this;
    }

    public PutEventSelectorsRequest withEventSelectors(Collection<EventSelector> eventSelectors) {
        this.setEventSelectors(eventSelectors);
        return this;
    }

    public List<AdvancedEventSelector> getAdvancedEventSelectors() {
        if (this.advancedEventSelectors == null) {
            this.advancedEventSelectors = new SdkInternalList();
        }
        return this.advancedEventSelectors;
    }

    public void setAdvancedEventSelectors(Collection<AdvancedEventSelector> advancedEventSelectors) {
        if (advancedEventSelectors == null) {
            this.advancedEventSelectors = null;
            return;
        }
        this.advancedEventSelectors = new SdkInternalList(advancedEventSelectors);
    }

    public PutEventSelectorsRequest withAdvancedEventSelectors(AdvancedEventSelector ... advancedEventSelectors) {
        if (this.advancedEventSelectors == null) {
            this.setAdvancedEventSelectors((Collection<AdvancedEventSelector>)new SdkInternalList(advancedEventSelectors.length));
        }
        for (AdvancedEventSelector ele : advancedEventSelectors) {
            this.advancedEventSelectors.add((Object)ele);
        }
        return this;
    }

    public PutEventSelectorsRequest withAdvancedEventSelectors(Collection<AdvancedEventSelector> advancedEventSelectors) {
        this.setAdvancedEventSelectors(advancedEventSelectors);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getTrailName() != null) {
            sb.append("TrailName: ").append(this.getTrailName()).append(",");
        }
        if (this.getEventSelectors() != null) {
            sb.append("EventSelectors: ").append(this.getEventSelectors()).append(",");
        }
        if (this.getAdvancedEventSelectors() != null) {
            sb.append("AdvancedEventSelectors: ").append(this.getAdvancedEventSelectors());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutEventSelectorsRequest)) {
            return false;
        }
        PutEventSelectorsRequest other = (PutEventSelectorsRequest)obj;
        if (other.getTrailName() == null ^ this.getTrailName() == null) {
            return false;
        }
        if (other.getTrailName() != null && !other.getTrailName().equals(this.getTrailName())) {
            return false;
        }
        if (other.getEventSelectors() == null ^ this.getEventSelectors() == null) {
            return false;
        }
        if (other.getEventSelectors() != null && !other.getEventSelectors().equals(this.getEventSelectors())) {
            return false;
        }
        if (other.getAdvancedEventSelectors() == null ^ this.getAdvancedEventSelectors() == null) {
            return false;
        }
        return other.getAdvancedEventSelectors() == null || other.getAdvancedEventSelectors().equals(this.getAdvancedEventSelectors());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getTrailName() == null ? 0 : this.getTrailName().hashCode());
        hashCode = 31 * hashCode + (this.getEventSelectors() == null ? 0 : this.getEventSelectors().hashCode());
        hashCode = 31 * hashCode + (this.getAdvancedEventSelectors() == null ? 0 : this.getAdvancedEventSelectors().hashCode());
        return hashCode;
    }

    public PutEventSelectorsRequest clone() {
        return (PutEventSelectorsRequest)super.clone();
    }
}

