/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cloudtrail.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.internal.SdkInternalList;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;

public class ListTagsRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private SdkInternalList<String> resourceIdList;
    private String nextToken;

    public List<String> getResourceIdList() {
        if (this.resourceIdList == null) {
            this.resourceIdList = new SdkInternalList();
        }
        return this.resourceIdList;
    }

    public void setResourceIdList(Collection<String> resourceIdList) {
        if (resourceIdList == null) {
            this.resourceIdList = null;
            return;
        }
        this.resourceIdList = new SdkInternalList(resourceIdList);
    }

    public ListTagsRequest withResourceIdList(String ... resourceIdList) {
        if (this.resourceIdList == null) {
            this.setResourceIdList((Collection<String>)new SdkInternalList(resourceIdList.length));
        }
        for (String ele : resourceIdList) {
            this.resourceIdList.add((Object)ele);
        }
        return this;
    }

    public ListTagsRequest withResourceIdList(Collection<String> resourceIdList) {
        this.setResourceIdList(resourceIdList);
        return this;
    }

    public void setNextToken(String nextToken) {
        this.nextToken = nextToken;
    }

    public String getNextToken() {
        return this.nextToken;
    }

    public ListTagsRequest withNextToken(String nextToken) {
        this.setNextToken(nextToken);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getResourceIdList() != null) {
            sb.append("ResourceIdList: ").append(this.getResourceIdList()).append(",");
        }
        if (this.getNextToken() != null) {
            sb.append("NextToken: ").append(this.getNextToken());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListTagsRequest)) {
            return false;
        }
        ListTagsRequest other = (ListTagsRequest)obj;
        if (other.getResourceIdList() == null ^ this.getResourceIdList() == null) {
            return false;
        }
        if (other.getResourceIdList() != null && !other.getResourceIdList().equals(this.getResourceIdList())) {
            return false;
        }
        if (other.getNextToken() == null ^ this.getNextToken() == null) {
            return false;
        }
        return other.getNextToken() == null || other.getNextToken().equals(this.getNextToken());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getResourceIdList() == null ? 0 : this.getResourceIdList().hashCode());
        hashCode = 31 * hashCode + (this.getNextToken() == null ? 0 : this.getNextToken().hashCode());
        return hashCode;
    }

    public ListTagsRequest clone() {
        return (ListTagsRequest)super.clone();
    }
}

