/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cloudtrail.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.cloudtrail.model.DescribeTrailsRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringInputStream;
import com.amazonaws.util.StringUtils;
import com.amazonaws.util.json.JSONWriter;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;

public class DescribeTrailsRequestMarshaller
implements Marshaller<Request<DescribeTrailsRequest>, DescribeTrailsRequest> {
    public Request<DescribeTrailsRequest> marshall(DescribeTrailsRequest describeTrailsRequest) {
        if (describeTrailsRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)describeTrailsRequest, "AWSCloudTrail");
        request.addHeader("X-Amz-Target", "com.amazonaws.cloudtrail.v20131101.CloudTrail_20131101.DescribeTrails");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            StringWriter stringWriter = new StringWriter();
            JSONWriter jsonWriter = new JSONWriter((Writer)stringWriter);
            jsonWriter.object();
            SdkInternalList trailNameListList = (SdkInternalList)describeTrailsRequest.getTrailNameList();
            if (!trailNameListList.isEmpty() || !trailNameListList.isAutoConstruct()) {
                jsonWriter.key("trailNameList");
                jsonWriter.array();
                for (String trailNameListListValue : trailNameListList) {
                    if (trailNameListListValue == null) continue;
                    jsonWriter.value((Object)trailNameListListValue);
                }
                jsonWriter.endArray();
            }
            if (describeTrailsRequest.getIncludeShadowTrails() != null) {
                jsonWriter.key("includeShadowTrails").value((Object)describeTrailsRequest.getIncludeShadowTrails());
            }
            jsonWriter.endObject();
            String snippet = stringWriter.toString();
            byte[] content = snippet.getBytes(StringUtils.UTF8);
            request.setContent((InputStream)new StringInputStream(snippet));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", "application/x-amz-json-1.1");
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

