/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cloudsearchv2.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.cloudsearchv2.model.DomainEndpointOptions;
import com.amazonaws.services.cloudsearchv2.model.UpdateDomainEndpointOptionsRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class UpdateDomainEndpointOptionsRequestMarshaller
implements Marshaller<Request<UpdateDomainEndpointOptionsRequest>, UpdateDomainEndpointOptionsRequest> {
    public Request<UpdateDomainEndpointOptionsRequest> marshall(UpdateDomainEndpointOptionsRequest updateDomainEndpointOptionsRequest) {
        DomainEndpointOptions domainEndpointOptions;
        if (updateDomainEndpointOptionsRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)updateDomainEndpointOptionsRequest, "AmazonCloudSearchv2");
        request.addParameter("Action", "UpdateDomainEndpointOptions");
        request.addParameter("Version", "2013-01-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (updateDomainEndpointOptionsRequest.getDomainName() != null) {
            request.addParameter("DomainName", StringUtils.fromString((String)updateDomainEndpointOptionsRequest.getDomainName()));
        }
        if ((domainEndpointOptions = updateDomainEndpointOptionsRequest.getDomainEndpointOptions()) != null) {
            if (domainEndpointOptions.getEnforceHTTPS() != null) {
                request.addParameter("DomainEndpointOptions.EnforceHTTPS", StringUtils.fromBoolean((Boolean)domainEndpointOptions.getEnforceHTTPS()));
            }
            if (domainEndpointOptions.getTLSSecurityPolicy() != null) {
                request.addParameter("DomainEndpointOptions.TLSSecurityPolicy", StringUtils.fromString((String)domainEndpointOptions.getTLSSecurityPolicy()));
            }
        }
        return request;
    }
}

