/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cloudhsmv2.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.cloudhsmv2.model.BackupRetentionPolicy;
import com.amazonaws.services.cloudhsmv2.model.Tag;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class CreateClusterRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private BackupRetentionPolicy backupRetentionPolicy;
    private String hsmType;
    private String sourceBackupId;
    private List<String> subnetIds;
    private List<Tag> tagList;

    public void setBackupRetentionPolicy(BackupRetentionPolicy backupRetentionPolicy) {
        this.backupRetentionPolicy = backupRetentionPolicy;
    }

    public BackupRetentionPolicy getBackupRetentionPolicy() {
        return this.backupRetentionPolicy;
    }

    public CreateClusterRequest withBackupRetentionPolicy(BackupRetentionPolicy backupRetentionPolicy) {
        this.setBackupRetentionPolicy(backupRetentionPolicy);
        return this;
    }

    public void setHsmType(String hsmType) {
        this.hsmType = hsmType;
    }

    public String getHsmType() {
        return this.hsmType;
    }

    public CreateClusterRequest withHsmType(String hsmType) {
        this.setHsmType(hsmType);
        return this;
    }

    public void setSourceBackupId(String sourceBackupId) {
        this.sourceBackupId = sourceBackupId;
    }

    public String getSourceBackupId() {
        return this.sourceBackupId;
    }

    public CreateClusterRequest withSourceBackupId(String sourceBackupId) {
        this.setSourceBackupId(sourceBackupId);
        return this;
    }

    public List<String> getSubnetIds() {
        return this.subnetIds;
    }

    public void setSubnetIds(Collection<String> subnetIds) {
        if (subnetIds == null) {
            this.subnetIds = null;
            return;
        }
        this.subnetIds = new ArrayList<String>(subnetIds);
    }

    public CreateClusterRequest withSubnetIds(String ... subnetIds) {
        if (this.subnetIds == null) {
            this.setSubnetIds(new ArrayList<String>(subnetIds.length));
        }
        for (String ele : subnetIds) {
            this.subnetIds.add(ele);
        }
        return this;
    }

    public CreateClusterRequest withSubnetIds(Collection<String> subnetIds) {
        this.setSubnetIds(subnetIds);
        return this;
    }

    public List<Tag> getTagList() {
        return this.tagList;
    }

    public void setTagList(Collection<Tag> tagList) {
        if (tagList == null) {
            this.tagList = null;
            return;
        }
        this.tagList = new ArrayList<Tag>(tagList);
    }

    public CreateClusterRequest withTagList(Tag ... tagList) {
        if (this.tagList == null) {
            this.setTagList(new ArrayList<Tag>(tagList.length));
        }
        for (Tag ele : tagList) {
            this.tagList.add(ele);
        }
        return this;
    }

    public CreateClusterRequest withTagList(Collection<Tag> tagList) {
        this.setTagList(tagList);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getBackupRetentionPolicy() != null) {
            sb.append("BackupRetentionPolicy: ").append(this.getBackupRetentionPolicy()).append(",");
        }
        if (this.getHsmType() != null) {
            sb.append("HsmType: ").append(this.getHsmType()).append(",");
        }
        if (this.getSourceBackupId() != null) {
            sb.append("SourceBackupId: ").append(this.getSourceBackupId()).append(",");
        }
        if (this.getSubnetIds() != null) {
            sb.append("SubnetIds: ").append(this.getSubnetIds()).append(",");
        }
        if (this.getTagList() != null) {
            sb.append("TagList: ").append(this.getTagList());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateClusterRequest)) {
            return false;
        }
        CreateClusterRequest other = (CreateClusterRequest)obj;
        if (other.getBackupRetentionPolicy() == null ^ this.getBackupRetentionPolicy() == null) {
            return false;
        }
        if (other.getBackupRetentionPolicy() != null && !other.getBackupRetentionPolicy().equals(this.getBackupRetentionPolicy())) {
            return false;
        }
        if (other.getHsmType() == null ^ this.getHsmType() == null) {
            return false;
        }
        if (other.getHsmType() != null && !other.getHsmType().equals(this.getHsmType())) {
            return false;
        }
        if (other.getSourceBackupId() == null ^ this.getSourceBackupId() == null) {
            return false;
        }
        if (other.getSourceBackupId() != null && !other.getSourceBackupId().equals(this.getSourceBackupId())) {
            return false;
        }
        if (other.getSubnetIds() == null ^ this.getSubnetIds() == null) {
            return false;
        }
        if (other.getSubnetIds() != null && !other.getSubnetIds().equals(this.getSubnetIds())) {
            return false;
        }
        if (other.getTagList() == null ^ this.getTagList() == null) {
            return false;
        }
        return other.getTagList() == null || other.getTagList().equals(this.getTagList());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getBackupRetentionPolicy() == null ? 0 : this.getBackupRetentionPolicy().hashCode());
        hashCode = 31 * hashCode + (this.getHsmType() == null ? 0 : this.getHsmType().hashCode());
        hashCode = 31 * hashCode + (this.getSourceBackupId() == null ? 0 : this.getSourceBackupId().hashCode());
        hashCode = 31 * hashCode + (this.getSubnetIds() == null ? 0 : this.getSubnetIds().hashCode());
        hashCode = 31 * hashCode + (this.getTagList() == null ? 0 : this.getTagList().hashCode());
        return hashCode;
    }

    public CreateClusterRequest clone() {
        return (CreateClusterRequest)super.clone();
    }
}

