/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cloudfront.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.cloudfront.model.ContentTypeProfile;
import com.amazonaws.services.cloudfront.model.ContentTypeProfileConfig;
import com.amazonaws.services.cloudfront.model.ContentTypeProfiles;
import com.amazonaws.services.cloudfront.model.FieldLevelEncryptionConfig;
import com.amazonaws.services.cloudfront.model.QueryArgProfile;
import com.amazonaws.services.cloudfront.model.QueryArgProfileConfig;
import com.amazonaws.services.cloudfront.model.QueryArgProfiles;
import com.amazonaws.services.cloudfront.model.UpdateFieldLevelEncryptionConfigRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.transform.PathMarshallers;
import com.amazonaws.util.StringInputStream;
import com.amazonaws.util.StringUtils;
import com.amazonaws.util.XMLWriter;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;

public class UpdateFieldLevelEncryptionConfigRequestMarshaller
implements Marshaller<Request<UpdateFieldLevelEncryptionConfigRequest>, UpdateFieldLevelEncryptionConfigRequest> {
    public Request<UpdateFieldLevelEncryptionConfigRequest> marshall(UpdateFieldLevelEncryptionConfigRequest updateFieldLevelEncryptionConfigRequest) {
        if (updateFieldLevelEncryptionConfigRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)updateFieldLevelEncryptionConfigRequest, "AmazonCloudFront");
        request.setHttpMethod(HttpMethodName.PUT);
        if (updateFieldLevelEncryptionConfigRequest.getIfMatch() != null) {
            request.addHeader("If-Match", StringUtils.fromString((String)updateFieldLevelEncryptionConfigRequest.getIfMatch()));
        }
        String uriResourcePath = "/2020-05-31/field-level-encryption/{Id}/config";
        uriResourcePath = PathMarshallers.NON_GREEDY.marshall(uriResourcePath, "Id", updateFieldLevelEncryptionConfigRequest.getId());
        request.setResourcePath(uriResourcePath);
        try {
            StringWriter stringWriter = new StringWriter();
            XMLWriter xmlWriter = new XMLWriter((Writer)stringWriter, "http://cloudfront.amazonaws.com/doc/2020-05-31/");
            FieldLevelEncryptionConfig fieldLevelEncryptionConfig = updateFieldLevelEncryptionConfigRequest.getFieldLevelEncryptionConfig();
            if (fieldLevelEncryptionConfig != null) {
                ContentTypeProfileConfig contentTypeProfileConfig;
                QueryArgProfileConfig queryArgProfileConfig;
                xmlWriter.startElement("FieldLevelEncryptionConfig");
                if (fieldLevelEncryptionConfig.getCallerReference() != null) {
                    xmlWriter.startElement("CallerReference").value(fieldLevelEncryptionConfig.getCallerReference()).endElement();
                }
                if (fieldLevelEncryptionConfig.getComment() != null) {
                    xmlWriter.startElement("Comment").value(fieldLevelEncryptionConfig.getComment()).endElement();
                }
                if ((queryArgProfileConfig = fieldLevelEncryptionConfig.getQueryArgProfileConfig()) != null) {
                    QueryArgProfiles queryArgProfiles;
                    xmlWriter.startElement("QueryArgProfileConfig");
                    if (queryArgProfileConfig.getForwardWhenQueryArgProfileIsUnknown() != null) {
                        xmlWriter.startElement("ForwardWhenQueryArgProfileIsUnknown").value((Object)queryArgProfileConfig.getForwardWhenQueryArgProfileIsUnknown()).endElement();
                    }
                    if ((queryArgProfiles = queryArgProfileConfig.getQueryArgProfiles()) != null) {
                        SdkInternalList queryArgProfilesItemsList;
                        xmlWriter.startElement("QueryArgProfiles");
                        if (queryArgProfiles.getQuantity() != null) {
                            xmlWriter.startElement("Quantity").value((Object)queryArgProfiles.getQuantity()).endElement();
                        }
                        if (!(queryArgProfilesItemsList = (SdkInternalList)queryArgProfiles.getItems()).isEmpty() || !queryArgProfilesItemsList.isAutoConstruct()) {
                            xmlWriter.startElement("Items");
                            for (QueryArgProfile queryArgProfilesItemsListValue : queryArgProfilesItemsList) {
                                xmlWriter.startElement("QueryArgProfile");
                                if (queryArgProfilesItemsListValue.getQueryArg() != null) {
                                    xmlWriter.startElement("QueryArg").value(queryArgProfilesItemsListValue.getQueryArg()).endElement();
                                }
                                if (queryArgProfilesItemsListValue.getProfileId() != null) {
                                    xmlWriter.startElement("ProfileId").value(queryArgProfilesItemsListValue.getProfileId()).endElement();
                                }
                                xmlWriter.endElement();
                            }
                            xmlWriter.endElement();
                        }
                        xmlWriter.endElement();
                    }
                    xmlWriter.endElement();
                }
                if ((contentTypeProfileConfig = fieldLevelEncryptionConfig.getContentTypeProfileConfig()) != null) {
                    ContentTypeProfiles contentTypeProfiles;
                    xmlWriter.startElement("ContentTypeProfileConfig");
                    if (contentTypeProfileConfig.getForwardWhenContentTypeIsUnknown() != null) {
                        xmlWriter.startElement("ForwardWhenContentTypeIsUnknown").value((Object)contentTypeProfileConfig.getForwardWhenContentTypeIsUnknown()).endElement();
                    }
                    if ((contentTypeProfiles = contentTypeProfileConfig.getContentTypeProfiles()) != null) {
                        SdkInternalList contentTypeProfilesItemsList;
                        xmlWriter.startElement("ContentTypeProfiles");
                        if (contentTypeProfiles.getQuantity() != null) {
                            xmlWriter.startElement("Quantity").value((Object)contentTypeProfiles.getQuantity()).endElement();
                        }
                        if (!(contentTypeProfilesItemsList = (SdkInternalList)contentTypeProfiles.getItems()).isEmpty() || !contentTypeProfilesItemsList.isAutoConstruct()) {
                            xmlWriter.startElement("Items");
                            for (ContentTypeProfile contentTypeProfilesItemsListValue : contentTypeProfilesItemsList) {
                                xmlWriter.startElement("ContentTypeProfile");
                                if (contentTypeProfilesItemsListValue.getFormat() != null) {
                                    xmlWriter.startElement("Format").value(contentTypeProfilesItemsListValue.getFormat()).endElement();
                                }
                                if (contentTypeProfilesItemsListValue.getProfileId() != null) {
                                    xmlWriter.startElement("ProfileId").value(contentTypeProfilesItemsListValue.getProfileId()).endElement();
                                }
                                if (contentTypeProfilesItemsListValue.getContentType() != null) {
                                    xmlWriter.startElement("ContentType").value(contentTypeProfilesItemsListValue.getContentType()).endElement();
                                }
                                xmlWriter.endElement();
                            }
                            xmlWriter.endElement();
                        }
                        xmlWriter.endElement();
                    }
                    xmlWriter.endElement();
                }
                xmlWriter.endElement();
            }
            request.setContent((InputStream)new StringInputStream(stringWriter.getBuffer().toString()));
            request.addHeader("Content-Length", Integer.toString(stringWriter.getBuffer().toString().getBytes(StringUtils.UTF8).length));
            if (!request.getHeaders().containsKey("Content-Type")) {
                request.addHeader("Content-Type", "application/xml");
            }
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to XML: " + t.getMessage(), t);
        }
        return request;
    }
}

