/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cloudfront.model.transform;

import com.amazonaws.services.cloudfront.model.CachePolicyList;
import com.amazonaws.services.cloudfront.model.CachePolicySummary;
import com.amazonaws.services.cloudfront.model.transform.CachePolicySummaryStaxUnmarshaller;
import com.amazonaws.transform.SimpleTypeStaxUnmarshallers;
import com.amazonaws.transform.StaxUnmarshallerContext;
import com.amazonaws.transform.Unmarshaller;
import java.util.ArrayList;
import javax.xml.stream.events.XMLEvent;

public class CachePolicyListStaxUnmarshaller
implements Unmarshaller<CachePolicyList, StaxUnmarshallerContext> {
    private static CachePolicyListStaxUnmarshaller instance;

    public CachePolicyList unmarshall(StaxUnmarshallerContext context) throws Exception {
        CachePolicyList cachePolicyList = new CachePolicyList();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (true) {
            XMLEvent xmlEvent;
            if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                return cachePolicyList;
            }
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("NextMarker", targetDepth)) {
                    cachePolicyList.setNextMarker(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("MaxItems", targetDepth)) {
                    cachePolicyList.setMaxItems(SimpleTypeStaxUnmarshallers.IntegerStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("Quantity", targetDepth)) {
                    cachePolicyList.setQuantity(SimpleTypeStaxUnmarshallers.IntegerStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("Items", targetDepth)) {
                    cachePolicyList.withItems(new ArrayList<CachePolicySummary>());
                    continue;
                }
                if (!context.testExpression("Items/CachePolicySummary", targetDepth)) continue;
                cachePolicyList.withItems(CachePolicySummaryStaxUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
        }
        return cachePolicyList;
    }

    public static CachePolicyListStaxUnmarshaller getInstance() {
        if (instance == null) {
            instance = new CachePolicyListStaxUnmarshaller();
        }
        return instance;
    }
}

