/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cloudfront;

import com.amazonaws.AmazonClientException;
import com.amazonaws.services.cloudfront.util.SignerUtils;
import com.amazonaws.util.StringUtils;
import java.io.File;
import java.io.IOException;
import java.security.InvalidKeyException;
import java.security.PrivateKey;
import java.security.spec.InvalidKeySpecException;
import java.util.Date;
import java.util.concurrent.TimeUnit;

public enum CloudFrontUrlSigner {


    public static String getSignedURLWithCannedPolicy(SignerUtils.Protocol protocol, String distributionDomain, File privateKeyFile, String s3ObjectKey, String keyPairId, Date dateLessThan) throws InvalidKeySpecException, IOException {
        String resourcePath = SignerUtils.generateResourcePath(protocol, distributionDomain, s3ObjectKey);
        PrivateKey privateKey = SignerUtils.loadPrivateKey(privateKeyFile);
        return CloudFrontUrlSigner.getSignedURLWithCannedPolicy(resourcePath, keyPairId, privateKey, dateLessThan);
    }

    public static String getSignedURLWithCustomPolicy(SignerUtils.Protocol protocol, String distributionDomain, File privateKeyFile, String s3ObjectKey, String keyPairId, Date dateLessThan, Date dateGreaterThan, String ipRange) throws InvalidKeySpecException, IOException {
        PrivateKey privateKey = SignerUtils.loadPrivateKey(privateKeyFile);
        String resourcePath = SignerUtils.generateResourcePath(protocol, distributionDomain, s3ObjectKey);
        String policy = CloudFrontUrlSigner.buildCustomPolicyForSignedUrl(resourcePath, dateLessThan, ipRange, dateGreaterThan);
        return CloudFrontUrlSigner.getSignedURLWithCustomPolicy(resourcePath, keyPairId, privateKey, policy);
    }

    public static String getSignedURLWithCustomPolicy(String resourceUrlOrPath, String keyPairId, PrivateKey privateKey, String policy) {
        try {
            byte[] signatureBytes = SignerUtils.signWithSha1RSA(policy.getBytes(StringUtils.UTF8), privateKey);
            String urlSafePolicy = SignerUtils.makeStringUrlSafe(policy);
            String urlSafeSignature = SignerUtils.makeBytesUrlSafe(signatureBytes);
            String signedUrl = resourceUrlOrPath + (resourceUrlOrPath.indexOf(63) >= 0 ? "&" : "?") + "Policy=" + urlSafePolicy + "&Signature=" + urlSafeSignature + "&Key-Pair-Id=" + keyPairId;
            return signedUrl;
        }
        catch (InvalidKeyException e) {
            throw new AmazonClientException("Couldn't sign url", (Throwable)e);
        }
    }

    public static String getSignedURLWithCannedPolicy(String resourceUrlOrPath, String keyPairId, PrivateKey privateKey, Date dateLessThan) {
        try {
            String cannedPolicy = SignerUtils.buildCannedPolicy(resourceUrlOrPath, dateLessThan);
            byte[] signatureBytes = SignerUtils.signWithSha1RSA(cannedPolicy.getBytes(StringUtils.UTF8), privateKey);
            String urlSafeSignature = SignerUtils.makeBytesUrlSafe(signatureBytes);
            String signedUrl = resourceUrlOrPath + (resourceUrlOrPath.indexOf(63) >= 0 ? "&" : "?") + "Expires=" + TimeUnit.MILLISECONDS.toSeconds(dateLessThan.getTime()) + "&Signature=" + urlSafeSignature + "&Key-Pair-Id=" + keyPairId;
            return signedUrl;
        }
        catch (InvalidKeyException e) {
            throw new AmazonClientException("Couldn't sign url", (Throwable)e);
        }
    }

    public static String buildCustomPolicyForSignedUrl(String resourcePath, Date epochDateLessThan, String limitToIpAddressCIDR, Date epochDateGreaterThan) {
        if (epochDateLessThan == null) {
            throw new AmazonClientException("epochDateLessThan must be provided to sign CloudFront URLs");
        }
        if (resourcePath == null) {
            resourcePath = "*";
        }
        String ipAddress = limitToIpAddressCIDR == null ? "0.0.0.0/0" : limitToIpAddressCIDR;
        return SignerUtils.buildCustomPolicy(resourcePath, epochDateLessThan, epochDateGreaterThan, ipAddress);
    }
}

