/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cloudformation.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.cloudformation.model.ListTypesRequest;
import com.amazonaws.services.cloudformation.model.TypeFilters;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class ListTypesRequestMarshaller
implements Marshaller<Request<ListTypesRequest>, ListTypesRequest> {
    public Request<ListTypesRequest> marshall(ListTypesRequest listTypesRequest) {
        TypeFilters filters;
        if (listTypesRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)listTypesRequest, "AmazonCloudFormation");
        request.addParameter("Action", "ListTypes");
        request.addParameter("Version", "2010-05-15");
        request.setHttpMethod(HttpMethodName.POST);
        if (listTypesRequest.getVisibility() != null) {
            request.addParameter("Visibility", StringUtils.fromString((String)listTypesRequest.getVisibility()));
        }
        if (listTypesRequest.getProvisioningType() != null) {
            request.addParameter("ProvisioningType", StringUtils.fromString((String)listTypesRequest.getProvisioningType()));
        }
        if (listTypesRequest.getDeprecatedStatus() != null) {
            request.addParameter("DeprecatedStatus", StringUtils.fromString((String)listTypesRequest.getDeprecatedStatus()));
        }
        if (listTypesRequest.getType() != null) {
            request.addParameter("Type", StringUtils.fromString((String)listTypesRequest.getType()));
        }
        if ((filters = listTypesRequest.getFilters()) != null) {
            if (filters.getCategory() != null) {
                request.addParameter("Filters.Category", StringUtils.fromString((String)filters.getCategory()));
            }
            if (filters.getPublisherId() != null) {
                request.addParameter("Filters.PublisherId", StringUtils.fromString((String)filters.getPublisherId()));
            }
            if (filters.getTypeNamePrefix() != null) {
                request.addParameter("Filters.TypeNamePrefix", StringUtils.fromString((String)filters.getTypeNamePrefix()));
            }
        }
        if (listTypesRequest.getMaxResults() != null) {
            request.addParameter("MaxResults", StringUtils.fromInteger((Integer)listTypesRequest.getMaxResults()));
        }
        if (listTypesRequest.getNextToken() != null) {
            request.addParameter("NextToken", StringUtils.fromString((String)listTypesRequest.getNextToken()));
        }
        return request;
    }
}

