/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cloudformation.model.transform;

import com.amazonaws.services.cloudformation.model.AutoDeployment;
import com.amazonaws.transform.SimpleTypeStaxUnmarshallers;
import com.amazonaws.transform.StaxUnmarshallerContext;
import com.amazonaws.transform.Unmarshaller;
import javax.xml.stream.events.XMLEvent;

public class AutoDeploymentStaxUnmarshaller
implements Unmarshaller<AutoDeployment, StaxUnmarshallerContext> {
    private static AutoDeploymentStaxUnmarshaller instance;

    public AutoDeployment unmarshall(StaxUnmarshallerContext context) throws Exception {
        AutoDeployment autoDeployment = new AutoDeployment();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (true) {
            XMLEvent xmlEvent;
            if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                return autoDeployment;
            }
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("Enabled", targetDepth)) {
                    autoDeployment.setEnabled(SimpleTypeStaxUnmarshallers.BooleanStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (!context.testExpression("RetainStacksOnAccountRemoval", targetDepth)) continue;
                autoDeployment.setRetainStacksOnAccountRemoval(SimpleTypeStaxUnmarshallers.BooleanStaxUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
        }
        return autoDeployment;
    }

    public static AutoDeploymentStaxUnmarshaller getInstance() {
        if (instance == null) {
            instance = new AutoDeploymentStaxUnmarshaller();
        }
        return instance;
    }
}

