/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cloudformation.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.cloudformation.model.DeleteStackRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class DeleteStackRequestMarshaller
implements Marshaller<Request<DeleteStackRequest>, DeleteStackRequest> {
    public Request<DeleteStackRequest> marshall(DeleteStackRequest deleteStackRequest) {
        SdkInternalList retainResourcesList;
        if (deleteStackRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)deleteStackRequest, "AmazonCloudFormation");
        request.addParameter("Action", "DeleteStack");
        request.addParameter("Version", "2010-05-15");
        request.setHttpMethod(HttpMethodName.POST);
        if (deleteStackRequest.getStackName() != null) {
            request.addParameter("StackName", StringUtils.fromString((String)deleteStackRequest.getStackName()));
        }
        if (!(retainResourcesList = (SdkInternalList)deleteStackRequest.getRetainResources()).isEmpty() || !retainResourcesList.isAutoConstruct()) {
            int retainResourcesListIndex = 1;
            for (String retainResourcesListValue : retainResourcesList) {
                if (retainResourcesListValue != null) {
                    request.addParameter("RetainResources.member." + retainResourcesListIndex, StringUtils.fromString((String)retainResourcesListValue));
                }
                ++retainResourcesListIndex;
            }
        }
        return request;
    }
}

